/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.rhq.plugin;

import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedCommon;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.GenericValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.pluginapi.inventory.DiscoveredResourceDetails;
import org.rhq.core.pluginapi.inventory.InvalidPluginConfigurationException;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryComponent;
import org.rhq.core.pluginapi.inventory.ResourceDiscoveryContext;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.teiid.rhq.plugin.PlatformComponent;
import org.teiid.rhq.plugin.util.ProfileServiceUtil;

public class VDBDiscoveryComponent
implements ResourceDiscoveryComponent {
    private final Log log = LogFactory.getLog((String)"org.rhq");

    public Set<DiscoveredResourceDetails> discoverResources(ResourceDiscoveryContext discoveryContext) throws InvalidPluginConfigurationException, Exception {
        HashSet<DiscoveredResourceDetails> discoveredResources = new HashSet<DiscoveredResourceDetails>();
        ProfileServiceConnection connection = ((PlatformComponent)discoveryContext.getParentResourceComponent()).getConnection();
        Set<ManagedComponent> vdbs = ProfileServiceUtil.getManagedComponents(connection, new ComponentType("teiid", "vdb"));
        PropertySimple displayPreviewVdbs = ((PlatformComponent)discoveryContext.getParentResourceComponent()).getResourceConfiguration().getSimple("displayPreviewVDBS");
        for (ManagedComponent mcVdb : vdbs) {
            String vdbKey;
            boolean skipVdb = false;
            if (!displayPreviewVdbs.getBooleanValue().booleanValue()) {
                MetaValue[] propsArray = ((CollectionValueSupport)mcVdb.getProperty("JAXBProperties").getValue()).getElements();
                String isPreview = "false";
                for (MetaValue propertyMetaData : propsArray) {
                    GenericValueSupport genValueSupport = (GenericValueSupport)propertyMetaData;
                    ManagedObjectImpl managedObject = (ManagedObjectImpl)genValueSupport.getValue();
                    String propertyName = ProfileServiceUtil.getSimpleValue((ManagedCommon)managedObject, "name", String.class);
                    if (!propertyName.equals("preview")) continue;
                    isPreview = ProfileServiceUtil.getSimpleValue((ManagedCommon)managedObject, "value", String.class);
                    if (!Boolean.valueOf(isPreview).booleanValue()) break;
                    skipVdb = true;
                    break;
                }
            }
            if (skipVdb) continue;
            String vdbName = vdbKey = mcVdb.getName();
            String fullName = ProfileServiceUtil.getSimpleValue(mcVdb, "fullName", String.class);
            Integer vdbVersion = ProfileServiceUtil.getSimpleValue(mcVdb, "version", Integer.class);
            String vdbDescription = ProfileServiceUtil.getSimpleValue(mcVdb, "description", String.class);
            String vdbStatus = ProfileServiceUtil.getSimpleValue(mcVdb, "status", String.class);
            String vdbURL = ProfileServiceUtil.getSimpleValue(mcVdb, "url", String.class);
            DiscoveredResourceDetails detail = new DiscoveredResourceDetails(discoveryContext.getResourceType(), vdbKey, vdbName, vdbVersion.toString(), "Teiid Virtual Database (VDB)", discoveryContext.getDefaultPluginConfiguration(), null);
            Configuration configuration = detail.getPluginConfiguration();
            configuration.put((Property)new PropertySimple("name", (Object)vdbName));
            configuration.put((Property)new PropertySimple("fullName", (Object)fullName));
            configuration.put((Property)new PropertySimple("version", (Object)vdbVersion));
            configuration.put((Property)new PropertySimple("description", (Object)vdbDescription));
            configuration.put((Property)new PropertySimple("status", (Object)vdbStatus));
            configuration.put((Property)new PropertySimple("url", (Object)vdbURL));
            detail.setPluginConfiguration(configuration);
            discoveredResources.add(detail);
            this.log.debug((Object)("Discovered Teiid VDB: " + vdbName));
        }
        return discoveredResources;
    }
}

