/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.rhq.plugin.adapter.api;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.metatype.api.values.MetaValue;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.teiid.rhq.plugin.adapter.api.PropertyAdapter;

public abstract class AbstractPropertySimpleAdapter
implements PropertyAdapter<PropertySimple, PropertyDefinitionSimple> {
    private final Log log = LogFactory.getLog((String)"org.rhq");

    @Override
    public PropertySimple convertToProperty(MetaValue metaValue, PropertyDefinitionSimple propDefSimple) {
        PropertySimple propSimple = new PropertySimple(propDefSimple.getName(), null);
        this.populatePropertyFromMetaValue(propSimple, metaValue, propDefSimple);
        return propSimple;
    }

    @Override
    public void populateMetaValueFromProperty(PropertySimple propSimple, MetaValue metaValue, PropertyDefinitionSimple propDefSimple) {
        String value;
        if (metaValue == null) {
            throw new IllegalArgumentException("MetaValue to be populated is null.");
        }
        if (propSimple == null || propSimple.getStringValue() == null) {
            String defaultValue = propDefSimple.getDefaultValue();
            if (defaultValue != null) {
                this.log.debug((Object)("Simple property '" + propDefSimple.getName() + "' has a null value - setting inner value of corresponding ManagedProperty's MetaValue to plugin-specified default ('" + defaultValue + "')..."));
                value = defaultValue;
            } else {
                if (metaValue.getMetaType().isPrimitive()) {
                    return;
                }
                this.log.debug((Object)("Simple property '" + propDefSimple.getName() + "' has a null value - setting inner value of corresponding ManagedProperty's MetaValue to null..."));
                value = null;
            }
        } else {
            value = propSimple.getStringValue();
        }
        this.setInnerValue(value, metaValue, propDefSimple);
    }

    protected abstract void setInnerValue(String var1, MetaValue var2, PropertyDefinitionSimple var3);
}

