/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.rhq.plugin.deployer;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.content.ContentContext;
import org.rhq.core.pluginapi.content.ContentServices;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.rhq.plugins.jbossas5.util.ManagedComponentUtils;
import org.teiid.rhq.plugin.deployer.AbstractDeployer;

public class RemoteDeployer
extends AbstractDeployer {
    private ResourceContext<?> resourceContext;

    public RemoteDeployer(ProfileServiceConnection profileServiceConnection, ResourceContext<?> resourceContext) {
        super(profileServiceConnection);
        this.resourceContext = resourceContext;
    }

    @Override
    protected void destroyArchive(File archive) {
        File tempDir = archive.getParentFile();
        archive.delete();
        tempDir.delete();
    }

    @Override
    protected File prepareArchive(PackageDetailsKey key, ResourceType resourceType) {
        OutputStream os = null;
        try {
            File tempDir = RemoteDeployer.createTempDirectory("teiid-deploy-content", null, this.getServerTempDirectory());
            File archiveFile = new File(key.getName());
            File contentCopy = new File(tempDir, archiveFile.getName());
            os = new BufferedOutputStream(new FileOutputStream(contentCopy));
            ContentContext contentContext = this.resourceContext.getContentContext();
            ContentServices contentServices = contentContext.getContentServices();
            contentServices.downloadPackageBitsForChildResource(contentContext, resourceType.getName(), key, os);
            File file = contentCopy;
            return file;
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to copy the deployed archive to destination.", e);
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    this.getLog().warn((Object)"Failed to close the stream when copying deployment to destination.");
                }
            }
        }
    }

    private File getServerTempDirectory() {
        ManagementView managementView = this.getProfileServiceConnection().getManagementView();
        ManagedComponent serverConfigComponent = ManagedComponentUtils.getSingletonManagedComponent((ManagementView)managementView, (ComponentType)new ComponentType("MCBean", "ServerConfig"));
        String serverTempDir = (String)((Object)ManagedComponentUtils.getSimplePropertyValue((ManagedComponent)serverConfigComponent, (String)"serverTempDir"));
        return new File(serverTempDir);
    }

    private static File createTempDirectory(String prefix, String suffix, File parentDirectory) throws IOException {
        File tmpDir = File.createTempFile(prefix, suffix, parentDirectory);
        boolean deleteOk = tmpDir.delete();
        boolean mkdirsOk = tmpDir.mkdirs();
        if (!deleteOk || !mkdirsOk) {
            throw new IOException("Failed to create temp directory named [" + tmpDir + "]");
        }
        return tmpDir;
    }
}

