/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.rhq.plugin.util;

import com.sun.istack.NotNull;
import java.io.File;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.KnownDeploymentTypes;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedCommon;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedDeployment;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.metatype.api.types.MapCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.SimpleMetaType;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.jboss.profileservice.spi.ProfileService;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.ConfigurationDefinition;
import org.rhq.core.domain.configuration.definition.ConfigurationTemplate;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionList;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.rhq.core.domain.configuration.definition.PropertySimpleType;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.teiid.rhq.plugin.adapter.api.PropertyAdapter;
import org.teiid.rhq.plugin.adapter.api.PropertyAdapterFactory;

public class ProfileServiceUtil {
    protected static final Log LOG = LogFactory.getLog((String)"org.rhq");
    private static ComponentType DQPTYPE = new ComponentType("teiid", "dqp");
    private static String DQPNAME = "RuntimeEngineDeployer";
    private static String BUFFERSERVICE = "BufferService";
    private static final Map<String, ComponentType> COMPONENT_TYPE_CACHE = new HashMap<String, ComponentType>();
    protected static final String PLUGIN = "ProfileService";

    public static ComponentType getComponentType(@NotNull ResourceType resourceType) {
        String resourceTypeName = resourceType.getName();
        if (COMPONENT_TYPE_CACHE.containsKey(resourceTypeName)) {
            return COMPONENT_TYPE_CACHE.get(resourceTypeName);
        }
        Configuration defaultPluginConfig = ProfileServiceUtil.getDefaultPluginConfiguration(resourceType);
        String type = defaultPluginConfig.getSimpleValue("componentType", null);
        if (type == null || type.equals("")) {
            throw new IllegalStateException("Required plugin configuration property 'componentType' is not defined in default template.");
        }
        String subtype = defaultPluginConfig.getSimpleValue("componentSubtype", null);
        if (subtype == null || subtype.equals("")) {
            throw new IllegalStateException("Required plugin configuration property 'componentSubtype' is not defined in default template.");
        }
        ComponentType componentType = new ComponentType(type, subtype);
        COMPONENT_TYPE_CACHE.put(resourceTypeName, componentType);
        return componentType;
    }

    private static Configuration getDefaultPluginConfiguration(ResourceType resourceType) {
        ConfigurationTemplate pluginConfigDefaultTemplate = resourceType.getPluginConfigurationDefinition().getDefaultTemplate();
        return pluginConfigDefaultTemplate != null ? pluginConfigDefaultTemplate.createConfiguration() : new Configuration();
    }

    public static boolean isManagedComponent(ProfileServiceConnection connection, String name, ComponentType componentType) {
        boolean isDeployed = false;
        if (name != null) {
            try {
                ManagedComponent component = ProfileServiceUtil.getManagedComponent(connection, componentType, name);
                if (component != null) {
                    isDeployed = true;
                }
            }
            catch (Exception e) {
                isDeployed = true;
            }
        }
        return isDeployed;
    }

    public static ManagedComponent getManagedComponent(ProfileServiceConnection connection, ComponentType componentType, String componentName) throws NamingException, Exception {
        ManagedComponent mc = connection.getManagementView().getComponent(componentName, componentType);
        return mc;
    }

    public static Set<ManagedComponent> getManagedComponents(ProfileServiceConnection connection, ComponentType componentType) throws NamingException, Exception {
        Set mcSet = connection.getManagementView().getComponentsForType(componentType);
        return mcSet;
    }

    public static ManagementView getManagementView(ProfileService ps, boolean load) {
        ManagementView mv = ps.getViewManager();
        if (load) {
            mv.load();
        }
        return mv;
    }

    public static DeploymentManager getDeploymentManager(ProfileServiceConnection connection) throws NamingException, Exception {
        return connection.getDeploymentManager();
    }

    public static File getDeployDirectory(ProfileServiceConnection connection) throws NamingException, Exception {
        URL warUrl;
        Set warDeployments;
        try {
            warDeployments = connection.getManagementView().getDeploymentsForType(KnownDeploymentTypes.JavaEEWebApplication.getType());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        ManagedDeployment standaloneWarDeployment = null;
        for (ManagedDeployment warDeployment : warDeployments) {
            if (warDeployment.getParent() != null) continue;
            standaloneWarDeployment = warDeployment;
            break;
        }
        if (standaloneWarDeployment == null) {
            return null;
        }
        try {
            warUrl = new URL(standaloneWarDeployment.getName());
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        File warFile = new File(warUrl.getPath());
        File deployDir = warFile.getParentFile();
        return deployDir;
    }

    public static ManagedComponent getRuntimeEngineDeployer(ProfileServiceConnection connection) throws NamingException, Exception {
        return ProfileServiceUtil.getManagedComponent(connection, DQPTYPE, DQPNAME);
    }

    public static ManagedComponent getBufferService(ProfileServiceConnection connection) throws NamingException, Exception {
        return ProfileServiceUtil.getManagedComponent(connection, DQPTYPE, BUFFERSERVICE);
    }

    public static String stringValue(MetaValue v1) throws Exception {
        if (v1 != null) {
            MetaType type = v1.getMetaType();
            if (type instanceof SimpleMetaType) {
                SimpleValue simple = (SimpleValue)v1;
                return simple.getValue().toString();
            }
            throw new Exception("Failed to convert value to string value");
        }
        return null;
    }

    public static Boolean booleanValue(MetaValue v1) throws Exception {
        if (v1 != null) {
            MetaType type = v1.getMetaType();
            if (type instanceof SimpleMetaType) {
                SimpleValue simple = (SimpleValue)v1;
                return Boolean.valueOf(simple.getValue().toString());
            }
            throw new Exception("Failed to convert value to boolean value");
        }
        return null;
    }

    public static Double doubleValue(MetaValue v1) throws Exception {
        if (v1 != null) {
            MetaType type = v1.getMetaType();
            if (type instanceof SimpleMetaType) {
                SimpleValue simple = (SimpleValue)v1;
                return Double.valueOf(simple.getValue().toString());
            }
            throw new Exception("Failed to convert value to double value");
        }
        return null;
    }

    public static Long longValue(MetaValue v1) throws Exception {
        if (v1 != null) {
            MetaType type = v1.getMetaType();
            if (type instanceof SimpleMetaType) {
                SimpleValue simple = (SimpleValue)v1;
                return Long.valueOf(simple.getValue().toString());
            }
            throw new Exception("Failed to convert value to long value");
        }
        return null;
    }

    public static Integer integerValue(MetaValue v1) throws Exception {
        if (v1 != null) {
            MetaType type = v1.getMetaType();
            if (type instanceof SimpleMetaType) {
                SimpleValue simple = (SimpleValue)v1;
                return Integer.valueOf(simple.getValue().toString());
            }
            throw new Exception("Failed to convert value to integer value");
        }
        return null;
    }

    public static <T> T getSimpleValue(ManagedComponent mc, String prop, Class<T> expectedType) {
        ManagedProperty mp = mc.getProperty(prop);
        if (mp != null) {
            MetaType metaType = mp.getMetaType();
            if (metaType.isSimple()) {
                SimpleValue simpleValue = (SimpleValue)mp.getValue();
                return expectedType.cast(simpleValue != null ? simpleValue.getValue() : null);
            }
            if (metaType.isEnum()) {
                EnumValue enumValue = (EnumValue)mp.getValue();
                return expectedType.cast(enumValue != null ? enumValue.getValue() : null);
            }
            throw new IllegalStateException(prop + " is not a simple type");
        }
        return null;
    }

    public static <T> T getSimpleValue(MetaValue prop, Class<T> expectedType) {
        if (prop != null) {
            MetaType metaType = prop.getMetaType();
            if (metaType.isSimple()) {
                SimpleValue simpleValue = (SimpleValue)prop;
                return expectedType.cast(simpleValue != null ? simpleValue.getValue() : null);
            }
            if (metaType.isEnum()) {
                EnumValue enumValue = (EnumValue)prop;
                return expectedType.cast(enumValue != null ? enumValue.getValue() : null);
            }
            throw new IllegalStateException(prop + " is not a simple type");
        }
        return null;
    }

    public static <T> T getSimpleValue(ManagedCommon mc, String prop, Class<T> expectedType) {
        ManagedProperty mp = mc.getProperty(prop);
        if (mp != null) {
            MetaType metaType = mp.getMetaType();
            if (metaType.isSimple()) {
                SimpleValue simpleValue = (SimpleValue)mp.getValue();
                return expectedType.cast(simpleValue != null ? simpleValue.getValue() : null);
            }
            if (metaType.isEnum()) {
                EnumValue enumValue = (EnumValue)mp.getValue();
                return expectedType.cast(enumValue != null ? enumValue.getValue() : null);
            }
            throw new IllegalArgumentException(prop + " is not a simple type");
        }
        return null;
    }

    public static Map<String, PropertySimple> getCustomProperties(Configuration pluginConfig) {
        LinkedHashMap<String, PropertySimple> customProperties = new LinkedHashMap<String, PropertySimple>();
        if (pluginConfig == null) {
            return customProperties;
        }
        PropertyMap customPropsMap = pluginConfig.getMap("custom-properties");
        if (customPropsMap != null) {
            Collection customProps = customPropsMap.getMap().values();
            for (Property customProp : customProps) {
                if (!(customProp instanceof PropertySimple)) {
                    LOG.error((Object)("Custom property definitions in plugin configuration must be simple properties - property " + customProp + " is not - ignoring..."));
                    continue;
                }
                customProperties.put(customProp.getName(), (PropertySimple)customProp);
            }
        }
        return customProperties;
    }

    public static Configuration convertManagedObjectToConfiguration(Map<String, ManagedProperty> managedProperties, Map<String, PropertySimple> customProps, ResourceType resourceType) {
        Configuration config = new Configuration();
        ConfigurationDefinition configDef = resourceType.getResourceConfigurationDefinition();
        Map propDefs = configDef.getPropertyDefinitions();
        Set<String> propNames = managedProperties.keySet();
        for (String propName : propNames) {
            PropertyDefinition propertyDefinition = (PropertyDefinition)propDefs.get(propName);
            ManagedProperty managedProperty = managedProperties.get(propName);
            if (propertyDefinition == null) {
                if (managedProperty.hasViewUse(ViewUse.STATISTIC)) continue;
                LOG.debug((Object)(resourceType + " does not define a property corresponding to ManagedProperty '" + propName + "'."));
                continue;
            }
            if (managedProperty == null) {
                LOG.error((Object)("ManagedProperty '" + propName + "' has a null value in the ManagedProperties Map."));
                continue;
            }
            MetaValue metaValue = managedProperty.getValue();
            if (managedProperty.isRemoved() || metaValue == null) continue;
            PropertySimple customProp = customProps.get(propName);
            PropertyAdapter propertyAdapter = PropertyAdapterFactory.getCustomPropertyAdapter(customProp);
            if (propertyAdapter == null) {
                propertyAdapter = PropertyAdapterFactory.getPropertyAdapter(metaValue);
            }
            if (propertyAdapter == null) {
                LOG.error((Object)("Unable to find a PropertyAdapter for ManagedProperty '" + propName + "' with MetaType [" + metaValue.getMetaType() + "] for ResourceType '" + resourceType.getName() + "'."));
                continue;
            }
            Object property = propertyAdapter.convertToProperty(metaValue, propertyDefinition);
            config.put(property);
        }
        return config;
    }

    public static void convertConfigurationToManagedProperties(Map<String, ManagedProperty> managedProperties, Configuration configuration, ResourceType resourceType, String prefix) {
        ConfigurationDefinition configDefinition = resourceType.getResourceConfigurationDefinition();
        for (ManagedProperty managedProperty : managedProperties.values()) {
            PropertyDefinition propertyDefinition;
            String propertyName = managedProperty.getName();
            if (prefix != null) {
                propertyName = prefix + "." + propertyName;
            }
            if ((propertyDefinition = configDefinition.get(propertyName)) == null) continue;
            ProfileServiceUtil.populateManagedPropertyFromProperty(managedProperty, propertyDefinition, configuration);
        }
    }

    public static void populateManagedPropertyFromProperty(ManagedProperty managedProperty, PropertyDefinition propertyDefinition, Configuration configuration) {
        MetaValue defaultValue = managedProperty.getDefaultValue();
        if (defaultValue != null) {
            ProfileServiceUtil.updateDefaultValueOnPropertyDefinition(propertyDefinition, defaultValue);
        }
        MetaValue metaValue = managedProperty.getValue();
        PropertyAdapter propertyAdapter = null;
        if (metaValue != null) {
            LOG.trace((Object)("Populating existing MetaValue of type " + metaValue.getMetaType() + " from Teiid property " + propertyDefinition.getName() + " with definition " + propertyDefinition + "..."));
            propertyAdapter = PropertyAdapterFactory.getPropertyAdapter(metaValue);
            propertyAdapter.populateMetaValueFromProperty(configuration.getSimple(propertyDefinition.getName()), metaValue, propertyDefinition);
            managedProperty.setValue(metaValue);
        } else {
            MetaType metaType = managedProperty.getMetaType();
            propertyAdapter = PropertyAdapterFactory.getPropertyAdapter(metaType);
            LOG.trace((Object)("Converting property " + propertyDefinition.getName() + " with definition " + propertyDefinition + " to MetaValue of type " + metaType + "..."));
            metaValue = propertyAdapter.convertToMetaValue(configuration.getSimple(propertyDefinition.getName()), propertyDefinition, metaType);
            managedProperty.setValue(metaValue);
        }
    }

    private static void updateDefaultValueOnPropertyDefinition(PropertyDefinition propertyDefinition, @NotNull MetaValue defaultValue) {
        if (!(propertyDefinition instanceof PropertyDefinitionSimple)) {
            LOG.debug((Object)("Cannot update default value on non-simple property definition " + propertyDefinition + "(default value is " + defaultValue + ")."));
            return;
        }
        MetaType metaType = defaultValue.getMetaType();
        if (!metaType.isSimple() && !metaType.isEnum()) {
            LOG.debug((Object)("Cannot update default value on " + propertyDefinition + ", because default value's type (" + metaType + ") is not simple or enum."));
            return;
        }
        PropertyDefinitionSimple propertyDefinitionSimple = (PropertyDefinitionSimple)propertyDefinition;
        if (metaType.isSimple()) {
            SimpleValue defaultSimpleValue = (SimpleValue)defaultValue;
            Serializable value = defaultSimpleValue.getValue();
            propertyDefinitionSimple.setDefaultValue(value != null ? value.toString() : null);
        } else {
            EnumValue defaultEnumValue = (EnumValue)defaultValue;
            String value = defaultEnumValue.getValue();
            propertyDefinitionSimple.setDefaultValue(value != null ? value.toString() : null);
        }
    }

    public static MetaType convertPropertyDefinitionToMetaType(PropertyDefinition propDef) {
        MetaType memberMetaType;
        if (propDef instanceof PropertyDefinitionSimple) {
            PropertySimpleType propSimpleType = ((PropertyDefinitionSimple)propDef).getType();
            memberMetaType = ProfileServiceUtil.convertPropertySimpleTypeToSimpleMetaType(propSimpleType);
        } else if (propDef instanceof PropertyDefinitionList) {
            memberMetaType = null;
        } else if (propDef instanceof PropertyDefinitionMap) {
            Map memberPropDefs = ((PropertyDefinitionMap)propDef).getPropertyDefinitions();
            if (memberPropDefs.isEmpty()) {
                throw new IllegalStateException("PropertyDefinitionMap doesn't contain any member PropertyDefinitions.");
            }
            PropertyDefinition mapMemberPropDef = (PropertyDefinition)memberPropDefs.values().iterator().next();
            MetaType mapMemberMetaType = ProfileServiceUtil.convertPropertyDefinitionToMetaType(mapMemberPropDef);
            memberMetaType = new MapCompositeMetaType(mapMemberMetaType);
        } else {
            throw new IllegalStateException("List member PropertyDefinition has unknown type: " + propDef.getClass().getName());
        }
        return memberMetaType;
    }

    private static MetaType convertPropertySimpleTypeToSimpleMetaType(PropertySimpleType memberSimpleType) {
        Class memberClass;
        switch (memberSimpleType) {
            case BOOLEAN: {
                memberClass = Boolean.class;
                break;
            }
            case INTEGER: {
                memberClass = Integer.class;
                break;
            }
            case LONG: {
                memberClass = Long.class;
                break;
            }
            case FLOAT: {
                memberClass = Float.class;
                break;
            }
            case DOUBLE: {
                memberClass = Double.class;
                break;
            }
            default: {
                memberClass = String.class;
            }
        }
        SimpleMetaType memberMetaType = SimpleMetaType.resolve((String)memberClass.getName());
        return memberMetaType;
    }

    public static SimpleValue wrap(MetaType type, String value) throws Exception {
        if (type instanceof SimpleMetaType) {
            SimpleMetaType st = (SimpleMetaType)type;
            if (SimpleMetaType.BIGDECIMAL.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)new BigDecimal(value));
            }
            if (SimpleMetaType.BIGINTEGER.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)new BigInteger(value));
            }
            if (SimpleMetaType.BOOLEAN.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Boolean.valueOf(value));
            }
            if (SimpleMetaType.BOOLEAN_PRIMITIVE.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Boolean.valueOf(value));
            }
            if (SimpleMetaType.BYTE.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)new Byte(value.getBytes()[0]));
            }
            if (SimpleMetaType.BYTE_PRIMITIVE.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Byte.valueOf(value.getBytes()[0]));
            }
            if (SimpleMetaType.CHARACTER.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)new Character(value.charAt(0)));
            }
            if (SimpleMetaType.CHARACTER_PRIMITIVE.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Character.valueOf(value.charAt(0)));
            }
            if (SimpleMetaType.DATE.equals((Object)st)) {
                try {
                    return new SimpleValueSupport(st, (Serializable)SimpleDateFormat.getInstance().parse(value));
                }
                catch (ParseException e) {
                    throw new Exception("Failed to convert value to SimpleValue", e);
                }
            }
            if (SimpleMetaType.DOUBLE.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Double.valueOf(value));
            }
            if (SimpleMetaType.DOUBLE_PRIMITIVE.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Double.valueOf(Double.parseDouble(value)));
            }
            if (SimpleMetaType.FLOAT.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Float.valueOf(Float.parseFloat(value)));
            }
            if (SimpleMetaType.FLOAT_PRIMITIVE.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Float.valueOf(value));
            }
            if (SimpleMetaType.INTEGER.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Integer.valueOf(value));
            }
            if (SimpleMetaType.INTEGER_PRIMITIVE.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Integer.valueOf(Integer.parseInt(value)));
            }
            if (SimpleMetaType.LONG.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Long.valueOf(value));
            }
            if (SimpleMetaType.LONG_PRIMITIVE.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Long.valueOf(Long.parseLong(value)));
            }
            if (SimpleMetaType.SHORT.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Short.valueOf(value));
            }
            if (SimpleMetaType.SHORT_PRIMITIVE.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)Short.valueOf(Short.parseShort(value)));
            }
            if (SimpleMetaType.STRING.equals((Object)st)) {
                return new SimpleValueSupport(st, (Serializable)((Object)value));
            }
        }
        throw new Exception("Failed to convert value to SimpleValue");
    }
}

