/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.rhq.admin;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.CollectionValueSupport;
import org.jboss.metatype.api.values.CompositeValue;
import org.jboss.metatype.api.values.CompositeValueSupport;
import org.jboss.metatype.api.values.GenericValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.api.values.SimpleValueSupport;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.teiid.adminapi.Admin;
import org.teiid.adminapi.Request;
import org.teiid.adminapi.VDB;
import org.teiid.rhq.plugin.objects.ExecutedResult;
import org.teiid.rhq.plugin.objects.RequestMetadata;
import org.teiid.rhq.plugin.objects.SessionMetadata;
import org.teiid.rhq.plugin.objects.TransactionMetadata;
import org.teiid.rhq.plugin.util.DeploymentUtils;
import org.teiid.rhq.plugin.util.PluginConstants;
import org.teiid.rhq.plugin.util.ProfileServiceUtil;

public class DQPManagementView
implements PluginConstants {
    private static ManagedComponent mc = null;
    private static final Log LOG = LogFactory.getLog((String)"org.rhq");
    public static final String VDB_EXT = ".vdb";
    public static final String DYNAMIC_VDB_EXT = "-vdb.xml";
    private static final String SECURITY_DOMAIN = "securityDomain";
    private static final String VDB_VERSION = "VDBVersion";
    private static final String VDB_NAME = "VDBName";
    private static final String USER_NAME = "userName";
    private static final String SESSION_ID = "sessionId";
    private static final String LAST_PING_TIME = "lastPingTime";
    private static final String IP_ADDRESS = "IPAddress";
    private static final String CLIENT_HOST_NAME = "clientHostName";
    private static final String CREATED_TIME = "createdTime";
    private static final String APPLICATION_NAME = "applicationName";
    private static final String TRANSACTION_ID = "transactionId";
    private static final String NODE_ID = "nodeId";
    private static final String SOURCE_REQUEST = "sourceRequest";
    private static final String COMMAND = "command";
    private static final String START_TIME = "startTime";
    private static final String EXECUTION_ID = "executionId";
    private static final String STATE = "processingState";
    private static final String SCOPE = "scope";
    private static final String ASSOCIATED_SESSION = "associatedSession";

    public Object getMetric(ProfileServiceConnection connection, String componentType, String identifier, String metric, Map<String, Object> valueMap) throws Exception {
        Object resultObject = new Object();
        if (componentType.equals("Platform")) {
            resultObject = this.getPlatformMetric(connection, componentType, metric, valueMap);
        } else if (componentType.equals("Teiid Virtual Database")) {
            resultObject = this.getVdbMetric(connection, componentType, identifier, metric, valueMap);
        }
        return resultObject;
    }

    private Object getPlatformMetric(ProfileServiceConnection connection, String componentType, String metric, Map<String, Object> valueMap) throws Exception {
        Object resultObject = new Object();
        if (metric.equals("queryCount")) {
            resultObject = new Double(this.getQueryCount(connection).doubleValue());
        } else if (metric.equals("sessionCount")) {
            resultObject = new Double(this.getSessionCount(connection).doubleValue());
        } else if (metric.equals("longRunningQueries")) {
            ArrayList<RequestMetadata> longRunningQueries = new ArrayList<RequestMetadata>();
            this.getRequestCollectionValue(this.getLongRunningQueries(connection), longRunningQueries);
            resultObject = new Double(longRunningQueries.size());
        } else if (metric.equals("userBufferSpace")) {
            try {
                resultObject = ProfileServiceUtil.doubleValue(this.getUsedBufferSpace(connection));
            }
            catch (Exception e) {
                String msg = "Exception executing operation: userBufferSpace";
                LOG.error((Object)"Exception executing operation: userBufferSpace", (Throwable)e);
            }
        } else if (metric.startsWith(Admin.Cache.PREPARED_PLAN_CACHE.toString() + ".") || metric.startsWith(Admin.Cache.QUERY_SERVICE_RESULT_SET_CACHE.toString() + ".")) {
            return this.getCacheProperty(connection, metric);
        }
        return resultObject;
    }

    private Object getCacheProperty(ProfileServiceConnection connection, String metric) {
        int dotIndex = metric.indexOf(46);
        String cacheType = metric.substring(0, dotIndex);
        String property = metric.substring(dotIndex + 1);
        CompositeValueSupport mv = (CompositeValueSupport)this.getCacheStats(connection, cacheType);
        MetaValue v = mv.get(property);
        return ((SimpleValue)v).getValue();
    }

    private Object getVdbMetric(ProfileServiceConnection connection, String componentType, String identifier, String metric, Map<String, Object> valueMap) throws Exception {
        Object resultObject = new Object();
        if (metric.equals("errorCount")) {
            resultObject = this.getErrorCount(connection, (String)valueMap.get("Teiid Virtual Database"));
        } else if (metric.equals("status")) {
            resultObject = DQPManagementView.getVDBStatus(connection, (String)valueMap.get("Teiid Virtual Database"));
        } else if (metric.equals("queryCount")) {
            resultObject = new Double(this.getQueryCount(connection).doubleValue());
        } else if (metric.equals("sessionCount")) {
            resultObject = new Double(this.getSessionCount(connection).doubleValue());
        } else if (metric.equals("longRunningQueries")) {
            ArrayList<RequestMetadata> longRunningQueries = new ArrayList<RequestMetadata>();
            this.getRequestCollectionValue(this.getLongRunningQueries(connection), longRunningQueries);
            resultObject = new Double(longRunningQueries.size());
        }
        return resultObject;
    }

    public void executeOperation(ProfileServiceConnection connection, ExecutedResult operationResult, Map<String, Object> valueMap) throws Exception {
        if (operationResult.getComponentType().equals("Platform")) {
            this.executePlatformOperation(connection, operationResult, operationResult.getOperationName(), valueMap);
        } else if (operationResult.getComponentType().equals("Teiid Virtual Database")) {
            this.executeVdbOperation(connection, operationResult, operationResult.getOperationName(), valueMap);
        }
    }

    private void executePlatformOperation(ProfileServiceConnection connection, ExecutedResult operationResult, String operationName, Map<String, Object> valueMap) throws Exception {
        ArrayList<RequestMetadata> resultObject = new ArrayList<RequestMetadata>();
        ArrayList<SessionMetadata> activeSessionsCollection = new ArrayList<SessionMetadata>();
        ArrayList<TransactionMetadata> transactionsCollection = new ArrayList<TransactionMetadata>();
        if (operationName.equals("getLongRunningRequests")) {
            List<String> fieldNameList = operationResult.getFieldNameList();
            this.getRequestCollectionValue(this.getLongRunningQueries(connection), resultObject);
            operationResult.setContent(this.createReportResultList(fieldNameList, resultObject.iterator()));
        } else if (operationName.equals("getSessions")) {
            List<String> fieldNameList = operationResult.getFieldNameList();
            MetaValue sessionMetaValue = this.getSessions(connection);
            this.getSessionCollectionValue(sessionMetaValue, activeSessionsCollection);
            operationResult.setContent(this.createReportResultList(fieldNameList, activeSessionsCollection.iterator()));
        } else if (operationName.equals("getRequests")) {
            List<String> fieldNameList = operationResult.getFieldNameList();
            MetaValue requestMetaValue = this.getRequests(connection);
            this.getRequestCollectionValue(requestMetaValue, resultObject);
            operationResult.setContent(this.createReportResultList(fieldNameList, resultObject.iterator()));
        } else if (operationName.equals("getTransactions")) {
            List<String> fieldNameList = operationResult.getFieldNameList();
            MetaValue transactionMetaValue = this.getTransactions(connection);
            this.getTransactionCollectionValue(transactionMetaValue, transactionsCollection);
            operationResult.setContent(this.createReportResultList(fieldNameList, resultObject.iterator()));
        } else if (operationName.equals("terminateTransaction")) {
            String sessionID = (String)valueMap.get("transactionID");
            MetaValue[] args = new MetaValue[]{SimpleValueSupport.wrap((Serializable)((Object)sessionID))};
            try {
                DQPManagementView.executeManagedOperation(connection, DQPManagementView.getRuntimeEngineDeployer(connection, mc), "terminateTransaction", args);
            }
            catch (Exception e) {
                String msg = "Exception executing operation: terminateTransaction";
                LOG.error((Object)"Exception executing operation: terminateTransaction", (Throwable)e);
            }
        } else if (operationName.equals("terminateSession")) {
            String sessionID = (String)valueMap.get("sessionID");
            MetaValue[] args = new MetaValue[]{SimpleValueSupport.wrap((Serializable)((Object)sessionID))};
            try {
                DQPManagementView.executeManagedOperation(connection, DQPManagementView.getRuntimeEngineDeployer(connection, mc), "terminateSession", args);
            }
            catch (Exception e) {
                String msg = "Exception executing operation: terminateSession";
                LOG.error((Object)"Exception executing operation: terminateSession", (Throwable)e);
            }
        } else if (operationName.equals("cancelRequest")) {
            Long requestID = (Long)valueMap.get("requestID");
            String sessionID = (String)valueMap.get("sessionID");
            MetaValue[] args = new MetaValue[]{SimpleValueSupport.wrap((Serializable)requestID), SimpleValueSupport.wrap((Serializable)((Object)sessionID))};
            try {
                DQPManagementView.executeManagedOperation(connection, DQPManagementView.getRuntimeEngineDeployer(connection, mc), "cancelRequest", args);
            }
            catch (Exception e) {
                String msg = "Exception executing operation: cancelRequest";
                LOG.error((Object)"Exception executing operation: cancelRequest", (Throwable)e);
            }
        } else if (operationName.equals("deployVdbByUrl")) {
            String vdbUrl = (String)valueMap.get("vdbUrl");
            String deployName = (String)valueMap.get("vdbDeployName");
            Object vdbVersion = valueMap.get("vdbVersion");
            if (deployName.endsWith(VDB_EXT)) {
                deployName = deployName.substring(0, deployName.lastIndexOf(VDB_EXT));
            }
            if (vdbVersion != null) {
                deployName = deployName + "." + ((Integer)vdbVersion).toString() + VDB_EXT;
            }
            if (!deployName.endsWith(VDB_EXT) && !deployName.endsWith(DYNAMIC_VDB_EXT)) {
                deployName = deployName + VDB_EXT;
            }
            try {
                URL url = new URL(vdbUrl);
                DeploymentUtils.deployArchive(deployName, connection.getDeploymentManager(), url, false);
            }
            catch (Exception e) {
                String msg = "Exception executing operation: deployVdbByUrl";
                LOG.error((Object)"Exception executing operation: deployVdbByUrl", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void executeVdbOperation(ProfileServiceConnection connection, ExecutedResult operationResult, String operationName, Map<String, Object> valueMap) throws Exception {
        ArrayList<ArrayList<String>> sqlResultsObject = new ArrayList<ArrayList<String>>();
        ArrayList<RequestMetadata> resultObject = new ArrayList<RequestMetadata>();
        ArrayList<SessionMetadata> activeSessionsCollection = new ArrayList<SessionMetadata>();
        String vdbName = (String)valueMap.get("Teiid Virtual Database");
        vdbName = this.formatVdbName(vdbName);
        String vdbVersion = (String)valueMap.get("version");
        if (operationName.equals("getProperties")) {
            List<String> fieldNameList = operationResult.getFieldNameList();
            this.getProperties(connection, "Teiid Virtual Database");
            operationResult.setContent(this.createReportResultList(fieldNameList, resultObject.iterator()));
        } else if (operationName.equals("getSessions")) {
            List<String> fieldNameList = operationResult.getFieldNameList();
            MetaValue sessionMetaValue = this.getSessions(connection);
            this.getSessionCollectionValueForVDB(sessionMetaValue, activeSessionsCollection, vdbName);
            operationResult.setContent(this.createReportResultList(fieldNameList, activeSessionsCollection.iterator()));
        } else if (operationName.equals("getRequestsUsingVDB")) {
            List<String> fieldNameList = operationResult.getFieldNameList();
            MetaValue requestMetaValue = this.getRequestsForVDB(connection, vdbName, Integer.parseInt(vdbVersion));
            this.getRequestCollectionValue(requestMetaValue, resultObject);
            operationResult.setContent(this.createReportResultList(fieldNameList, resultObject.iterator()));
        } else if (operationName.equals("getMaterializedViews")) {
            List<String> fieldNameList = operationResult.getFieldNameList();
            MetaValue resultsMetaValue = this.executeMaterializedViewQuery(connection, vdbName, Integer.parseInt(vdbVersion));
            this.getResultsCollectionValue(resultsMetaValue, sqlResultsObject);
            operationResult.setContent(this.createReportResultListForMatViewQuery(fieldNameList, sqlResultsObject.iterator()));
        } else if (operationName.equals("clearCache")) {
            try {
                this.executeClearCache(connection, vdbName, Integer.parseInt(vdbVersion), (String)valueMap.get("cacheType"));
            }
            catch (Exception e) {
                operationResult.setContent("failure - see log for details");
            }
            operationResult.setContent("cache successfully cleared!");
        } else if (operationName.equals("reloadMaterializedView")) {
            MetaValue resultsMetaValue = this.reloadMaterializedView(connection, vdbName, Integer.parseInt(vdbVersion), (String)valueMap.get("schema"), (String)valueMap.get("table"), (Boolean)valueMap.get("invalidate"));
            if (resultsMetaValue == null) {
                operationResult.setContent("failure - see log for details");
            } else {
                operationResult.setContent("data successfully refreshed!");
            }
        }
    }

    private String formatVdbName(String vdbName) {
        return vdbName.substring(0, vdbName.lastIndexOf("."));
    }

    public MetaValue getProperties(ProfileServiceConnection connection, String component) {
        MetaValue propertyValue = null;
        Object args = null;
        try {
            propertyValue = DQPManagementView.executeManagedOperation(connection, DQPManagementView.getRuntimeEngineDeployer(connection, mc), "getProperties", args);
        }
        catch (Exception e) {
            String msg = "Exception executing operation: getProperties";
            LOG.error((Object)"Exception executing operation: getProperties", (Throwable)e);
        }
        return propertyValue;
    }

    protected MetaValue getRequests(ProfileServiceConnection connection) {
        MetaValue requestsCollection = null;
        Object args = null;
        try {
            requestsCollection = DQPManagementView.executeManagedOperation(connection, DQPManagementView.getRuntimeEngineDeployer(connection, mc), "getRequests", args);
        }
        catch (Exception e) {
            String msg = "Exception executing operation: getRequests";
            LOG.error((Object)"Exception executing operation: getRequests", (Throwable)e);
        }
        return requestsCollection;
    }

    protected void executeClearCache(ProfileServiceConnection connection, String vdbName, int vdbVersion, String cacheType) throws Exception {
        MetaValue[] args = new MetaValue[]{SimpleValueSupport.wrap((Serializable)((Object)cacheType)), SimpleValueSupport.wrap((Serializable)((Object)vdbName)), SimpleValueSupport.wrap((int)vdbVersion)};
        try {
            DQPManagementView.executeManagedOperation(connection, DQPManagementView.getRuntimeEngineDeployer(connection, mc), "clearCache", args);
        }
        catch (Exception e) {
            String msg = "Exception executing operation: executeQuery";
            LOG.error((Object)"Exception executing operation: executeQuery", (Throwable)e);
            throw e;
        }
    }

    protected MetaValue executeMaterializedViewQuery(ProfileServiceConnection connection, String vdbName, int vdbVersion) {
        MetaValue resultsCollection = null;
        MetaValue[] args = new MetaValue[]{SimpleValueSupport.wrap((Serializable)((Object)vdbName)), SimpleValueSupport.wrap((int)vdbVersion), SimpleValueSupport.wrap((Serializable)((Object)"select SchemaName, Name, TargetSchemaName, TargetName, Valid, LoadState, Updated, Cardinality from SYSADMIN.MATVIEWS where SchemaName != 'pg_catalog'")), SimpleValueSupport.wrap((long)Long.parseLong("9999999"))};
        try {
            resultsCollection = DQPManagementView.executeManagedOperation(connection, DQPManagementView.getRuntimeEngineDeployer(connection, mc), "executeQuery", args);
        }
        catch (Exception e) {
            String msg = "Exception executing operation: executeQuery";
            LOG.error((Object)"Exception executing operation: executeQuery", (Throwable)e);
        }
        return resultsCollection;
    }

    protected MetaValue reloadMaterializedView(ProfileServiceConnection connection, String vdbName, int vdbVersion, String schema, String table, Boolean invalidate) {
        MetaValue result = null;
        String matView = schema + "." + table;
        String query = "exec SYSADMIN.refreshMatView('param1','param2');";
        query = query.replace("param1", matView);
        query = query.replace("param2", invalidate.toString());
        MetaValue[] args = new MetaValue[]{SimpleValueSupport.wrap((Serializable)((Object)vdbName)), SimpleValueSupport.wrap((int)vdbVersion), SimpleValueSupport.wrap((Serializable)((Object)query)), SimpleValueSupport.wrap((long)Long.parseLong("9999999"))};
        try {
            result = DQPManagementView.executeManagedOperation(connection, DQPManagementView.getRuntimeEngineDeployer(connection, mc), "executeQuery", args);
        }
        catch (Exception e) {
            String msg = "Exception executing operation: reloadMaterializedView";
            LOG.error((Object)"Exception executing operation: reloadMaterializedView", (Throwable)e);
        }
        return result;
    }

    protected MetaValue getRequestsForVDB(ProfileServiceConnection connection, String vdbName, int vdbVersion) {
        MetaValue requestsCollection = null;
        MetaValue[] args = new MetaValue[]{SimpleValueSupport.wrap((Serializable)((Object)vdbName)), SimpleValueSupport.wrap((int)vdbVersion)};
        try {
            requestsCollection = DQPManagementView.executeManagedOperation(connection, DQPManagementView.getRuntimeEngineDeployer(connection, mc), "getRequestsUsingVDB", args);
        }
        catch (Exception e) {
            String msg = "Exception executing operation: getRequests";
            LOG.error((Object)"Exception executing operation: getRequests", (Throwable)e);
        }
        return requestsCollection;
    }

    protected MetaValue getTransactions(ProfileServiceConnection connection) {
        MetaValue transactionsCollection = null;
        Object args = null;
        try {
            transactionsCollection = DQPManagementView.executeManagedOperation(connection, DQPManagementView.getRuntimeEngineDeployer(connection, mc), "getTransactions", args);
        }
        catch (Exception e) {
            String msg = "Exception executing operation: getTransactions";
            LOG.error((Object)"Exception executing operation: getTransactions", (Throwable)e);
        }
        return transactionsCollection;
    }

    public MetaValue getSessions(ProfileServiceConnection connection) {
        MetaValue sessionCollection = null;
        Object args = null;
        try {
            sessionCollection = DQPManagementView.executeManagedOperation(connection, DQPManagementView.getRuntimeEngineDeployer(connection, mc), "getActiveSessions", args);
        }
        catch (Exception e) {
            String msg = "Exception executing operation: getSessions";
            LOG.error((Object)"Exception executing operation: getSessions", (Throwable)e);
        }
        return sessionCollection;
    }

    public static String getVDBStatus(ProfileServiceConnection connection, String vdbName) {
        ManagedComponent mcVdb = null;
        try {
            mcVdb = ProfileServiceUtil.getManagedComponent(connection, new ComponentType("teiid", "vdb"), vdbName);
        }
        catch (NamingException e) {
            String msg = "NamingException in getVDBStatus(): " + e.getExplanation();
            LOG.error((Object)msg, (Throwable)e);
        }
        catch (Exception e) {
            String msg = "Exception in getVDBStatus(): " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
        }
        if (mcVdb == null) {
            return VDB.Status.INACTIVE.toString();
        }
        return ProfileServiceUtil.getSimpleValue(mcVdb, "status", String.class);
    }

    public static MetaValue executeManagedOperation(ProfileServiceConnection connection, ManagedComponent mc, String operation, MetaValue ... args) throws Exception {
        for (ManagedOperation mo : mc.getOperations()) {
            String opName = mo.getName();
            if (!opName.equals(operation)) continue;
            try {
                if (args.length == 1 && args[0] == null) {
                    return mo.invoke(new MetaValue[0]);
                }
                return mo.invoke(args);
            }
            catch (Exception e) {
                String msg = "Exception getting the AdminApi in " + operation;
                LOG.error((Object)msg, (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        throw new Exception("No operation found with given name = " + operation);
    }

    private static ManagedComponent getRuntimeEngineDeployer(ProfileServiceConnection connection, ManagedComponent mc) {
        try {
            mc = ProfileServiceUtil.getRuntimeEngineDeployer(connection);
        }
        catch (NamingException e) {
            String msg = "NamingException getting the DQPManagementView";
            LOG.error((Object)"NamingException getting the DQPManagementView", (Throwable)e);
        }
        catch (Exception e1) {
            String msg = "Exception getting the DQPManagementView";
            LOG.error((Object)"Exception getting the DQPManagementView", (Throwable)e1);
        }
        return mc;
    }

    private static ManagedComponent getBufferService(ProfileServiceConnection connection, ManagedComponent mc) {
        try {
            mc = ProfileServiceUtil.getBufferService(connection);
        }
        catch (NamingException e) {
            String msg = "NamingException getting the SessionService";
            LOG.error((Object)"NamingException getting the SessionService", (Throwable)e);
        }
        catch (Exception e1) {
            String msg = "Exception getting the SessionService";
            LOG.error((Object)"Exception getting the SessionService", (Throwable)e1);
        }
        return mc;
    }

    public static MetaValue getManagedProperty(ProfileServiceConnection connection, ManagedComponent mc, String property) throws Exception {
        ManagedProperty managedProperty = null;
        try {
            managedProperty = mc.getProperty(property);
        }
        catch (Exception e) {
            String msg = "Exception getting the AdminApi in " + property;
            LOG.error((Object)msg, (Throwable)e);
        }
        if (managedProperty != null) {
            return managedProperty.getValue();
        }
        throw new Exception("No property found with given name =" + property);
    }

    private Integer getQueryCount(ProfileServiceConnection connection) throws Exception {
        Integer count = new Integer(0);
        MetaValue requests = null;
        ArrayList<RequestMetadata> requestsCollection = new ArrayList<RequestMetadata>();
        requests = this.getRequests(connection);
        this.getRequestCollectionValue(requests, requestsCollection);
        if (!requestsCollection.isEmpty()) {
            count = requestsCollection.size();
        }
        return count;
    }

    private Integer getSessionCount(ProfileServiceConnection connection) throws Exception {
        ArrayList<SessionMetadata> activeSessionsCollection = new ArrayList<SessionMetadata>();
        MetaValue sessionMetaValue = this.getSessions(connection);
        this.getSessionCollectionValue(sessionMetaValue, activeSessionsCollection);
        return activeSessionsCollection.size();
    }

    private int getErrorCount(ProfileServiceConnection connection, String vdbName) {
        MetaValue[] metaValues;
        String msg;
        ManagedComponent mcVdb = null;
        try {
            mcVdb = ProfileServiceUtil.getManagedComponent(connection, new ComponentType("teiid", "vdb"), vdbName);
        }
        catch (NamingException e) {
            msg = "NamingException in getVDBStatus(): " + e.getExplanation();
            LOG.error((Object)msg, (Throwable)e);
        }
        catch (Exception e) {
            msg = "Exception in getVDBStatus(): " + e.getMessage();
            LOG.error((Object)msg, (Throwable)e);
        }
        int count = 0;
        ManagedProperty property = mcVdb.getProperty("models");
        CollectionValueSupport valueSupport = (CollectionValueSupport)property.getValue();
        for (MetaValue value : metaValues = valueSupport.getElements()) {
            GenericValueSupport genValueSupport = (GenericValueSupport)value;
            ManagedObjectImpl managedObject = (ManagedObjectImpl)genValueSupport.getValue();
            MetaValue errors = managedObject.getProperty("errors").getValue();
            if (errors == null) continue;
            CollectionValueSupport errorValueSupport = (CollectionValueSupport)errors;
            MetaValue[] errorArray = errorValueSupport.getElements();
            count += errorArray.length;
        }
        return count;
    }

    protected MetaValue getCacheStats(ProfileServiceConnection connection, String type) {
        try {
            return DQPManagementView.executeManagedOperation(connection, DQPManagementView.getRuntimeEngineDeployer(connection, mc), "getCacheStatistics", new MetaValue[]{SimpleValueSupport.wrap((Serializable)((Object)type))});
        }
        catch (Exception e) {
            LOG.error((Object)"Exception executing operation: getCacheStatistics", (Throwable)e);
            return null;
        }
    }

    protected MetaValue getLongRunningQueries(ProfileServiceConnection connection) {
        MetaValue requestsCollection = null;
        Object args = null;
        try {
            requestsCollection = DQPManagementView.executeManagedOperation(connection, DQPManagementView.getRuntimeEngineDeployer(connection, mc), "getLongRunningRequests", args);
        }
        catch (Exception e) {
            String msg = "Exception executing operation: getLongRunningRequests";
            LOG.error((Object)"Exception executing operation: getLongRunningRequests", (Throwable)e);
        }
        return requestsCollection;
    }

    protected MetaValue getUsedBufferSpace(ProfileServiceConnection connection) {
        MetaValue usedBufferSpace = null;
        try {
            usedBufferSpace = DQPManagementView.getManagedProperty(connection, DQPManagementView.getBufferService(connection, mc), "userBufferSpace");
        }
        catch (Exception e) {
            String msg = "Exception executing operation: userBufferSpace";
            LOG.error((Object)"Exception executing operation: userBufferSpace", (Throwable)e);
        }
        return usedBufferSpace;
    }

    private void getRequestCollectionValue(MetaValue pValue, Collection<RequestMetadata> list) throws Exception {
        MetaType metaType = pValue.getMetaType();
        if (metaType.isCollection()) {
            for (MetaValue value : ((CollectionValueSupport)pValue).getElements()) {
                if (!value.getMetaType().isComposite()) {
                    throw new IllegalStateException(pValue + " is not a Composite type");
                }
                RequestMetadata request = this.unwrapRequestMetaValue(value);
                list.add(request);
            }
        }
    }

    private void getResultsCollectionValue(MetaValue pValue, Collection<ArrayList<String>> list) throws Exception {
        MetaType metaType = pValue.getMetaType();
        if (metaType.isCollection()) {
            for (MetaValue value : ((CollectionValueSupport)pValue).getElements()) {
                MetaValue[] metaValueArray;
                if (!value.getMetaType().isCollection()) continue;
                ArrayList<String> row = new ArrayList<String>();
                for (MetaValue cell : metaValueArray = ((CollectionValueSupport)value).getElements()) {
                    row.add(ProfileServiceUtil.stringValue(cell));
                }
                list.add(row);
            }
        }
    }

    private void getResultsCollectionValueForMatViewRefresh(MetaValue pValue, Collection<ArrayList<String>> list) throws Exception {
        MetaType metaType = pValue.getMetaType();
        for (MetaValue value : ((CollectionValueSupport)pValue).getElements()) {
            MetaValue[] metaValueArray;
            if (!value.getMetaType().isCollection()) continue;
            ArrayList<String> row = new ArrayList<String>();
            for (MetaValue cell : metaValueArray = ((CollectionValueSupport)value).getElements()) {
                row.add(ProfileServiceUtil.stringValue(cell));
            }
            list.add(row);
        }
    }

    public <T> void getTransactionCollectionValue(MetaValue pValue, Collection<TransactionMetadata> list) throws Exception {
        MetaType metaType = pValue.getMetaType();
        if (metaType.isCollection()) {
            for (MetaValue value : ((CollectionValueSupport)pValue).getElements()) {
                if (!value.getMetaType().isComposite()) {
                    throw new IllegalStateException(pValue + " is not a Composite type");
                }
                TransactionMetadata transaction = this.unwrapTransactionMetaValue(value);
                list.add(transaction);
            }
        }
    }

    public <T> void getSessionCollectionValue(MetaValue pValue, Collection<SessionMetadata> list) throws Exception {
        MetaType metaType = pValue.getMetaType();
        if (metaType.isCollection()) {
            for (MetaValue value : ((CollectionValueSupport)pValue).getElements()) {
                if (!value.getMetaType().isComposite()) {
                    throw new IllegalStateException(pValue + " is not a Composite type");
                }
                SessionMetadata session = this.unwrapSessionMetaValue(value);
                list.add(session);
            }
        }
    }

    public <T> void getSessionCollectionValueForVDB(MetaValue pValue, Collection<SessionMetadata> list, String vdbName) throws Exception {
        MetaType metaType = pValue.getMetaType();
        if (metaType.isCollection()) {
            for (MetaValue value : ((CollectionValueSupport)pValue).getElements()) {
                if (value.getMetaType().isComposite()) {
                    if (!ProfileServiceUtil.stringValue(((CompositeValueSupport)value).get(VDB_NAME)).equals(vdbName)) continue;
                    SessionMetadata session = this.unwrapSessionMetaValue(value);
                    list.add(session);
                    continue;
                }
                throw new IllegalStateException(pValue + " is not a Composite type");
            }
        }
    }

    private Collection createReportResultList(List fieldNameList, Iterator objectIter) {
        ArrayList reportResultList = new ArrayList();
        while (objectIter.hasNext()) {
            Object object = objectIter.next();
            Class<?> cls = null;
            try {
                cls = object.getClass();
                Iterator methodIter = fieldNameList.iterator();
                HashMap<String, Object> reportValueMap = new HashMap<String, Object>();
                while (methodIter.hasNext()) {
                    String fieldName;
                    String methodName = fieldName = (String)methodIter.next();
                    Method meth = cls.getMethod(methodName, null);
                    Object retObj = meth.invoke(object, (Object[])null);
                    reportValueMap.put(fieldName, retObj);
                }
                reportResultList.add(reportValueMap);
            }
            catch (Throwable e) {
                System.err.println(e);
            }
        }
        return reportResultList;
    }

    private Collection createReportResultListForMatViewQuery(List fieldNameList, Iterator objectIter) {
        ArrayList reportResultList = new ArrayList();
        while (objectIter.hasNext()) {
            ArrayList columnValues = (ArrayList)objectIter.next();
            try {
                Iterator fieldIter = fieldNameList.iterator();
                HashMap reportValueMap = new HashMap();
                for (Object columnValue : columnValues) {
                    String fieldName = (String)fieldIter.next();
                    reportValueMap.put(fieldName, columnValue);
                }
                reportResultList.add(reportValueMap);
            }
            catch (Throwable e) {
                System.err.println(e);
            }
        }
        return reportResultList;
    }

    public SessionMetadata unwrapSessionMetaValue(MetaValue metaValue) throws Exception {
        if (metaValue == null) {
            return null;
        }
        if (metaValue instanceof CompositeValue) {
            CompositeValueSupport compositeValue = (CompositeValueSupport)metaValue;
            SessionMetadata session = new SessionMetadata();
            session.setApplicationName(ProfileServiceUtil.stringValue(compositeValue.get(APPLICATION_NAME)));
            session.setCreatedTime(ProfileServiceUtil.longValue(compositeValue.get(CREATED_TIME)));
            session.setClientHostName(ProfileServiceUtil.stringValue(compositeValue.get(CLIENT_HOST_NAME)));
            session.setIPAddress(ProfileServiceUtil.stringValue(compositeValue.get(IP_ADDRESS)));
            session.setLastPingTime(ProfileServiceUtil.longValue(compositeValue.get(LAST_PING_TIME)));
            session.setSessionId(ProfileServiceUtil.stringValue(compositeValue.get(SESSION_ID)));
            session.setUserName(ProfileServiceUtil.stringValue(compositeValue.get(USER_NAME)));
            session.setVDBName(ProfileServiceUtil.stringValue(compositeValue.get(VDB_NAME)));
            session.setVDBVersion(ProfileServiceUtil.integerValue(compositeValue.get(VDB_VERSION)));
            session.setSecurityDomain(ProfileServiceUtil.stringValue(compositeValue.get(SECURITY_DOMAIN)));
            return session;
        }
        throw new IllegalStateException("Unable to unwrap session " + metaValue);
    }

    public RequestMetadata unwrapRequestMetaValue(MetaValue metaValue) throws Exception {
        if (metaValue == null) {
            return null;
        }
        if (metaValue instanceof CompositeValue) {
            CompositeValue compositeValue = (CompositeValue)metaValue;
            RequestMetadata request = new RequestMetadata();
            request.setExecutionId(ProfileServiceUtil.longValue(compositeValue.get(EXECUTION_ID)));
            request.setSessionId(ProfileServiceUtil.stringValue(compositeValue.get(SESSION_ID)));
            request.setStartTime(ProfileServiceUtil.longValue(compositeValue.get(START_TIME)));
            request.setCommand(ProfileServiceUtil.stringValue(compositeValue.get(COMMAND)));
            request.setSourceRequest(ProfileServiceUtil.booleanValue(compositeValue.get(SOURCE_REQUEST)));
            request.setNodeId(ProfileServiceUtil.integerValue(compositeValue.get(NODE_ID)));
            request.setTransactionId(ProfileServiceUtil.stringValue(compositeValue.get(TRANSACTION_ID)));
            request.setState(ProfileServiceUtil.getSimpleValue(compositeValue.get(STATE), Request.ProcessingState.class));
            return request;
        }
        throw new IllegalStateException("Unable to unwrap RequestMetadata " + metaValue);
    }

    public TransactionMetadata unwrapTransactionMetaValue(MetaValue metaValue) throws Exception {
        if (metaValue == null) {
            return null;
        }
        if (metaValue instanceof CompositeValue) {
            CompositeValue compositeValue = (CompositeValue)metaValue;
            TransactionMetadata transaction = new TransactionMetadata();
            transaction.setAssociatedSession(ProfileServiceUtil.stringValue(compositeValue.get(ASSOCIATED_SESSION)));
            transaction.setCreatedTime(ProfileServiceUtil.longValue(compositeValue.get(CREATED_TIME)));
            transaction.setScope(ProfileServiceUtil.stringValue(compositeValue.get(SCOPE)));
            transaction.setId(ProfileServiceUtil.stringValue(compositeValue.get("id")));
            return transaction;
        }
        throw new IllegalStateException("Unable to unwrap TransactionMetadata " + metaValue);
    }
}

