/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.rhq.plugin;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.ManagementView;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.api.RunState;
import org.mc4j.ems.connection.EmsConnection;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.ConfigurationUpdateStatus;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.AvailabilityType;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.configuration.ConfigurationUpdateReport;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jbossas5.ApplicationServerComponent;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.teiid.rhq.admin.DQPManagementView;
import org.teiid.rhq.plugin.Facet;
import org.teiid.rhq.plugin.util.ProfileServiceUtil;

public class PlatformComponent
extends Facet {
    private final Log LOG = LogFactory.getLog((String)"org.rhq");

    @Override
    public void start(ResourceContext context) {
        this.setComponentName(context.getPluginConfiguration().getSimpleValue("name", null));
        this.resourceConfiguration = context.getPluginConfiguration();
        super.start(context);
    }

    @Override
    String getComponentType() {
        return "Platform";
    }

    @Override
    public AvailabilityType getAvailability() {
        RunState runState;
        try {
            runState = ProfileServiceUtil.getRuntimeEngineDeployer(this.getConnection()).getRunState();
        }
        catch (NamingException e) {
            this.LOG.debug((Object)"Naming exception getting: RuntimeEngineDeployer");
            return AvailabilityType.DOWN;
        }
        catch (Exception e) {
            this.LOG.debug((Object)"Exception getting: RuntimeEngineDeployer");
            return AvailabilityType.DOWN;
        }
        return runState == RunState.RUNNING ? AvailabilityType.UP : AvailabilityType.DOWN;
    }

    @Override
    protected void setOperationArguments(String name, Configuration configuration, Map<String, Object> valueMap) {
        if (name.equals("cancelRequest")) {
            valueMap.put("requestID", configuration.getSimple("requestID").getLongValue());
            valueMap.put("sessionID", configuration.getSimple("sessionID").getStringValue());
        } else if (name.equals("cancelRequest")) {
            valueMap.put("transactionID", configuration.getSimple("transactionID").getStringValue());
        } else if (name.equals("terminateSession")) {
            valueMap.put("sessionID", configuration.getSimple("sessionID").getStringValue());
        } else if (name.equals("deployVdbByUrl")) {
            valueMap.put("vdbUrl", configuration.getSimple("vdbUrl").getStringValue());
            valueMap.put("vdbDeployName", configuration.getSimple("vdbDeployName").getStringValue());
            valueMap.put("vdbVersion", configuration.getSimple("vdbVersion").getIntegerValue());
        }
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) throws Exception {
        DQPManagementView view = new DQPManagementView();
        HashMap<String, Object> valueMap = new HashMap<String, Object>();
        try {
            for (MeasurementScheduleRequest request : requests) {
                String name = request.getName();
                this.LOG.debug((Object)("Measurement name = " + name));
                Object metric = view.getMetric(this.getConnection(), this.getComponentType(), this.getComponentIdentifier(), name, valueMap);
                if (metric instanceof Double) {
                    report.addData(new MeasurementDataNumeric(request, (Double)metric));
                    continue;
                }
                if (metric instanceof Integer) {
                    report.addData(new MeasurementDataNumeric(request, new Double(((Integer)metric).doubleValue())));
                    continue;
                }
                if (metric instanceof Long) {
                    report.addData(new MeasurementDataNumeric(request, new Double(((Long)metric).longValue())));
                    continue;
                }
                this.LOG.error((Object)"Metric value must be a numeric value");
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)("Failed to obtain measurement [" + this.name + "]. Cause: " + e));
            throw e;
        }
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    public void updateResourceConfiguration(ConfigurationUpdateReport report) {
        this.resourceConfiguration = report.getConfiguration().deepCopy();
        Configuration resourceConfig = report.getConfiguration();
        ManagementView managementView = null;
        ComponentType componentType = new ComponentType("teiid", "dqp");
        report.setStatus(ConfigurationUpdateStatus.SUCCESS);
        try {
            managementView = this.getConnection().getManagementView();
            Set allComponents = managementView.getComponentsForType(componentType);
            for (ManagedComponent managedComponent : allComponents) {
                Map managedProperties = managedComponent.getProperties();
                ProfileServiceUtil.convertConfigurationToManagedProperties(managedProperties, resourceConfig, this.resourceContext.getResourceType(), managedComponent.getName());
                try {
                    managementView.updateComponent(managedComponent);
                }
                catch (Exception e) {
                    this.LOG.error((Object)("Unable to update component [" + managedComponent.getName() + "] of type " + componentType + "."), (Throwable)e);
                    report.setStatus(ConfigurationUpdateStatus.FAILURE);
                    report.setErrorMessageFromThrowable((Throwable)e);
                }
            }
        }
        catch (Exception e) {
            this.LOG.error((Object)"Unable to process update request", (Throwable)e);
            report.setStatus(ConfigurationUpdateStatus.FAILURE);
            report.setErrorMessageFromThrowable((Throwable)e);
        }
        managementView.load();
    }

    @Override
    public Configuration loadResourceConfiguration() {
        Configuration c = this.resourceConfiguration;
        this.getProperties(c);
        return c;
    }

    private void getProperties(Configuration configuration) {
        Set<ManagedComponent> mcSet = null;
        try {
            mcSet = ProfileServiceUtil.getManagedComponents(this.getConnection(), new ComponentType("teiid", "dqp"));
        }
        catch (NamingException e) {
            this.LOG.error((Object)("NamingException getting components in Platform loadConfiguration(): " + e.getMessage()));
        }
        catch (Exception e) {
            this.LOG.error((Object)("Exception getting components in Platform loadConfiguration(): " + e.getMessage()));
        }
        for (ManagedComponent mc : mcSet) {
            Map mcMap = mc.getProperties();
            String name = mc.getName();
            this.setProperties(name, mcMap, configuration);
        }
    }

    private void setProperties(String compName, Map<String, ManagedProperty> mcMap, Configuration configuration) {
        for (ManagedProperty mProp : mcMap.values()) {
            try {
                String value = ProfileServiceUtil.stringValue(mProp.getValue());
                PropertySimple prop = new PropertySimple(compName + "." + mProp.getName(), (Object)value);
                configuration.put((Property)prop);
            }
            catch (Exception e) {
                this.LOG.error((Object)("Exception setting properties in Platform loadConfiguration(): " + e.getMessage()));
            }
        }
    }

    public ProfileServiceConnection getConnection() {
        return ((ApplicationServerComponent)this.resourceContext.getParentResourceComponent()).getConnection();
    }

    public EmsConnection getEmsConnection() {
        return null;
    }
}

