/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.rhq.plugin.adapter.api;

import com.sun.istack.Nullable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.metatype.api.types.MapCompositeMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.types.PropertiesMetaType;
import org.jboss.metatype.api.values.MetaValue;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionSimple;
import org.teiid.rhq.plugin.adapter.api.PropertyAdapter;
import org.teiid.rhq.plugin.adapter.impl.PropertyListToCollectionValueAdapter;
import org.teiid.rhq.plugin.adapter.impl.PropertyMapToCompositeValueSupportAdapter;
import org.teiid.rhq.plugin.adapter.impl.PropertyMapToGenericValueAdapter;
import org.teiid.rhq.plugin.adapter.impl.PropertyMapToMapCompositeValueSupportAdapter;
import org.teiid.rhq.plugin.adapter.impl.PropertyMapToPropertiesValueAdapter;
import org.teiid.rhq.plugin.adapter.impl.PropertyMapToTableValueAdapter;
import org.teiid.rhq.plugin.adapter.impl.PropertySimpleToEnumValueAdapter;
import org.teiid.rhq.plugin.adapter.impl.PropertySimpleToSimpleValueAdapter;

public class PropertyAdapterFactory {
    private static final Log LOG = LogFactory.getLog((String)"org.rhq");

    public static PropertyAdapter getPropertyAdapter(MetaValue metaValue) {
        if (metaValue == null) {
            LOG.debug((Object)"The MetaValue passed in is null.");
            return null;
        }
        MetaType metaType = metaValue.getMetaType();
        return PropertyAdapterFactory.getPropertyAdapter(metaType);
    }

    public static PropertyAdapter getPropertyAdapter(MetaType metaType) {
        PropertyAdapter<PropertySimple, PropertyDefinitionSimple> propertyAdapter = null;
        if (metaType.isSimple()) {
            propertyAdapter = new PropertySimpleToSimpleValueAdapter();
        } else if (metaType.isGeneric()) {
            propertyAdapter = new PropertyMapToGenericValueAdapter();
        } else if (metaType.isComposite()) {
            propertyAdapter = metaType instanceof MapCompositeMetaType ? new PropertyMapToMapCompositeValueSupportAdapter() : new PropertyMapToCompositeValueSupportAdapter();
        } else if (metaType.isTable()) {
            propertyAdapter = new PropertyMapToTableValueAdapter();
        } else if (metaType.isCollection()) {
            propertyAdapter = new PropertyListToCollectionValueAdapter();
        } else if (metaType.isEnum()) {
            propertyAdapter = new PropertySimpleToEnumValueAdapter();
        } else if (metaType instanceof PropertiesMetaType) {
            propertyAdapter = new PropertyMapToPropertiesValueAdapter();
        } else {
            LOG.warn((Object)("Unsupported MetaType: " + metaType));
        }
        return propertyAdapter;
    }

    @Nullable
    public static PropertyAdapter getCustomPropertyAdapter(PropertySimple customProp) {
        if (customProp == null) {
            return null;
        }
        String adapterClassName = customProp.getStringValue();
        PropertyAdapter propertyAdapter = null;
        try {
            Class<?> adapterClass = Class.forName(adapterClassName);
            propertyAdapter = (PropertyAdapter)adapterClass.newInstance();
        }
        catch (Exception e) {
            LOG.error((Object)("Unable to create custom adapter class for " + customProp + "."), (Throwable)e);
        }
        return propertyAdapter;
    }
}

