/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.rhq.plugin;

import java.util.Map;
import java.util.Set;
import javax.naming.NamingException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.managed.api.ComponentType;
import org.jboss.managed.api.ManagedComponent;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.MapCompositeValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.mc4j.ems.connection.EmsConnection;
import org.rhq.core.domain.configuration.Configuration;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyList;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.measurement.MeasurementDataNumeric;
import org.rhq.core.domain.measurement.MeasurementReport;
import org.rhq.core.domain.measurement.MeasurementScheduleRequest;
import org.rhq.core.pluginapi.inventory.ResourceContext;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.teiid.rhq.plugin.Facet;
import org.teiid.rhq.plugin.PlatformComponent;
import org.teiid.rhq.plugin.util.ProfileServiceUtil;

public class TranslatorComponent
extends Facet {
    private final Log LOG = LogFactory.getLog((String)"org.rhq");

    @Override
    public void start(ResourceContext context) {
        this.setComponentName(context.getPluginConfiguration().getSimpleValue("name", null));
        this.resourceConfiguration = context.getPluginConfiguration();
        super.start(context);
    }

    @Override
    String getComponentType() {
        return "Translator";
    }

    @Override
    public void getValues(MeasurementReport report, Set<MeasurementScheduleRequest> requests) {
        for (MeasurementScheduleRequest request : requests) {
            String name = request.getName();
            try {
                Integer value = new Integer(1);
                report.addData(new MeasurementDataNumeric(request, Double.valueOf(((Number)value).doubleValue())));
            }
            catch (Exception e) {
                this.LOG.error((Object)("Failed to obtain measurement [" + name + "]. Cause: " + e));
            }
        }
    }

    protected void setOperationArguments(String name, Configuration configuration, Map argumentMap) {
    }

    @Override
    public Configuration loadResourceConfiguration() {
        String msg;
        ManagedComponent translator = null;
        try {
            translator = ProfileServiceUtil.getManagedComponent(this.getConnection(), new ComponentType("teiid", "translator"), this.name);
        }
        catch (NamingException e) {
            msg = "NamingException in loadResourceConfiguration(): " + e.getExplanation();
            this.LOG.error((Object)msg, (Throwable)e);
        }
        catch (Exception e) {
            msg = "Exception in loadResourceConfiguration(): " + e.getMessage();
            this.LOG.error((Object)msg, (Throwable)e);
        }
        String translatorName = ProfileServiceUtil.getSimpleValue(translator, "name", String.class);
        String description = ProfileServiceUtil.getSimpleValue(translator, "description", String.class);
        Configuration c = this.resourceConfiguration;
        PropertyList list = new PropertyList("translatorList");
        PropertyMap propMap = null;
        c.put((Property)list);
        ManagedProperty translatorProps = translator.getProperty("property");
        try {
            TranslatorComponent.getTranslatorValues(translatorProps.getValue(), propMap, list);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        c.put((Property)new PropertySimple("name", (Object)translatorName));
        c.put((Property)new PropertySimple("description", (Object)description));
        return c;
    }

    public static <T> void getTranslatorValues(MetaValue pValue, PropertyMap map, PropertyList list) throws Exception {
        MetaType metaType = pValue.getMetaType();
        MapCompositeValueSupport unwrappedvalueMap = null;
        if (metaType.isComposite()) {
            unwrappedvalueMap = (MapCompositeValueSupport)pValue;
            for (String key : unwrappedvalueMap.getMetaType().keySet()) {
                map = new PropertyMap("property");
                map.put((Property)new PropertySimple("name", (Object)key));
                map.put((Property)new PropertySimple("value", (Object)ProfileServiceUtil.stringValue(unwrappedvalueMap.get(key))));
                map.put((Property)new PropertySimple("description", (Object)"Custom property"));
                list.add((Property)map);
            }
        } else {
            throw new IllegalStateException(pValue + " is not a Composite type");
        }
    }

    public ProfileServiceConnection getConnection() {
        return ((PlatformComponent)this.resourceContext.getParentResourceComponent()).getConnection();
    }

    public EmsConnection getEmsConnection() {
        return null;
    }

    public static interface Config {
        public static final String COMPONENT_TYPE = "componentType";
        public static final String COMPONENT_SUBTYPE = "componentSubtype";
        public static final String COMPONENT_NAME = "componentName";
        public static final String TEMPLATE_NAME = "template-name";
        public static final String RESOURCE_NAME = "resourceName";
    }
}

