/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.rhq.plugin.deployer;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.deployers.spi.management.deploy.DeploymentManager;
import org.rhq.core.domain.content.PackageDetailsKey;
import org.rhq.core.domain.content.transfer.ResourcePackageDetails;
import org.rhq.core.domain.resource.CreateResourceStatus;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pluginapi.inventory.CreateResourceReport;
import org.rhq.plugins.jbossas5.connection.ProfileServiceConnection;
import org.teiid.rhq.plugin.deployer.Deployer;
import org.teiid.rhq.plugin.util.DeploymentUtils;

public abstract class AbstractDeployer
implements Deployer {
    private final Log log = LogFactory.getLog(this.getClass());
    private ProfileServiceConnection profileServiceConnection;

    protected AbstractDeployer(ProfileServiceConnection profileService) {
        this.profileServiceConnection = profileService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploy(CreateResourceReport createResourceReport, ResourceType resourceType) {
        String archiveName;
        File archiveFile;
        block9: {
            archiveFile = null;
            ResourcePackageDetails details = createResourceReport.getPackageDetails();
            PackageDetailsKey key = details.getKey();
            archiveFile = this.prepareArchive(createResourceReport.getUserSpecifiedResourceName(), key, resourceType);
            archiveName = archiveFile.getName();
            if (DeploymentUtils.hasCorrectExtension(archiveName, resourceType)) break block9;
            createResourceReport.setStatus(CreateResourceStatus.FAILURE);
            createResourceReport.setErrorMessage("Incorrect extension specified on filename [" + archiveName + "]");
            if (archiveFile != null) {
                this.destroyArchive(archiveFile);
            }
            return;
        }
        try {
            DeploymentManager deploymentManager = this.profileServiceConnection.getDeploymentManager();
            DeploymentUtils.deployArchive(deploymentManager, archiveFile, false);
            createResourceReport.setResourceName(archiveName);
            createResourceReport.setResourceKey(archiveName);
            createResourceReport.setStatus(CreateResourceStatus.SUCCESS);
            if (archiveFile != null) {
                this.destroyArchive(archiveFile);
            }
        }
        catch (Throwable t) {
            try {
                this.log.error((Object)("Error deploying application for request [" + createResourceReport + "]."), t);
                createResourceReport.setStatus(CreateResourceStatus.FAILURE);
                createResourceReport.setException(t);
                if (archiveFile != null) {
                    this.destroyArchive(archiveFile);
                }
            }
            catch (Throwable throwable) {
                if (archiveFile != null) {
                    this.destroyArchive(archiveFile);
                }
                throw throwable;
            }
        }
    }

    protected Log getLog() {
        return this.log;
    }

    protected ProfileServiceConnection getProfileServiceConnection() {
        return this.profileServiceConnection;
    }

    protected abstract File prepareArchive(PackageDetailsKey var1, ResourceType var2);

    protected abstract File prepareArchive(String var1, PackageDetailsKey var2, ResourceType var3);

    protected abstract void destroyArchive(File var1);
}

