/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.common.buffer.Cache;
import org.teiid.common.buffer.CacheEntry;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.Serializer;
import org.teiid.core.TeiidComponentException;

public class MemoryStorageManager
implements Cache<Long> {
    public static final int MAX_FILE_SIZE = 131072;
    private Map<Long, Map<Long, CacheEntry>> groups = new ConcurrentHashMap<Long, Map<Long, CacheEntry>>();
    private AtomicInteger created = new AtomicInteger();
    private AtomicInteger removed = new AtomicInteger();

    @Override
    public void initialize() {
    }

    @Override
    public FileStore createFileStore(String name) {
        this.created.incrementAndGet();
        return new MemoryFileStore();
    }

    public int getCreated() {
        return this.created.get();
    }

    public int getRemoved() {
        return this.removed.get();
    }

    @Override
    public boolean add(CacheEntry entry, Serializer<?> s) {
        Map<Long, CacheEntry> group = this.groups.get(s.getId());
        if (group != null) {
            group.put(entry.getId(), entry);
        }
        return true;
    }

    @Override
    public boolean addToCacheGroup(Long gid, Long oid) {
        Map<Long, CacheEntry> group = this.groups.get(gid);
        if (group != null) {
            group.put(oid, null);
            return true;
        }
        return false;
    }

    @Override
    public void createCacheGroup(Long gid) {
        this.groups.put(gid, Collections.synchronizedMap(new HashMap()));
    }

    @Override
    public Long lockForLoad(Long oid, Serializer<?> serializer) {
        return oid;
    }

    @Override
    public void unlockForLoad(Long o) {
    }

    @Override
    public CacheEntry get(Long lock, Long oid, WeakReference<? extends Serializer<?>> ref) throws TeiidComponentException {
        Map<Long, CacheEntry> group = this.groups.get(((Serializer)ref.get()).getId());
        if (group != null) {
            return group.get(oid);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer remove(Long gid, Long id) {
        Map<Long, CacheEntry> group = this.groups.get(gid);
        if (group != null) {
            Map<Long, CacheEntry> map = group;
            synchronized (map) {
                CacheEntry entry = group.remove(id);
                if (entry != null) {
                    return entry.getSizeEstimate();
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Long> removeCacheGroup(Long gid) {
        Map<Long, CacheEntry> group = this.groups.remove(gid);
        if (group == null) {
            return Collections.emptySet();
        }
        Map<Long, CacheEntry> map = group;
        synchronized (map) {
            return new ArrayList<Long>(group.keySet());
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public long getMaxStorageSpace() {
        return Runtime.getRuntime().maxMemory();
    }

    @Override
    public long getMemoryBufferSpace() {
        return 0L;
    }

    private final class MemoryFileStore
    extends FileStore {
        private ByteBuffer buffer = ByteBuffer.allocate(131072);

        public MemoryFileStore() {
            this.buffer.limit(0);
        }

        @Override
        public synchronized void removeDirect() {
            MemoryStorageManager.this.removed.incrementAndGet();
            this.buffer = ByteBuffer.allocate(0);
        }

        @Override
        protected synchronized int readWrite(long fileOffset, byte[] b, int offSet, int length, boolean write) {
            if (!write) {
                if (fileOffset >= this.getLength()) {
                    return -1;
                }
                int position = (int)fileOffset;
                this.buffer.position(position);
                length = Math.min(length, (int)this.getLength() - position);
                this.buffer.get(b, offSet, length);
                return length;
            }
            int requiredLength = (int)(fileOffset + (long)length);
            if (requiredLength > this.buffer.limit()) {
                this.buffer.limit(requiredLength);
            }
            this.buffer.position((int)fileOffset);
            this.buffer.put(b, offSet, length);
            return length;
        }

        @Override
        public synchronized void setLength(long length) {
            this.buffer.limit((int)length);
        }

        @Override
        public synchronized long getLength() {
            return this.buffer.limit();
        }
    }
}

