/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.process.Request;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.VariableResolver;
import org.teiid.query.resolver.command.AlterResolver;
import org.teiid.query.resolver.command.BatchedUpdateResolver;
import org.teiid.query.resolver.command.DeleteResolver;
import org.teiid.query.resolver.command.DynamicCommandResolver;
import org.teiid.query.resolver.command.ExecResolver;
import org.teiid.query.resolver.command.InsertResolver;
import org.teiid.query.resolver.command.SetQueryResolver;
import org.teiid.query.resolver.command.SimpleQueryResolver;
import org.teiid.query.resolver.command.TempTableResolver;
import org.teiid.query.resolver.command.UpdateProcedureResolver;
import org.teiid.query.resolver.command.UpdateResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.navigator.DeepPostOrderNavigator;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.validator.UpdateValidator;
import org.teiid.query.validator.ValidationVisitor;

public class QueryResolver {
    private static final String BINDING_GROUP = "INPUTS";
    private static final CommandResolver SIMPLE_QUERY_RESOLVER = new SimpleQueryResolver();
    private static final CommandResolver SET_QUERY_RESOLVER = new SetQueryResolver();
    private static final CommandResolver EXEC_RESOLVER = new ExecResolver();
    private static final CommandResolver INSERT_RESOLVER = new InsertResolver();
    private static final CommandResolver UPDATE_RESOLVER = new UpdateResolver();
    private static final CommandResolver DELETE_RESOLVER = new DeleteResolver();
    private static final CommandResolver UPDATE_PROCEDURE_RESOLVER = new UpdateProcedureResolver();
    private static final CommandResolver BATCHED_UPDATE_RESOLVER = new BatchedUpdateResolver();
    private static final CommandResolver DYNAMIC_COMMAND_RESOLVER = new DynamicCommandResolver();
    private static final CommandResolver TEMP_TABLE_RESOLVER = new TempTableResolver();
    private static final CommandResolver ALTER_RESOLVER = new AlterResolver();
    private static final CommandResolver DUMMY_RESOLVER = new CommandResolver(){

        @Override
        public void resolveCommand(Command command, TempMetadataAdapter metadata, boolean resolveNullLiterals) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        }
    };

    public static Command expandCommand(ProcedureContainer proc, QueryMetadataInterface metadata, AnalysisRecord analysisRecord) throws QueryResolverException, QueryMetadataException, TeiidComponentException {
        ProcedureContainerResolver cr = (ProcedureContainerResolver)QueryResolver.chooseResolver(proc, metadata);
        Command command = cr.expandCommand(proc, metadata, analysisRecord);
        if (command == null) {
            return null;
        }
        QueryResolver.resolveCommand(command, proc.getGroup(), proc.getType(), metadata.getDesignTimeMetadata(), false);
        return command;
    }

    public static TempMetadataStore resolveCommand(Command command, QueryMetadataInterface metadata) throws QueryResolverException, TeiidComponentException {
        return QueryResolver.resolveCommand(command, metadata, true);
    }

    public static TempMetadataStore resolveCommand(Command currentCommand, GroupSymbol container, int type, QueryMetadataInterface metadata, boolean inferProcedureResultSetColumns) throws QueryResolverException, TeiidComponentException {
        ResolverUtil.resolveGroup(container, metadata);
        switch (type) {
            case 1: {
                QueryNode queryNode = metadata.getVirtualPlan(container.getMetadataID());
                return QueryResolver.resolveWithBindingMetadata(currentCommand, metadata, queryNode, false);
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                ProcedureContainerResolver.findChildCommandMetadata(currentCommand, container, type, metadata, inferProcedureResultSetColumns);
            }
        }
        return QueryResolver.resolveCommand(currentCommand, metadata, false);
    }

    public static TempMetadataStore resolveWithBindingMetadata(Command currentCommand, QueryMetadataInterface metadata, QueryNode queryNode, boolean replaceBindings) throws TeiidComponentException, QueryResolverException {
        HashMap<ElementSymbol, ElementSymbol> symbolMap = null;
        if (queryNode.getBindings() != null && queryNode.getBindings().size() > 0) {
            symbolMap = new HashMap<ElementSymbol, ElementSymbol>();
            final ArrayList<ElementSymbol> elements = new ArrayList<ElementSymbol>(queryNode.getBindings().size());
            boolean positional = true;
            for (Expression ses : QueryResolver.parseBindings(queryNode)) {
                String name = Symbol.getShortName(ses);
                if (ses instanceof AliasSymbol) {
                    ses = ((AliasSymbol)ses).getSymbol();
                    positional = false;
                }
                ElementSymbol elementSymbol = (ElementSymbol)ses;
                ResolverVisitor.resolveLanguageObject(elementSymbol, metadata);
                elementSymbol.setIsExternalReference(true);
                if (!positional) {
                    symbolMap.put(new ElementSymbol("INPUT." + name), elementSymbol.clone());
                    symbolMap.put(new ElementSymbol("INPUTS." + name), elementSymbol.clone());
                    elementSymbol.setShortName(name);
                }
                elements.add(elementSymbol);
            }
            if (positional) {
                ExpressionMappingVisitor emv = new ExpressionMappingVisitor(null){

                    @Override
                    public Expression replaceExpression(Expression element) {
                        if (!(element instanceof Reference)) {
                            return element;
                        }
                        Reference ref = (Reference)element;
                        if (!ref.isPositional()) {
                            return ref;
                        }
                        return ((ElementSymbol)elements.get(ref.getIndex())).clone();
                    }
                };
                DeepPostOrderNavigator.doVisit(currentCommand, emv);
            } else {
                TempMetadataStore rootExternalStore = new TempMetadataStore();
                GroupContext externalGroups = new GroupContext();
                ProcedureContainerResolver.addScalarGroup("INPUT", rootExternalStore, externalGroups, elements);
                ProcedureContainerResolver.addScalarGroup(BINDING_GROUP, rootExternalStore, externalGroups, elements);
                QueryResolver.setChildMetadata(currentCommand, rootExternalStore, externalGroups);
            }
        }
        TempMetadataStore result = QueryResolver.resolveCommand(currentCommand, metadata, false);
        if (replaceBindings && symbolMap != null && !symbolMap.isEmpty()) {
            ExpressionMappingVisitor emv = new ExpressionMappingVisitor(symbolMap);
            DeepPostOrderNavigator.doVisit(currentCommand, emv);
        }
        return result;
    }

    public static List<Expression> parseBindings(QueryNode planNode) throws TeiidComponentException {
        List<String> bindingsCol = planNode.getBindings();
        if (bindingsCol == null) {
            return Collections.emptyList();
        }
        ArrayList<Expression> parsedBindings = new ArrayList<Expression>(bindingsCol.size());
        Iterator bindings = bindingsCol.iterator();
        while (bindings.hasNext()) {
            try {
                Expression binding = QueryParser.getQueryParser().parseSelectExpression((String)bindings.next());
                parsedBindings.add(binding);
            }
            catch (QueryParserException err) {
                throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30063, (Throwable)((Object)err));
            }
        }
        return parsedBindings;
    }

    public static TempMetadataStore resolveCommand(Command currentCommand, QueryMetadataInterface metadata, boolean resolveNullLiterals) throws QueryResolverException, TeiidComponentException {
        LogManager.logTrace((String)"org.teiid.PLANNER.RESOLVER", (Object[])new Object[]{"Resolving command", currentCommand});
        TempMetadataAdapter resolverMetadata = null;
        try {
            TempMetadataStore discoveredMetadata = currentCommand.getTemporaryMetadata();
            if (discoveredMetadata == null) {
                discoveredMetadata = new TempMetadataStore();
                currentCommand.setTemporaryMetadata(discoveredMetadata);
            }
            resolverMetadata = new TempMetadataAdapter(metadata, discoveredMetadata);
            List<GroupSymbol> externalGroups = currentCommand.getAllExternalGroups();
            for (GroupSymbol extGroup : externalGroups) {
                Object metadataID = extGroup.getMetadataID();
                if (metadataID != null && (extGroup.getMetadataID() instanceof TempMetadataID || discoveredMetadata.getTempGroupID(extGroup.getName()) == null)) continue;
                boolean missing = metadataID == null;
                metadataID = resolverMetadata.getGroupID(extGroup.getName());
                if (missing) {
                    extGroup.setMetadataID(metadataID);
                    continue;
                }
                GroupSymbol gs = extGroup.clone();
                gs.setMetadataID(metadataID);
                currentCommand.getExternalGroupContexts().addGroup(gs);
            }
            CommandResolver resolver = QueryResolver.chooseResolver(currentCommand, resolverMetadata);
            resolver.resolveCommand(currentCommand, resolverMetadata, resolveNullLiterals);
        }
        catch (QueryMetadataException e) {
            throw new QueryResolverException((Throwable)((Object)e));
        }
        currentCommand.setIsResolved(true);
        return resolverMetadata.getMetadataStore();
    }

    private static CommandResolver chooseResolver(Command command, QueryMetadataInterface metadata) throws QueryResolverException, QueryMetadataException, TeiidComponentException {
        switch (command.getType()) {
            case 1: {
                if (command instanceof Query) {
                    return SIMPLE_QUERY_RESOLVER;
                }
                return SET_QUERY_RESOLVER;
            }
            case 2: {
                return INSERT_RESOLVER;
            }
            case 3: {
                return UPDATE_RESOLVER;
            }
            case 4: {
                return DELETE_RESOLVER;
            }
            case 6: {
                return EXEC_RESOLVER;
            }
            case 13: {
                return UPDATE_PROCEDURE_RESOLVER;
            }
            case 7: {
                return UPDATE_PROCEDURE_RESOLVER;
            }
            case 9: {
                return BATCHED_UPDATE_RESOLVER;
            }
            case 10: {
                return DYNAMIC_COMMAND_RESOLVER;
            }
            case 11: {
                return TEMP_TABLE_RESOLVER;
            }
            case 12: {
                return TEMP_TABLE_RESOLVER;
            }
            case 14: 
            case 15: 
            case 16: {
                return ALTER_RESOLVER;
            }
            case -1: {
                return DUMMY_RESOLVER;
            }
        }
        throw new AssertionError((Object)"Unknown command type");
    }

    public static void resolveCriteria(Criteria criteria, QueryMetadataInterface metadata) throws QueryResolverException, QueryMetadataException, TeiidComponentException {
        ResolverVisitor.resolveLanguageObject(criteria, metadata);
    }

    public static void setChildMetadata(Command subCommand, Command parent) {
        TempMetadataStore childMetadata = parent.getTemporaryMetadata();
        GroupContext parentContext = parent.getExternalGroupContexts();
        QueryResolver.setChildMetadata(subCommand, childMetadata, parentContext);
    }

    public static void setChildMetadata(Command subCommand, TempMetadataStore parentTempMetadata, GroupContext parentContext) {
        TempMetadataStore tempMetadata = subCommand.getTemporaryMetadata();
        if (tempMetadata == null) {
            subCommand.setTemporaryMetadata(parentTempMetadata.clone());
        } else {
            tempMetadata.getData().putAll(parentTempMetadata.getData());
        }
        subCommand.setExternalGroupContexts(parentContext);
    }

    public static Map<ElementSymbol, Expression> getVariableValues(Command command, boolean changingOnly, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        CommandResolver resolver = QueryResolver.chooseResolver(command, metadata);
        if (resolver instanceof VariableResolver) {
            return ((VariableResolver)((Object)resolver)).getVariableValues(command, changingOnly, metadata);
        }
        return Collections.emptyMap();
    }

    public static void resolveSubqueries(Command command, TempMetadataAdapter metadata, Collection<GroupSymbol> externalGroups) throws QueryResolverException, TeiidComponentException {
        for (SubqueryContainer<?> container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(command)) {
            QueryResolver.setChildMetadata(container.getCommand(), command);
            if (externalGroups != null) {
                ((Command)container.getCommand()).pushNewResolvingContext(externalGroups);
            }
            QueryResolver.resolveCommand(container.getCommand(), metadata.getMetadata(), false);
        }
    }

    public static QueryNode resolveView(GroupSymbol virtualGroup, QueryNode qnode, String cacheString, QueryMetadataInterface qmi, boolean logValidation) throws TeiidComponentException, QueryMetadataException, QueryResolverException, QueryValidatorException {
        qmi = qmi.getDesignTimeMetadata();
        cacheString = "transformation/" + cacheString;
        QueryNode cachedNode = (QueryNode)qmi.getFromMetadataCache(virtualGroup.getMetadataID(), cacheString);
        if (cachedNode == null) {
            Command result = qnode.getCommand();
            List<String> bindings = null;
            if (result == null) {
                try {
                    result = QueryParser.getQueryParser().parseCommand(qnode.getQuery());
                }
                catch (QueryParserException e) {
                    throw new QueryResolverException(QueryPlugin.Event.TEIID30065, (Throwable)((Object)e), QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30065, new Object[]{virtualGroup}));
                }
                bindings = qnode.getBindings();
            } else {
                result = (Command)result.clone();
            }
            if (bindings != null && !bindings.isEmpty()) {
                QueryResolver.resolveWithBindingMetadata(result, qmi, qnode, true);
            } else {
                QueryResolver.resolveCommand(result, qmi, false);
            }
            Request.validateWithVisitor(new ValidationVisitor(), qmi, result);
            QueryResolver.validateProjectedSymbols(virtualGroup, qmi, result);
            cachedNode = new QueryNode(qnode.getQuery());
            cachedNode.setCommand(result);
            if (QueryResolver.isView(virtualGroup, qmi)) {
                String updatePlan = qmi.getUpdatePlan(virtualGroup.getMetadataID());
                String deletePlan = qmi.getDeletePlan(virtualGroup.getMetadataID());
                String insertPlan = qmi.getInsertPlan(virtualGroup.getMetadataID());
                if (virtualGroup.getDefinition() != null) {
                    GroupSymbol group = new GroupSymbol(virtualGroup.getNonCorrelationName());
                    group.setMetadataID(virtualGroup.getMetadataID());
                    virtualGroup = group;
                }
                List<ElementSymbol> elements = ResolverUtil.resolveElementsInGroup(virtualGroup, qmi);
                UpdateValidator validator = new UpdateValidator(qmi, QueryResolver.determineType(insertPlan), QueryResolver.determineType(updatePlan), QueryResolver.determineType(deletePlan));
                validator.validate(result, elements);
                UpdateValidator.UpdateInfo info = validator.getUpdateInfo();
                if (logValidation && qmi.groupSupports(virtualGroup.getMetadataID(), 0)) {
                    if (info.isInherentInsert() && validator.getInsertReport().hasItems()) {
                        LogManager.logDetail((String)"org.teiid.PLANNER.RESOLVER", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31173, new Object[]{validator.getInsertReport().getFailureMessage(), "INSERT", qmi.getFullName(virtualGroup.getMetadataID())}));
                    }
                    if (info.isInherentUpdate() && validator.getUpdateReport().hasItems()) {
                        LogManager.logDetail((String)"org.teiid.PLANNER.RESOLVER", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31173, new Object[]{validator.getUpdateReport().getFailureMessage(), "UPDATE", qmi.getFullName(virtualGroup.getMetadataID())}));
                    }
                    if (info.isInherentDelete() && validator.getDeleteReport().hasItems()) {
                        LogManager.logDetail((String)"org.teiid.PLANNER.RESOLVER", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31173, new Object[]{validator.getDeleteReport().getFailureMessage(), "DELETE", qmi.getFullName(virtualGroup.getMetadataID())}));
                    }
                }
                cachedNode.setUpdateInfo(info);
            }
            qmi.addToMetadataCache(virtualGroup.getMetadataID(), cacheString, cachedNode);
        }
        return cachedNode;
    }

    public static void validateProjectedSymbols(GroupSymbol virtualGroup, QueryMetadataInterface qmi, Command result) throws QueryMetadataException, TeiidComponentException, QueryValidatorException {
        List<ElementSymbol> symbols = ResolverUtil.resolveElementsInGroup(virtualGroup, qmi);
        List<Expression> projectedSymbols = result.getProjectedSymbols();
        QueryResolver.validateProjectedSymbols(virtualGroup, symbols, projectedSymbols);
        if (result instanceof SetQuery) {
            ArrayList types = new ArrayList();
            for (ElementSymbol es : symbols) {
                types.add(es.getType());
            }
            ((SetQuery)result).setProjectedTypes(types, qmi.getDesignTimeMetadata());
        }
    }

    public static void validateProjectedSymbols(GroupSymbol virtualGroup, List<? extends Expression> symbols, List<? extends Expression> projectedSymbols) throws QueryValidatorException {
        if (symbols.size() != projectedSymbols.size()) {
            throw new QueryValidatorException((BundleUtil.Event)QueryPlugin.Event.TEIID30066, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30066, new Object[]{virtualGroup, symbols.size(), projectedSymbols.size()}));
        }
        for (int i = 0; i < projectedSymbols.size(); ++i) {
            Expression projectedSymbol = projectedSymbols.get(i);
            ResolverUtil.setTypeIfNull(projectedSymbol, symbols.get(i).getType());
            if (projectedSymbol.getType() == symbols.get(i).getType()) continue;
            throw new QueryValidatorException(QueryPlugin.Util.getString("QueryResolver.wrong_view_symbol_type", new Object[]{virtualGroup, i + 1, DataTypeManager.getDataTypeName(symbols.get(i).getType()), DataTypeManager.getDataTypeName(projectedSymbol.getType())}));
        }
    }

    public static boolean isView(GroupSymbol virtualGroup, QueryMetadataInterface qmi) throws TeiidComponentException, QueryMetadataException {
        return !(virtualGroup.getMetadataID() instanceof TempMetadataID) && qmi.isVirtualGroup(virtualGroup.getMetadataID());
    }

    private static UpdateValidator.UpdateType determineType(String plan) {
        UpdateValidator.UpdateType type = UpdateValidator.UpdateType.INHERENT;
        if (plan != null) {
            type = UpdateValidator.UpdateType.INSTEAD_OF;
        }
        return type;
    }
}

