/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache;

public class CacheConfiguration {
    public static CacheConfiguration DEFAULT = new CacheConfiguration(Policy.LRU, 3600, 100);
    private Policy policy;
    private int maxage;
    private int maxEntries;
    private boolean enabled = true;

    public CacheConfiguration() {
    }

    public CacheConfiguration(Policy policy, int maxAgeInSeconds, int maxNodes) {
        this.policy = policy;
        this.maxage = maxAgeInSeconds;
        this.maxEntries = maxNodes;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    public int getMaxAgeInSeconds() {
        return this.maxage;
    }

    public void setMaxAgeInSeconds(int maxage) {
        this.maxage = maxage;
    }

    public int getMaxEntries() {
        return this.maxEntries;
    }

    public void setMaxEntries(int entries) {
        this.maxEntries = entries;
    }

    public void setType(String type) {
        this.policy = Policy.valueOf(type);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.maxage;
        result = 31 * result + this.maxEntries;
        result = 31 * result + (this.policy == null ? 0 : this.policy.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheConfiguration other = (CacheConfiguration)obj;
        if (this.maxage != other.maxage) {
            return false;
        }
        if (this.maxEntries != other.maxEntries) {
            return false;
        }
        return !(this.policy == null ? other.policy != null : !this.policy.equals((Object)other.policy));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static enum Policy {
        LRU,
        EXPIRATION;

    }
}

