/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.Streamable;
import org.teiid.dqp.DQPPlugin;
import org.teiid.query.sql.symbol.Expression;

public class LobManager {
    private Map<String, Streamable<?>> lobReferences = new ConcurrentHashMap();

    public void updateReferences(int[] lobIndexes, List<?> tuple) throws TeiidComponentException {
        for (int i = 0; i < lobIndexes.length; ++i) {
            Object anObj = tuple.get(lobIndexes[i]);
            if (!(anObj instanceof Streamable)) continue;
            Streamable lob = (Streamable)anObj;
            if (lob.getReference() == null) {
                lob.setReference(this.getLobReference(lob.getReferenceStreamId()).getReference());
                continue;
            }
            String id = lob.getReferenceStreamId();
            this.lobReferences.put(id, lob);
        }
    }

    public Streamable<?> getLobReference(String id) throws TeiidComponentException {
        Streamable<?> lob = null;
        if (this.lobReferences != null) {
            lob = this.lobReferences.get(id);
        }
        if (lob == null) {
            throw new TeiidComponentException(DQPPlugin.Util.getString("ProcessWorker.wrongdata"));
        }
        return lob;
    }

    public void clear() {
        this.lobReferences.clear();
    }

    public static int[] getLobIndexes(List expressions) {
        if (expressions == null) {
            return null;
        }
        int[] result = new int[expressions.size()];
        int resultIndex = 0;
        for (int i = 0; i < expressions.size(); ++i) {
            Expression expr = (Expression)expressions.get(i);
            if (!DataTypeManager.isLOB((Class)expr.getType()) && expr.getType() != DataTypeManager.DefaultDataClasses.OBJECT) continue;
            result[resultIndex++] = i;
        }
        if (resultIndex == 0) {
            return null;
        }
        return Arrays.copyOf(result, resultIndex);
    }
}

