/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.core.id;

import org.teiid.core.CorePlugin;
import org.teiid.core.id.InvalidIDException;
import org.teiid.core.id.ObjectID;
import org.teiid.core.id.ObjectIDFactory;
import org.teiid.core.id.ParsedObjectID;
import org.teiid.core.id.UUID;

public class UUIDFactory
implements ObjectIDFactory {
    @Override
    public String getDescription() {
        return CorePlugin.Util.getString("UUIDFactory.Description");
    }

    @Override
    public ObjectID stringWithoutProtocolToObject(String value) throws InvalidIDException {
        return UUID.stringToObject(value);
    }

    @Override
    public ObjectID stringToObject(String value) throws InvalidIDException {
        ParsedObjectID parsedID = ParsedObjectID.parsedStringifiedObjectID(value, "mmuuid");
        return UUID.stringToObject(parsedID.getRemainder());
    }

    @Override
    public String getProtocol() {
        return "mmuuid";
    }

    @Override
    public ObjectID create() {
        return new UUID(java.util.UUID.randomUUID());
    }
}

