/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.DQPPlugin;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.multisource.MultiSourceElement;
import org.teiid.logging.AuditMessage;
import org.teiid.logging.LogManager;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.validator.AbstractValidationVisitor;

public class AuthorizationValidationVisitor
extends AbstractValidationVisitor {
    private VDBMetaData vdb;
    private HashMap<String, DataPolicy> allowedPolicies;
    private String userName;
    private boolean useEntitlements;

    public AuthorizationValidationVisitor(VDBMetaData vdb, boolean useEntitlements, HashMap<String, DataPolicy> policies, String user) {
        this.vdb = vdb;
        this.allowedPolicies = policies;
        this.userName = user;
        this.useEntitlements = useEntitlements;
    }

    @Override
    public void visit(GroupSymbol obj) {
        try {
            Object modelID = this.getMetadata().getModelID(obj.getMetadataID());
            this.validateModelVisibility(modelID, obj);
        }
        catch (QueryMetadataException e) {
            this.handleException((TeiidException)e, obj);
        }
        catch (TeiidComponentException e) {
            this.handleException((TeiidException)e, obj);
        }
    }

    @Override
    public void visit(Delete obj) {
        this.validateEntitlements(obj);
    }

    @Override
    public void visit(Insert obj) {
        this.validateEntitlements(obj);
    }

    @Override
    public void visit(Query obj) {
        this.validateEntitlements(obj);
    }

    @Override
    public void visit(Update obj) {
        this.validateEntitlements(obj);
    }

    @Override
    public void visit(StoredProcedure obj) {
        this.validateModelVisibility(obj.getModelID(), obj.getGroup());
        this.validateEntitlements(obj);
    }

    @Override
    public void visit(Function obj) {
        if ("lookup".equalsIgnoreCase(obj.getName())) {
            try {
                ResolverUtil.ResolvedLookup lookup = ResolverUtil.resolveLookup(obj, this.getMetadata());
                this.validateModelVisibility(this.getMetadata().getModelID(lookup.getGroup().getMetadataID()), lookup.getGroup());
                LinkedList<Symbol> symbols = new LinkedList<Symbol>();
                symbols.add(lookup.getGroup());
                symbols.add(lookup.getKeyElement());
                symbols.add(lookup.getReturnElement());
                this.validateEntitlements(symbols, DataPolicy.PermissionType.READ, Context.QUERY);
            }
            catch (TeiidComponentException e) {
                this.handleException((TeiidException)e, obj);
            }
            catch (TeiidProcessingException e) {
                this.handleException((TeiidException)e, obj);
            }
        }
    }

    protected void validateEntitlements(Insert obj) {
        this.validateEntitlements(obj.getVariables(), DataPolicy.PermissionType.CREATE, Context.INSERT);
    }

    protected void validateEntitlements(Update obj) {
        if (obj.getCriteria() != null) {
            this.validateEntitlements(ElementCollectorVisitor.getElements((LanguageObject)obj.getCriteria(), true), DataPolicy.PermissionType.READ, Context.UPDATE);
        }
        this.validateEntitlements(obj.getChangeList().getClauseMap().keySet(), DataPolicy.PermissionType.UPDATE, Context.UPDATE);
    }

    protected void validateEntitlements(Delete obj) {
        if (obj.getCriteria() != null) {
            this.validateEntitlements(ElementCollectorVisitor.getElements((LanguageObject)obj.getCriteria(), true), DataPolicy.PermissionType.READ, Context.DELETE);
        }
        this.validateEntitlements(Arrays.asList(obj.getGroup()), DataPolicy.PermissionType.DELETE, Context.DELETE);
    }

    protected void validateEntitlements(Query obj) {
        Into intoObj = obj.getInto();
        if (intoObj != null) {
            GroupSymbol intoGroup = intoObj.getGroup();
            List<ElementSymbol> intoElements = null;
            try {
                intoElements = ResolverUtil.resolveElementsInGroup(intoGroup, this.getMetadata());
            }
            catch (QueryMetadataException err) {
                this.handleException((TeiidException)err, intoGroup);
            }
            catch (TeiidComponentException err) {
                this.handleException((TeiidException)err, intoGroup);
            }
            this.validateEntitlements(intoElements, DataPolicy.PermissionType.CREATE, Context.INSERT);
        }
        Collection<GroupSymbol> entitledObjects = GroupCollectorVisitor.getGroups((LanguageObject)obj, true);
        if (!this.isXMLCommand(obj)) {
            entitledObjects.addAll(ElementCollectorVisitor.getElements((LanguageObject)obj, true));
        }
        if (entitledObjects.size() == 0) {
            return;
        }
        this.validateEntitlements(entitledObjects, DataPolicy.PermissionType.READ, Context.QUERY);
    }

    protected void validateEntitlements(StoredProcedure obj) {
        this.validateEntitlements(Arrays.asList(obj.getGroup()), DataPolicy.PermissionType.READ, Context.STORED_PROCEDURE);
    }

    private String getActionLabel(DataPolicy.PermissionType actionCode) {
        switch (actionCode) {
            case READ: {
                return "Read";
            }
            case CREATE: {
                return "Create";
            }
            case UPDATE: {
                return "Update";
            }
            case DELETE: {
                return "Delete";
            }
        }
        return "UNKNOWN";
    }

    protected void validateEntitlements(Collection<? extends Symbol> symbols, DataPolicy.PermissionType actionCode, Context auditContext) {
        Set<String> inaccessibleResources;
        HashMap<String, Symbol> nameToSymbolMap = new HashMap<String, Symbol>();
        for (Symbol symbol : symbols) {
            try {
                GroupSymbol group;
                String fullName = null;
                Object metadataID = null;
                if (symbol instanceof ElementSymbol ? (metadataID = ((ElementSymbol)symbol).getMetadataID()) instanceof MultiSourceElement || metadataID instanceof TempMetadataID : symbol instanceof GroupSymbol && (metadataID = (group = (GroupSymbol)symbol).getMetadataID()) instanceof TempMetadataID && !group.isProcedure()) continue;
                fullName = this.getMetadata().getFullName(metadataID);
                nameToSymbolMap.put(fullName, symbol);
            }
            catch (QueryMetadataException e) {
                this.handleException((TeiidException)e);
            }
            catch (TeiidComponentException e) {
                this.handleException((TeiidException)e);
            }
        }
        if (!nameToSymbolMap.isEmpty() && (inaccessibleResources = this.getInaccessibleResources(actionCode, nameToSymbolMap.keySet(), auditContext)).size() > 0) {
            ArrayList arrayList = new ArrayList(inaccessibleResources.size());
            for (String name : inaccessibleResources) {
                arrayList.add(nameToSymbolMap.get(name));
            }
            this.handleValidationError(DQPPlugin.Util.getString("ERR.018.005.0095", new Object[]{DQPWorkContext.getWorkContext().getSessionId(), this.getActionLabel(actionCode)}), arrayList);
        }
    }

    protected void validateModelVisibility(Object modelID, GroupSymbol group) {
        if (modelID instanceof TempMetadataID) {
            return;
        }
        try {
            String modelName = this.getMetadata().getFullName(modelID);
            ModelMetaData model = this.vdb.getModel(modelName);
            if (!model.isVisible()) {
                this.handleValidationError(DQPPlugin.Util.getString("ERR.018.005.0088", new Object[]{this.getMetadata().getFullName(group.getMetadataID())}));
            }
        }
        catch (TeiidComponentException e) {
            this.handleException((TeiidException)e, group);
        }
    }

    public Set<String> getInaccessibleResources(DataPolicy.PermissionType action, Set<String> resources, Context context) {
        if (!this.useEntitlements) {
            return Collections.emptySet();
        }
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.AUDIT_LOG", (int)5)) {
            AuditMessage msg = new AuditMessage(context.name(), "getInaccessibleResources-request", this.userName, resources.toArray(new String[resources.size()]));
            LogManager.logDetail((String)"org.teiid.AUDIT_LOG", (Object[])new Object[]{msg});
        }
        HashSet<String> results = new HashSet<String>(resources);
        for (DataPolicy p : this.allowedPolicies.values()) {
            DataPolicyMetadata policy = (DataPolicyMetadata)p;
            if (results.isEmpty()) break;
            Iterator<String> i = results.iterator();
            while (i.hasNext()) {
                if (!policy.allows(i.next(), action)) continue;
                i.remove();
            }
        }
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.AUDIT_LOG", (int)5)) {
            AuditMessage msg;
            if (results.isEmpty()) {
                msg = new AuditMessage(context.name(), "getInaccessibleResources-granted all", this.userName, resources.toArray(new String[resources.size()]));
                LogManager.logDetail((String)"org.teiid.AUDIT_LOG", (Object[])new Object[]{msg});
            } else {
                msg = new AuditMessage(context.name(), "getInaccessibleResources-denied", this.userName, resources.toArray(new String[resources.size()]));
                LogManager.logDetail((String)"org.teiid.AUDIT_LOG", (Object[])new Object[]{msg});
            }
        }
        return results;
    }

    public static enum Context {
        QUERY,
        INSERT,
        UPDATE,
        DELETE,
        STORED_PROCEDURE;

    }
}

