/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLXML;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.client.RequestMessage;
import org.teiid.client.util.ResultsFuture;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.Assertion;
import org.teiid.dqp.DQPPlugin;
import org.teiid.dqp.internal.datamgr.ConnectorManagerRepository;
import org.teiid.dqp.internal.datamgr.ConnectorWork;
import org.teiid.dqp.internal.process.DQPCore;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.DataTierTupleSource;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.RequestID;
import org.teiid.dqp.service.BufferService;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.ForeignKey;
import org.teiid.metadata.KeyRecord;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.ProcedureParameter;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;
import org.teiid.query.metadata.CompositeMetadataStore;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TransformationMetadata;
import org.teiid.query.processor.CollectionTupleSource;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.tempdata.TempTableStore;
import org.teiid.query.util.CommandContext;

public class DataTierManagerImpl
implements ProcessorDataManager {
    private DQPCore requestMgr;
    private BufferService bufferService;

    public DataTierManagerImpl(DQPCore requestMgr, BufferService bufferService) {
        this.requestMgr = requestMgr;
        this.bufferService = bufferService;
    }

    @Override
    public TupleSource registerRequest(CommandContext context, Command command, String modelName, String connectorBindingId, int nodeID) throws TeiidComponentException, TeiidProcessingException {
        RequestWorkItem workItem = this.requestMgr.getRequestWorkItem((RequestID)context.getProcessorID());
        if ("SYS".equals(modelName)) {
            return this.processSystemQuery(context, command, workItem.getDqpWorkContext());
        }
        AtomicRequestMessage aqr = this.createRequest(context.getProcessorID(), command, modelName, connectorBindingId, nodeID);
        ConnectorManagerRepository cmr = (ConnectorManagerRepository)workItem.getDqpWorkContext().getVDB().getAttachment(ConnectorManagerRepository.class);
        ConnectorWork work = cmr.getConnectorManager(aqr.getConnectorName()).registerRequest(aqr);
        return new DataTierTupleSource(aqr, workItem, work, this);
    }

    /*
     * WARNING - void declaration
     */
    private TupleSource processSystemQuery(CommandContext context, Command command, DQPWorkContext workContext) throws TeiidComponentException, TeiidProcessingException {
        ArrayList<List<Serializable>> rows;
        block51: {
            VDBMetaData vdb;
            block50: {
                String vdbName = workContext.getVdbName();
                int vdbVersion = workContext.getVdbVersion();
                vdb = workContext.getVDB();
                CompositeMetadataStore metadata = ((TransformationMetadata)vdb.getAttachment(TransformationMetadata.class)).getMetadataStore();
                rows = new ArrayList<List<Serializable>>();
                int oid = 0;
                if (!(command instanceof Query)) break block50;
                Query query = (Query)command;
                UnaryFromClause ufc = (UnaryFromClause)query.getFrom().getClauses().get(0);
                GroupSymbol group = ufc.getGroup();
                SystemTables sysTable = SystemTables.valueOf(group.getNonCorrelationName().substring("SYS".length() + 1).toUpperCase());
                switch (sysTable) {
                    case DATATYPES: {
                        for (Datatype datatype : metadata.getDatatypes()) {
                            rows.add(Arrays.asList(datatype.getName(), datatype.isBuiltin(), datatype.isBuiltin(), datatype.getName(), datatype.getJavaClassName(), datatype.getScale(), datatype.getLength(), datatype.getNullType().toString(), datatype.isSigned(), datatype.isAutoIncrement(), datatype.isCaseSensitive(), datatype.getPrecisionLength(), datatype.getRadix(), datatype.getSearchType().toString(), datatype.getUUID(), datatype.getRuntimeTypeName(), datatype.getBasetypeName(), datatype.getAnnotation(), oid++));
                        }
                        break block51;
                    }
                    case VIRTUALDATABASES: {
                        rows.add(Arrays.asList(vdbName, vdbVersion));
                        break;
                    }
                    case SCHEMAS: {
                        for (Schema model : this.getVisibleSchemas(vdb, metadata)) {
                            rows.add(Arrays.asList(vdbName, model.getName(), model.isPhysical(), model.getUUID(), model.getAnnotation(), model.getPrimaryMetamodelUri(), oid++));
                        }
                        break block51;
                    }
                    case PROCEDURES: {
                        for (Schema schema : this.getVisibleSchemas(vdb, metadata)) {
                            for (Procedure proc : schema.getProcedures().values()) {
                                rows.add(Arrays.asList(vdbName, proc.getParent().getName(), proc.getName(), proc.getNameInSource(), proc.getResultSet() != null, proc.getUUID(), proc.getAnnotation(), oid++));
                            }
                        }
                        break block51;
                    }
                    case PROCEDUREPARAMS: {
                        for (Schema schema : this.getVisibleSchemas(vdb, metadata)) {
                            for (Procedure proc : schema.getProcedures().values()) {
                                Datatype dt;
                                for (ProcedureParameter param : proc.getParameters()) {
                                    dt = param.getDatatype();
                                    rows.add(Arrays.asList(vdbName, proc.getParent().getName(), proc.getName(), param.getName(), dt != null ? dt.getRuntimeTypeName() : null, param.getPosition(), param.getType().toString(), param.isOptional(), param.getPrecision(), param.getLength(), param.getScale(), param.getRadix(), param.getNullType().toString(), param.getUUID(), param.getAnnotation(), oid++));
                                }
                                if (proc.getResultSet() == null) continue;
                                for (ProcedureParameter param : proc.getResultSet().getColumns()) {
                                    dt = param.getDatatype();
                                    rows.add(Arrays.asList(vdbName, proc.getParent().getName(), proc.getName(), param.getName(), dt != null ? dt.getRuntimeTypeName() : null, param.getPosition(), "ResultSet", false, param.getPrecision(), param.getLength(), param.getScale(), param.getRadix(), param.getNullType().toString(), param.getUUID(), param.getAnnotation(), oid++));
                                }
                            }
                        }
                        break block51;
                    }
                    case PROPERTIES: {
                        LinkedHashSet<Object> records = new LinkedHashSet<Object>();
                        records.addAll(metadata.getDatatypes());
                        for (Schema schema : this.getVisibleSchemas(vdb, metadata)) {
                            records.add(schema);
                            records.addAll(schema.getTables().values());
                            for (Table table : schema.getTables().values()) {
                                records.add(table);
                                records.addAll(table.getColumns());
                                records.addAll(table.getAllKeys());
                            }
                            for (Procedure proc : schema.getProcedures().values()) {
                                records.add(proc);
                                records.addAll(proc.getParameters());
                                if (proc.getResultSet() == null) continue;
                                records.addAll(proc.getResultSet().getColumns());
                            }
                        }
                        for (AbstractMetadataRecord abstractMetadataRecord : records) {
                            for (Map.Entry entry : abstractMetadataRecord.getProperties().entrySet()) {
                                rows.add(Arrays.asList((Serializable)entry.getKey(), (Serializable)entry.getValue(), abstractMetadataRecord.getUUID(), oid++));
                            }
                        }
                        break block51;
                    }
                    default: {
                        for (Schema schema : this.getVisibleSchemas(vdb, metadata)) {
                            for (Table table : schema.getTables().values()) {
                                switch (sysTable) {
                                    case TABLES: {
                                        rows.add(Arrays.asList(vdbName, schema.getName(), table.getName(), table.getTableType().toString(), table.getNameInSource(), table.isPhysical(), table.supportsUpdate(), table.getUUID(), table.getCardinality(), table.getAnnotation(), table.isSystem(), table.isMaterialized(), oid++));
                                        break;
                                    }
                                    case COLUMNS: {
                                        for (Column column : table.getColumns()) {
                                            Datatype dt = column.getDatatype();
                                            rows.add(Arrays.asList(vdbName, schema.getName(), table.getName(), column.getName(), column.getPosition(), column.getNameInSource(), dt != null ? dt.getRuntimeTypeName() : null, column.getScale(), column.getLength(), column.isFixedLength(), column.isSelectable(), column.isUpdatable(), column.isCaseSensitive(), column.isSigned(), column.isCurrency(), column.isAutoIncremented(), column.getNullType().toString(), column.getMinimumValue(), column.getMaximumValue(), column.getSearchType().toString(), column.getFormat(), column.getDefaultValue(), dt != null ? dt.getJavaClassName() : null, column.getPrecision(), column.getCharOctetLength(), column.getRadix(), column.getUUID(), column.getAnnotation(), oid++));
                                        }
                                        break;
                                    }
                                    case KEYS: {
                                        for (KeyRecord key : table.getAllKeys()) {
                                            rows.add(Arrays.asList(vdbName, ((Schema)table.getParent()).getName(), table.getName(), key.getName(), key.getAnnotation(), key.getNameInSource(), key.getType().toString(), false, key instanceof ForeignKey ? ((ForeignKey)key).getUniqueKeyID() : null, key.getUUID(), oid++));
                                        }
                                        break;
                                    }
                                    case KEYCOLUMNS: {
                                        for (KeyRecord key : table.getAllKeys()) {
                                            int postition = 1;
                                            for (Column column : key.getColumns()) {
                                                rows.add(Arrays.asList(vdbName, schema.getName(), table.getName(), column.getName(), key.getName(), key.getType().toString(), key instanceof ForeignKey ? ((ForeignKey)key).getUniqueKeyID() : null, key.getUUID(), postition++, oid++));
                                            }
                                        }
                                        break;
                                    }
                                    case REFERENCEKEYCOLUMNS: {
                                        for (KeyRecord key : table.getForeignKeys()) {
                                            short postition = 0;
                                            for (Column column : key.getColumns()) {
                                                Table pkTable = (Table)key.getPrimaryKey().getParent();
                                                Serializable[] serializableArray = new Serializable[14];
                                                serializableArray[0] = vdbName;
                                                serializableArray[1] = ((Schema)pkTable.getParent()).getName();
                                                serializableArray[2] = pkTable.getName();
                                                serializableArray[3] = ((Column)key.getPrimaryKey().getColumns().get(postition)).getName();
                                                serializableArray[4] = vdbName;
                                                serializableArray[5] = schema.getName();
                                                serializableArray[6] = table.getName();
                                                serializableArray[7] = column.getName();
                                                postition = (short)(postition + 1);
                                                serializableArray[8] = Short.valueOf(postition);
                                                serializableArray[9] = Integer.valueOf(3);
                                                serializableArray[10] = Integer.valueOf(3);
                                                serializableArray[11] = key.getName();
                                                serializableArray[12] = key.getPrimaryKey().getName();
                                                serializableArray[13] = Integer.valueOf(5);
                                                rows.add(Arrays.asList(serializableArray));
                                            }
                                        }
                                        break;
                                    }
                                    case MATVIEWS: {
                                        if (!table.isMaterialized()) break;
                                        String targetSchema = null;
                                        String matTableName = null;
                                        String state = null;
                                        Timestamp updated = null;
                                        Integer cardinaltity = null;
                                        Boolean valid = null;
                                        if (table.getMaterializedTable() == null) {
                                            TempTableStore globalStore = context.getGlobalTableStore();
                                            matTableName = "#MAT_" + table.getFullName().toUpperCase();
                                            TempTableStore.MatTableInfo info = globalStore.getMatTableInfo(matTableName);
                                            valid = info.isValid();
                                            state = info.getState().name();
                                            updated = info.getUpdateTime() == -1L ? null : new Timestamp(info.getUpdateTime());
                                            TempMetadataID id = globalStore.getMetadataStore().getTempGroupID(matTableName);
                                            if (id != null) {
                                                cardinaltity = id.getCardinality();
                                            }
                                        } else {
                                            Table t = table.getMaterializedTable();
                                            matTableName = t.getName();
                                            targetSchema = ((Schema)t.getParent()).getName();
                                        }
                                        rows.add(Arrays.asList(vdbName, schema.getName(), table.getName(), targetSchema, matTableName, valid, state, updated, cardinaltity));
                                    }
                                }
                            }
                        }
                        break block51;
                    }
                }
                break block51;
            }
            TransformationMetadata indexMetadata = (TransformationMetadata)vdb.getAttachment(TransformationMetadata.class);
            StoredProcedure proc = (StoredProcedure)command;
            SystemProcs sysTable = SystemProcs.valueOf(proc.getProcedureCallableName().substring("SYS".length() + 1).toUpperCase());
            switch (sysTable) {
                case GETVDBRESOURCEPATHS: {
                    void var16_41;
                    String[] filePaths;
                    String[] arr$ = filePaths = indexMetadata.getVDBResourcePaths();
                    int len$ = arr$.length;
                    boolean bl = false;
                    while (var16_41 < len$) {
                        String filePath = arr$[var16_41];
                        rows.add(Arrays.asList(filePath, filePath.endsWith(".INDEX")));
                        ++var16_41;
                    }
                    break;
                }
                case GETBINARYVDBRESOURCE: {
                    String filePath = (String)((Constant)proc.getParameter(1).getExpression()).getValue();
                    BlobImpl contents = indexMetadata.getVDBResourceAsBlob(filePath);
                    if (contents == null) break;
                    rows.add(Arrays.asList(new BlobType((Blob)contents)));
                    break;
                }
                case GETCHARACTERVDBRESOURCE: {
                    String filePath = (String)((Constant)proc.getParameter(1).getExpression()).getValue();
                    ClobImpl clobImpl = indexMetadata.getVDBResourceAsClob(filePath);
                    if (clobImpl == null) break;
                    rows.add(Arrays.asList(new ClobType((Clob)clobImpl)));
                    break;
                }
                case GETXMLSCHEMAS: {
                    try {
                        Table groupID = indexMetadata.getGroupID((String)((Constant)proc.getParameter(1).getExpression()).getValue());
                        List<SQLXMLImpl> schemas = indexMetadata.getXMLSchemas(groupID);
                        for (SQLXMLImpl schema : schemas) {
                            rows.add(Arrays.asList(new XMLType((SQLXML)schema)));
                        }
                        break;
                    }
                    catch (QueryMetadataException e) {
                        throw new TeiidProcessingException((Throwable)((Object)e));
                    }
                }
            }
        }
        return new CollectionTupleSource(rows.iterator());
    }

    private List<Schema> getVisibleSchemas(VDBMetaData vdb, CompositeMetadataStore metadata) {
        ArrayList<Schema> result = new ArrayList<Schema>();
        for (Schema schema : metadata.getSchemas().values()) {
            ModelMetaData model = vdb.getModel(schema.getName());
            if (!model.isVisible()) continue;
            result.add(schema);
        }
        return result;
    }

    private AtomicRequestMessage createRequest(Object processorId, Command command, String modelName, String connectorBindingId, int nodeID) throws TeiidProcessingException, TeiidComponentException {
        RequestWorkItem workItem = this.requestMgr.getRequestWorkItem((RequestID)processorId);
        RequestMessage request = workItem.requestMsg;
        AtomicRequestMessage aqr = new AtomicRequestMessage(request, workItem.getDqpWorkContext(), nodeID);
        aqr.setCommand(command);
        aqr.setModelName(modelName);
        aqr.setMaxResultRows(this.requestMgr.getMaxSourceRows());
        aqr.setExceptionOnMaxRows(this.requestMgr.isExceptionOnMaxSourceRows());
        aqr.setPartialResults(request.supportsPartialResults());
        if (nodeID >= 0) {
            aqr.setTransactionContext(workItem.getTransactionContext());
        }
        aqr.setFetchSize(this.bufferService.getBufferManager().getConnectorBatchSize());
        if (connectorBindingId == null) {
            VDBMetaData vdb = workItem.getDqpWorkContext().getVDB();
            ModelMetaData model = vdb.getModel(modelName);
            List bindings = model.getSourceNames();
            if (bindings == null || bindings.size() != 1) {
                throw new TeiidComponentException(DQPPlugin.Util.getString("DataTierManager.could_not_obtain_connector_binding", new Object[]{modelName, workItem.getDqpWorkContext().getVdbName(), workItem.getDqpWorkContext().getVdbVersion()}));
            }
            connectorBindingId = (String)bindings.get(0);
            Assertion.isNotNull((Object)connectorBindingId, (String)"could not obtain connector id");
        }
        aqr.setConnectorName(connectorBindingId);
        return aqr;
    }

    @Override
    public Object lookupCodeValue(CommandContext context, String codeTableName, String returnElementName, String keyElementName, Object keyValue) throws BlockedException, TeiidComponentException, TeiidProcessingException {
        throw new UnsupportedOperationException();
    }

    <T> ResultsFuture<T> addWork(Callable<T> callable, int priority) {
        return this.requestMgr.addWork(callable, priority);
    }

    void scheduleWork(Runnable r, int priority, long delay) {
        this.requestMgr.scheduleWork(r, priority, delay);
    }

    private static enum SystemProcs {
        GETCHARACTERVDBRESOURCE,
        GETBINARYVDBRESOURCE,
        GETVDBRESOURCEPATHS,
        GETXMLSCHEMAS;

    }

    private static enum SystemTables {
        VIRTUALDATABASES,
        SCHEMAS,
        TABLES,
        DATATYPES,
        COLUMNS,
        KEYS,
        PROCEDURES,
        KEYCOLUMNS,
        PROCEDUREPARAMS,
        REFERENCEKEYCOLUMNS,
        PROPERTIES,
        MATVIEWS;

    }
}

