/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.teiid.client.SourceWarning;
import org.teiid.client.util.ResultsFuture;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.TupleSource;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.Assertion;
import org.teiid.dqp.internal.datamgr.ConnectorWork;
import org.teiid.dqp.internal.process.DataTierManagerImpl;
import org.teiid.dqp.internal.process.RequestWorkItem;
import org.teiid.dqp.message.AtomicRequestMessage;
import org.teiid.dqp.message.AtomicResultsMessage;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.TranslatorException;

public class DataTierTupleSource
implements TupleSource {
    private final AtomicRequestMessage aqr;
    private final RequestWorkItem workItem;
    private final ConnectorWork cwi;
    private final DataTierManagerImpl dtm;
    private int index;
    private int rowsProcessed;
    private volatile AtomicResultsMessage arm;
    private boolean closed;
    private volatile boolean canceled;
    private boolean executed;
    private volatile boolean done;
    private volatile ResultsFuture<AtomicResultsMessage> futureResult;
    private volatile boolean running;

    public DataTierTupleSource(AtomicRequestMessage aqr, RequestWorkItem workItem, ConnectorWork cwi, DataTierManagerImpl dtm) {
        this.aqr = aqr;
        this.workItem = workItem;
        this.cwi = cwi;
        this.dtm = dtm;
        Assertion.isNull((Object)workItem.getConnectorRequest(aqr.getAtomicRequestID()));
        workItem.addConnectorRequest(aqr.getAtomicRequestID(), this);
        if (!aqr.isTransactional()) {
            this.addWork();
        }
    }

    private void addWork() {
        this.futureResult = this.dtm.addWork(new Callable<AtomicResultsMessage>(){

            @Override
            public AtomicResultsMessage call() throws Exception {
                return DataTierTupleSource.this.getResults();
            }
        }, 100);
        this.futureResult.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<AtomicResultsMessage>(){

            public void onCompletion(ResultsFuture<AtomicResultsMessage> future) {
                DataTierTupleSource.this.workItem.moreWork();
            }
        });
    }

    public List getSchema() {
        return this.aqr.getCommand().getProjectedSymbols();
    }

    @Override
    public List<?> nextTuple() throws TeiidComponentException, TeiidProcessingException {
        do {
            if (this.arm == null) {
                AtomicResultsMessage results = null;
                try {
                    results = this.futureResult != null || !this.aqr.isTransactional() ? this.asynchGet() : this.getResults();
                }
                catch (TranslatorException e) {
                    this.exceptionOccurred(e, true);
                }
                catch (DataNotAvailableException e) {
                    this.dtm.scheduleWork(new Runnable(){

                        @Override
                        public void run() {
                            DataTierTupleSource.this.workItem.moreWork();
                        }
                    }, 10, e.getRetryDelay());
                    throw BlockedException.INSTANCE;
                }
                this.receiveResults(results);
            }
            if (this.index < this.arm.getResults().length) {
                return this.arm.getResults()[this.index++];
            }
            this.arm = null;
        } while (!this.isDone());
        return null;
    }

    private AtomicResultsMessage asynchGet() throws BlockedException, TeiidProcessingException, TeiidComponentException, TranslatorException {
        if (this.futureResult == null) {
            this.addWork();
        }
        if (!this.futureResult.isDone()) {
            throw BlockedException.INSTANCE;
        }
        ResultsFuture<AtomicResultsMessage> currentResults = this.futureResult;
        this.futureResult = null;
        AtomicResultsMessage results = null;
        try {
            results = (AtomicResultsMessage)currentResults.get();
            if (results.getFinalRow() < 0) {
                this.addWork();
            }
        }
        catch (InterruptedException e) {
            throw new TeiidRuntimeException((Throwable)e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof TeiidProcessingException) {
                throw (TeiidProcessingException)e.getCause();
            }
            if (e.getCause() instanceof TeiidComponentException) {
                throw (TeiidComponentException)e.getCause();
            }
            if (e.getCause() instanceof TranslatorException) {
                throw (TranslatorException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e);
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AtomicResultsMessage getResults() throws BlockedException, TeiidComponentException, TranslatorException {
        AtomicResultsMessage results = null;
        try {
            this.running = true;
            if (!this.executed) {
                results = this.cwi.execute();
                this.executed = true;
            } else {
                results = this.cwi.more();
            }
        }
        finally {
            this.running = false;
        }
        return results;
    }

    public boolean isQueued() {
        ResultsFuture<AtomicResultsMessage> future = this.futureResult;
        return !this.running && future != null && !future.isDone();
    }

    public boolean isDone() {
        return this.done;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void fullyCloseSource() {
        if (!this.closed) {
            if (this.cwi != null) {
                this.workItem.closeAtomicRequest(this.aqr.getAtomicRequestID());
                if (!this.aqr.isTransactional()) {
                    if (this.futureResult != null && !this.futureResult.isDone()) {
                        this.futureResult.addCompletionListener((ResultsFuture.CompletionListener)new ResultsFuture.CompletionListener<AtomicResultsMessage>(){

                            public void onCompletion(ResultsFuture<AtomicResultsMessage> future) {
                                DataTierTupleSource.this.cwi.close();
                            }
                        });
                    } else {
                        this.dtm.addWork(new Callable<Void>(){

                            @Override
                            public Void call() throws Exception {
                                DataTierTupleSource.this.cwi.close();
                                return null;
                            }
                        }, 0);
                    }
                } else {
                    this.cwi.close();
                }
            }
            this.closed = true;
        }
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void cancelRequest() {
        this.canceled = true;
        if (this.cwi != null) {
            this.cwi.cancel();
        }
    }

    @Override
    public void closeSource() {
        if (this.arm == null || this.arm.supportsImplicitClose()) {
            this.fullyCloseSource();
        }
    }

    void exceptionOccurred(TranslatorException exception, boolean removeState) throws TeiidComponentException, TeiidProcessingException {
        if (removeState) {
            this.fullyCloseSource();
        }
        if (!this.workItem.requestMsg.supportsPartialResults()) {
            if (exception.getCause() instanceof TeiidComponentException) {
                throw (TeiidComponentException)exception.getCause();
            }
            if (exception.getCause() instanceof TeiidProcessingException) {
                throw (TeiidProcessingException)exception.getCause();
            }
            throw new TeiidProcessingException((Throwable)exception);
        }
        AtomicResultsMessage emptyResults = new AtomicResultsMessage(new List[0], null);
        emptyResults.setWarnings(Arrays.asList(new Exception[]{exception}));
        emptyResults.setFinalRow(this.rowsProcessed);
        this.receiveResults(emptyResults);
    }

    void receiveResults(AtomicResultsMessage response) {
        this.arm = response;
        this.rowsProcessed += response.getResults().length;
        this.index = 0;
        if (response.getWarnings() != null) {
            for (Exception warning : response.getWarnings()) {
                SourceWarning sourceFailure = new SourceWarning(this.aqr.getModelName(), this.aqr.getConnectorName(), (Throwable)warning, true);
                this.workItem.addSourceFailureDetails(sourceFailure);
            }
        }
        if (response.getFinalRow() >= 0) {
            this.done = true;
        }
    }

    public AtomicRequestMessage getAtomicRequestMessage() {
        return this.aqr;
    }

    public String getConnectorName() {
        return this.aqr.getConnectorName();
    }

    public boolean isTransactional() {
        return this.aqr.isTransactional();
    }
}

