/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.cache.Cachable;
import org.teiid.cache.Cache;
import org.teiid.cache.CacheConfiguration;
import org.teiid.cache.CacheFactory;
import org.teiid.cache.DefaultCache;
import org.teiid.cache.DefaultCacheFactory;
import org.teiid.common.buffer.BufferManager;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.query.parser.ParseInfo;
import org.teiid.vdb.runtime.VDBKey;

public class SessionAwareCache<T> {
    public static final int DEFAULT_MAX_SIZE_TOTAL = 250;
    private Cache<CacheID, T> localCache;
    private Cache<CacheID, T> distributedCache;
    private int maxSize = 250;
    private AtomicInteger cacheHit = new AtomicInteger();
    private BufferManager bufferManager;

    SessionAwareCache() {
        this(new DefaultCacheFactory(), Cache.Type.RESULTSET, new CacheConfiguration(CacheConfiguration.Policy.LRU, 60, 250));
    }

    SessionAwareCache(int maxSize) {
        this(new DefaultCacheFactory(), Cache.Type.RESULTSET, new CacheConfiguration(CacheConfiguration.Policy.LRU, 60, maxSize));
    }

    SessionAwareCache(CacheFactory cacheFactory, Cache.Type type, CacheConfiguration config) {
        this.maxSize = config.getMaxEntries();
        if (this.maxSize < 0) {
            this.maxSize = 250;
        }
        this.localCache = new DefaultCache<CacheID, T>("local", this.maxSize, config.getMaxAgeInSeconds() * 1000);
        this.distributedCache = type == Cache.Type.PREPAREDPLAN ? this.localCache : cacheFactory.get(type, config);
    }

    public T get(CacheID id) {
        id.setSessionId(id.originalSessionId);
        T result = this.localCache.get(id);
        if (result == null) {
            Cachable c;
            id.setSessionId(null);
            id.setUserName(id.originalUserName);
            result = this.distributedCache.get(id);
            if (result == null) {
                id.setUserName(null);
                result = this.distributedCache.get(id);
            }
            if (result != null && result instanceof Cachable && !(c = (Cachable)result).restore(this.distributedCache, this.bufferManager)) {
                result = null;
            }
        }
        if (result != null) {
            this.cacheHit.getAndIncrement();
        }
        return result;
    }

    public int getCacheHitCount() {
        return this.cacheHit.get();
    }

    public void put(CacheID id, int determinismLevel, T t) {
        this.put(id, determinismLevel, t, null);
    }

    public void put(CacheID id, int determinismLevel, T t, Long ttl) {
        if (!id.cachable) {
            return;
        }
        if (determinismLevel >= 3) {
            id.setSessionId(id.originalSessionId);
            this.localCache.put(id, t, ttl);
        } else {
            boolean insert = true;
            id.setSessionId(null);
            if (determinismLevel == 2) {
                id.setUserName(id.originalUserName);
            } else {
                id.setUserName(null);
            }
            if (t instanceof Cachable) {
                Cachable c = (Cachable)t;
                insert = c.prepare(this.distributedCache, this.bufferManager);
            }
            if (insert) {
                this.distributedCache.put(id, t, ttl);
            }
        }
    }

    public void clearAll() {
        this.localCache.clear();
        this.distributedCache.clear();
    }

    int getSpaceUsed() {
        return this.localCache.size();
    }

    int getSpaceAllowed() {
        return this.maxSize;
    }

    public void setBufferManager(BufferManager bufferManager) {
        this.bufferManager = bufferManager;
    }

    static class CacheID
    implements Serializable {
        private static final long serialVersionUID = 8261905111156764744L;
        private String sql;
        private VDBKey vdbInfo;
        private ParseInfo pi;
        private String sessionId;
        private String originalSessionId;
        private List<Serializable> parameters;
        private String userName;
        private String originalUserName;
        private boolean cachable = true;

        CacheID(DQPWorkContext context, ParseInfo pi, String sql) {
            this.sql = sql;
            this.vdbInfo = new VDBKey(context.getVdbName(), context.getVdbVersion());
            this.pi = pi;
            this.originalSessionId = context.getSessionId();
            this.originalUserName = context.getUserName();
        }

        private void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        public void setParameters(List<?> parameters) {
            if (parameters != null && !parameters.isEmpty()) {
                this.parameters = new ArrayList<Serializable>();
                for (Object obj : parameters) {
                    if (obj instanceof Serializable) {
                        this.parameters.add((Serializable)obj);
                        continue;
                    }
                    this.cachable = false;
                }
            }
        }

        public String getSql() {
            return this.sql;
        }

        public void setUserName(String name) {
            this.userName = name;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof CacheID)) {
                return false;
            }
            CacheID that = (CacheID)obj;
            return this.pi.equals(that.pi) && this.vdbInfo.equals(that.vdbInfo) && this.sql.equals(that.sql) && EquivalenceUtil.areEqual((Object)this.userName, (Object)that.userName) && EquivalenceUtil.areEqual((Object)this.sessionId, (Object)that.sessionId) && EquivalenceUtil.areEqual(this.parameters, that.parameters);
        }

        public int hashCode() {
            return HashCodeUtil.hashCode((int)0, (Object[])new Object[]{this.vdbInfo, this.sql, this.pi, this.userName, this.sessionId, this.parameters});
        }

        public String toString() {
            return "Cache Entry<" + this.originalSessionId + "=" + this.originalUserName + "> params:" + this.parameters + " sql:" + this.sql;
        }
    }
}

