/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.util.Collection;
import java.util.Collections;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionLibrary;
import org.teiid.query.function.FunctionMetadataSource;
import org.teiid.query.function.FunctionTree;
import org.teiid.query.function.UDFSource;
import org.teiid.query.function.metadata.FunctionMetadataValidator;
import org.teiid.query.function.metadata.FunctionMethod;
import org.teiid.query.function.source.SystemSource;
import org.teiid.query.report.ActivityReport;

public class SystemFunctionManager {
    private static FunctionTree systemFunctionTree;

    public static FunctionTree getSystemFunctions() {
        return systemFunctionTree;
    }

    public static FunctionLibrary getSystemFunctionLibrary() {
        return new FunctionLibrary(systemFunctionTree, new FunctionTree(new UDFSource(Collections.EMPTY_LIST)));
    }

    private static void validateSource(FunctionMetadataSource source, ActivityReport report) {
        Collection<FunctionMethod> functionMethods = source.getFunctionMethods();
        FunctionMetadataValidator.validateFunctionMethods(functionMethods, report);
    }

    static {
        SystemSource systemSource = new SystemSource();
        ActivityReport report = new ActivityReport("Function Validation");
        SystemFunctionManager.validateSource(systemSource, report);
        if (report.hasItems()) {
            System.err.println(QueryPlugin.Util.getString("ERR.015.001.0005", new Object[]{report}));
        }
        systemFunctionTree = new FunctionTree(systemSource);
    }
}

