/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.teiid.query.sql.symbol.ElementSymbol;

public class GroupInfo
implements Serializable {
    private static final long serialVersionUID = 5724520038004637086L;
    public static final String CACHE_PREFIX = "groupinfo/";
    private Map<Object, ElementSymbol> idToSymbolMap;
    private List<ElementSymbol> symbolList;
    private Map<String, ElementSymbol> shortNameToSymbolMap;

    public GroupInfo(LinkedHashMap<Object, ElementSymbol> symbols) {
        this.idToSymbolMap = symbols;
        this.symbolList = Collections.unmodifiableList(new ArrayList<ElementSymbol>(symbols.values()));
        this.shortNameToSymbolMap = new HashMap<String, ElementSymbol>(this.symbolList.size());
        for (ElementSymbol symbol : this.symbolList) {
            this.shortNameToSymbolMap.put(symbol.getShortCanonicalName(), symbol);
        }
    }

    public List<ElementSymbol> getSymbolList() {
        return this.symbolList;
    }

    public ElementSymbol getSymbol(Object metadataID) {
        return this.idToSymbolMap.get(metadataID);
    }

    public ElementSymbol getSymbol(String shortCanonicalName) {
        return this.shortNameToSymbolMap.get(shortCanonicalName);
    }
}

