/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.teiid.core.util.LRUCache;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.sql.lang.CacheHint;

public class TempMetadataID
implements Serializable {
    private static final int LOCAL_CACHE_SIZE = 8;
    private String ID;
    private Type metadataType = Type.VIRTUAL;
    private Collection<TempMetadataID> accessPatterns;
    private List<TempMetadataID> elements;
    private int cardinality = 0;
    private List<TempMetadataID> primaryKey;
    private QueryNode queryNode;
    private transient LRUCache<Object, Object> localCache;
    private CacheHint cacheHint;
    private Object originalMetadataID;
    private int position;
    private Class<?> type;

    public TempMetadataID(String ID, List<TempMetadataID> elements) {
        this(ID, elements, Type.VIRTUAL);
    }

    public TempMetadataID(String ID, List<TempMetadataID> elements, Type type) {
        this.ID = ID;
        this.elements = elements;
        int pos = 1;
        for (TempMetadataID tempMetadataID : elements) {
            tempMetadataID.setPosition(pos++);
        }
        this.metadataType = type;
    }

    public TempMetadataID(String ID, Class<?> type) {
        this.ID = ID;
        this.type = type;
    }

    public TempMetadataID(String ID, Class<?> type, Object metadataID) {
        this.ID = ID;
        this.type = type;
        this.originalMetadataID = metadataID;
    }

    public String getID() {
        return this.ID;
    }

    public Class<?> getType() {
        return this.type;
    }

    public List<TempMetadataID> getElements() {
        return this.elements;
    }

    protected void addElement(TempMetadataID elem) {
        if (this.elements != null) {
            this.elements.add(elem);
            elem.setPosition(this.elements.size());
        }
        if (this.localCache != null) {
            this.localCache.clear();
        }
    }

    public boolean isVirtual() {
        return this.metadataType == Type.VIRTUAL;
    }

    public boolean isTempTable() {
        return this.metadataType == Type.TEMP;
    }

    public String toString() {
        return this.ID;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TempMetadataID)) {
            return false;
        }
        return this.getID().equals(((TempMetadataID)obj).getID());
    }

    public int hashCode() {
        return this.ID.hashCode();
    }

    public void setOriginalMetadataID(Object metadataId) {
        this.originalMetadataID = metadataId;
    }

    public Object getOriginalMetadataID() {
        return this.originalMetadataID;
    }

    public Collection<TempMetadataID> getAccessPatterns() {
        if (this.accessPatterns == null) {
            return Collections.emptyList();
        }
        return this.accessPatterns;
    }

    public void setAccessPatterns(Collection<TempMetadataID> accessPatterns) {
        this.accessPatterns = accessPatterns;
    }

    public int getCardinality() {
        return this.cardinality;
    }

    public void setCardinality(int cardinality) {
        this.cardinality = cardinality;
    }

    public void setTempTable(boolean isTempTable) {
        this.metadataType = isTempTable ? Type.TEMP : Type.VIRTUAL;
    }

    Object getProperty(Object key) {
        if (this.localCache != null) {
            return this.localCache.get(key);
        }
        return null;
    }

    Object setProperty(Object key, Object value) {
        if (this.localCache == null) {
            this.localCache = new LRUCache(8);
        }
        return this.localCache.put(key, value);
    }

    public boolean isScalarGroup() {
        return this.metadataType == Type.SCALAR;
    }

    public void setScalarGroup() {
        this.metadataType = Type.SCALAR;
    }

    public List<TempMetadataID> getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(List<TempMetadataID> primaryKey) {
        this.primaryKey = primaryKey;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public QueryNode getQueryNode() {
        return this.queryNode;
    }

    public void setQueryNode(QueryNode queryNode) {
        this.queryNode = queryNode;
    }

    public CacheHint getCacheHint() {
        return this.cacheHint;
    }

    public void setCacheHint(CacheHint cacheHint) {
        this.cacheHint = cacheHint;
    }

    public static enum Type {
        VIRTUAL,
        TEMP,
        SCALAR;

    }
}

