/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.plantree;

import java.util.LinkedList;
import java.util.List;
import org.teiid.query.optimizer.relational.plantree.PlanNode;

public final class NodeEditor {
    private NodeEditor() {
    }

    public static final void removeChildNode(PlanNode parent, PlanNode child) {
        if (child.getChildCount() == 0) {
            parent.removeChild(child);
        } else if (child.getChildCount() == 1) {
            PlanNode grandChild = child.getFirstChild();
            parent.replaceChild(child, grandChild);
        } else {
            throw new AssertionError((Object)"Cannot promote a multinode child");
        }
    }

    public static final PlanNode findNodePreOrder(PlanNode root, int types) {
        return NodeEditor.findNodePreOrder(root, types, 0);
    }

    public static final PlanNode findNodePreOrder(PlanNode root, int types, int stopTypes) {
        if ((types & root.getType()) == root.getType()) {
            return root;
        }
        if ((stopTypes & root.getType()) == root.getType()) {
            return null;
        }
        if (root.getChildCount() > 0) {
            for (PlanNode child : root.getChildren()) {
                PlanNode found = NodeEditor.findNodePreOrder(child, types, stopTypes);
                if (found == null) continue;
                return found;
            }
        }
        return null;
    }

    public static final PlanNode findParent(PlanNode root, int types) {
        return NodeEditor.findParent(root, types, 0);
    }

    public static final PlanNode findParent(PlanNode root, int types, int stopTypes) {
        while (root != null && root.getParent() != null) {
            if ((types & (root = root.getParent()).getType()) == root.getType()) {
                return root;
            }
            if ((stopTypes & root.getType()) != root.getType()) continue;
            return null;
        }
        return null;
    }

    public static final List<PlanNode> findAllNodes(PlanNode root, int types) {
        LinkedList<PlanNode> nodes = new LinkedList<PlanNode>();
        NodeEditor.findAllNodesHelper(root, types, nodes, 0);
        return nodes;
    }

    public static final List<PlanNode> findAllNodes(PlanNode root, int types, int stopTypes) {
        LinkedList<PlanNode> nodes = new LinkedList<PlanNode>();
        NodeEditor.findAllNodesHelper(root, types, nodes, stopTypes);
        return nodes;
    }

    private static final void findAllNodesHelper(PlanNode node, int types, List<PlanNode> foundNodes, int stopTypes) {
        if ((node.getType() & types) == node.getType()) {
            foundNodes.add(node);
        }
        if (node.getChildCount() > 0 && (stopTypes == 0 || (stopTypes & node.getType()) != node.getType())) {
            for (PlanNode child : node.getChildren()) {
                NodeEditor.findAllNodesHelper(child, types, foundNodes, stopTypes);
            }
        }
    }
}

