/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.AbstractSetCriteria;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.PredicateCriteria;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.util.CommandContext;

public class NewCalculateCostUtil {
    public static final float UNKNOWN_VALUE = -1.0f;
    private static final float compareTime = 0.05f;
    private static final float readTime = 0.001f;
    private static final float procNewRequestTime = 100.0f;
    private static final float procMoreRequestTime = 15.0f;

    static float computeCostForTree(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        Float cost = (Float)node.getProperty(NodeConstants.Info.EST_CARDINALITY);
        if (cost == null) {
            for (PlanNode child : node.getChildren()) {
                NewCalculateCostUtil.computeCostForTree(child, metadata);
            }
            NewCalculateCostUtil.computeNodeCost(node, metadata);
            cost = (Float)node.getProperty(NodeConstants.Info.EST_CARDINALITY);
        }
        if (cost != null) {
            return cost.floatValue();
        }
        return -1.0f;
    }

    private static void computeNodeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        switch (node.getType()) {
            case 128: {
                NewCalculateCostUtil.estimateSourceNodeCost(node, metadata);
                break;
            }
            case 32: {
                NewCalculateCostUtil.estimateSelectNodeCost(node, metadata);
                break;
            }
            case 8: {
                NewCalculateCostUtil.estimateJoinNodeCost(node, metadata);
                break;
            }
            case 4: {
                NewCalculateCostUtil.estimateNodeCost(node, FrameUtil.findTopCols(node), metadata);
                break;
            }
            case 256: {
                if (!node.hasCollectionProperty(NodeConstants.Info.GROUP_COLS)) {
                    NewCalculateCostUtil.setCardinalityEstimate(node, Float.valueOf(1.0f));
                    break;
                }
                NewCalculateCostUtil.estimateNodeCost(node, (List)node.getProperty(NodeConstants.Info.GROUP_COLS), metadata);
                break;
            }
            case 2: 
            case 64: {
                PlanNode child = node.getFirstChild();
                Float childCost = (Float)child.getProperty(NodeConstants.Info.EST_CARDINALITY);
                NewCalculateCostUtil.setCardinalityEstimate(node, childCost);
                break;
            }
            case 1024: {
                NewCalculateCostUtil.setCardinalityEstimate(node, Float.valueOf(0.0f));
                break;
            }
            case 16: {
                Float childCost = null;
                if (node.getChildCount() != 0) {
                    PlanNode child = node.getFirstChild();
                    childCost = (Float)child.getProperty(NodeConstants.Info.EST_CARDINALITY);
                } else {
                    childCost = Float.valueOf(1.0f);
                }
                NewCalculateCostUtil.setCardinalityEstimate(node, childCost);
                break;
            }
            case 512: {
                NewCalculateCostUtil.estimateSetOpCost(node, metadata);
                break;
            }
            case 2048: {
                Expression limit;
                PlanNode child = node.getFirstChild();
                Float childCost = (Float)child.getProperty(NodeConstants.Info.EST_CARDINALITY);
                Expression offset = (Expression)node.getProperty(NodeConstants.Info.OFFSET_TUPLE_COUNT);
                Float cost = childCost;
                if (childCost.floatValue() != -1.0f && offset instanceof Constant) {
                    float offsetCost = childCost.floatValue() - ((Number)((Constant)offset).getValue()).floatValue();
                    cost = new Float(offsetCost < 0.0f ? 0.0f : offsetCost);
                }
                if ((limit = (Expression)node.getProperty(NodeConstants.Info.MAX_TUPLE_LIMIT)) instanceof Constant) {
                    float limitCost = ((Number)((Constant)limit).getValue()).floatValue();
                    cost = cost.floatValue() != -1.0f ? new Float(Math.min(limitCost, cost.floatValue())) : new Float(limitCost);
                }
                NewCalculateCostUtil.setCardinalityEstimate(node, cost);
                break;
            }
        }
    }

    private static void estimateSetOpCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        float cost = 0.0f;
        SetQuery.Operation op = (SetQuery.Operation)((Object)node.getProperty(NodeConstants.Info.SET_OPERATION));
        float leftCost = ((Float)node.getFirstChild().getProperty(NodeConstants.Info.EST_CARDINALITY)).floatValue();
        float rightCost = ((Float)node.getLastChild().getProperty(NodeConstants.Info.EST_CARDINALITY)).floatValue();
        if (!node.hasBooleanProperty(NodeConstants.Info.USE_ALL)) {
            leftCost = NewCalculateCostUtil.getDistinctEstimate(node.getFirstChild(), metadata, leftCost);
            rightCost = NewCalculateCostUtil.getDistinctEstimate(node.getLastChild(), metadata, rightCost);
        }
        cost = leftCost;
        switch (op) {
            case EXCEPT: {
                if (leftCost == -1.0f || rightCost == -1.0f) break;
                cost = Math.max(1.0f, leftCost - 0.5f * rightCost);
                break;
            }
            case INTERSECT: {
                if (rightCost == -1.0f) break;
                if (leftCost != -1.0f) {
                    cost = 0.5f * Math.min(leftCost, rightCost);
                    break;
                }
                cost = rightCost;
                break;
            }
            default: {
                if (leftCost == -1.0f || rightCost == -1.0f) break;
                cost = !node.hasBooleanProperty(NodeConstants.Info.USE_ALL) ? Math.max(leftCost, rightCost) + 0.5f * Math.min(leftCost, rightCost) : rightCost + leftCost;
            }
        }
        NewCalculateCostUtil.setCardinalityEstimate(node, new Float(cost));
    }

    private static float getDistinctEstimate(PlanNode node, QueryMetadataInterface metadata, float cost) throws QueryMetadataException, TeiidComponentException {
        PlanNode projectNode = NodeEditor.findNodePreOrder(node, 16);
        if (projectNode != null) {
            cost = NewCalculateCostUtil.getDistinctEstimate(projectNode, (List)projectNode.getProperty(NodeConstants.Info.PROJECT_COLS), metadata, cost).floatValue();
        }
        return cost;
    }

    private static void setCardinalityEstimate(PlanNode node, Float bestEstimate) {
        if (bestEstimate == null) {
            bestEstimate = Float.valueOf(-1.0f);
        }
        node.setProperty(NodeConstants.Info.EST_CARDINALITY, bestEstimate);
    }

    private static void estimateJoinNodeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        Iterator<PlanNode> children = node.getChildren().iterator();
        PlanNode child1 = children.next();
        Float childCost1 = (Float)child1.getProperty(NodeConstants.Info.EST_CARDINALITY);
        PlanNode child2 = children.next();
        Float childCost2 = (Float)child2.getProperty(NodeConstants.Info.EST_CARDINALITY);
        if (childCost1 != null && childCost2 != null && childCost1.floatValue() != -1.0f && childCost2.floatValue() != -1.0f) {
            JoinType joinType = (JoinType)node.getProperty(NodeConstants.Info.JOIN_TYPE);
            List joinCriteria = (List)node.getProperty(NodeConstants.Info.JOIN_CRITERIA);
            float baseCost = childCost1.floatValue() * childCost2.floatValue();
            if (joinCriteria != null && !joinCriteria.isEmpty()) {
                Criteria crit = Criteria.combineCriteria(joinCriteria);
                baseCost = NewCalculateCostUtil.recursiveEstimateCostOfCriteria(baseCost, node, crit, metadata);
            }
            Float cost = null;
            if (JoinType.JOIN_CROSS.equals(joinType)) {
                cost = new Float(baseCost);
            } else if (JoinType.JOIN_FULL_OUTER.equals(joinType)) {
                cost = new Float(Math.max(childCost1.floatValue() + childCost2.floatValue(), baseCost));
            } else if (JoinType.JOIN_LEFT_OUTER.equals(joinType)) {
                cost = new Float(Math.max(childCost1.floatValue(), baseCost));
            } else if (JoinType.JOIN_RIGHT_OUTER.equals(joinType)) {
                cost = new Float(Math.max(childCost2.floatValue(), baseCost));
            } else if (JoinType.JOIN_INNER.equals(joinType)) {
                cost = new Float(baseCost);
            }
            NewCalculateCostUtil.setCardinalityEstimate(node, cost);
        } else {
            NewCalculateCostUtil.setCardinalityEstimate(node, null);
        }
    }

    private static void estimateSelectNodeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        PlanNode child = node.getFirstChild();
        Float childCostFloat = (Float)child.getProperty(NodeConstants.Info.EST_CARDINALITY);
        float childCost = -1.0f;
        if (childCostFloat != null) {
            childCost = childCostFloat.floatValue();
        }
        Criteria selectCriteria = (Criteria)node.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        float newCost = NewCalculateCostUtil.recursiveEstimateCostOfCriteria(childCost, node, selectCriteria, metadata);
        NewCalculateCostUtil.setCardinalityEstimate(node, new Float(newCost));
    }

    private static void estimateSourceNodeCost(PlanNode node, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        float cost = -1.0f;
        if (node.getChildCount() > 0) {
            PlanNode child;
            Float childCostFloat;
            SymbolMap references = (SymbolMap)node.getProperty(NodeConstants.Info.CORRELATED_REFERENCES);
            if (references == null && (childCostFloat = (Float)(child = node.getFirstChild()).getProperty(NodeConstants.Info.EST_CARDINALITY)) != null) {
                cost = childCostFloat.floatValue();
            }
        } else {
            GroupSymbol group = node.getGroups().iterator().next();
            float cardinality = metadata.getCardinality(group.getMetadataID());
            if (cardinality <= 0.0f) {
                cardinality = -1.0f;
            }
            cost = cardinality;
        }
        NewCalculateCostUtil.setCardinalityEstimate(node, new Float(cost));
    }

    private static void estimateNodeCost(PlanNode node, List expressions, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        PlanNode child = node.getFirstChild();
        float childCost = ((Float)child.getProperty(NodeConstants.Info.EST_CARDINALITY)).floatValue();
        if (childCost == -1.0f) {
            NewCalculateCostUtil.setCardinalityEstimate(node, null);
            return;
        }
        Float newCost = NewCalculateCostUtil.getDistinctEstimate(node, expressions, metadata, childCost);
        NewCalculateCostUtil.setCardinalityEstimate(node, newCost);
    }

    private static Float getDistinctEstimate(PlanNode node, List elements, QueryMetadataInterface metadata, float childCost) throws QueryMetadataException, TeiidComponentException {
        if (elements == null) {
            return new Float(childCost);
        }
        HashSet<ElementSymbol> elems = new HashSet<ElementSymbol>();
        ElementCollectorVisitor.getElements(elements, elems);
        if (NewCalculateCostUtil.usesKey(elements, metadata)) {
            return new Float(childCost);
        }
        float ndvCost = NewCalculateCostUtil.getNDV(elems, node, childCost, metadata);
        if (ndvCost == -1.0f) {
            ndvCost = childCost;
        }
        Float newCost = new Float(Math.min(childCost, ndvCost));
        return newCost;
    }

    static float recursiveEstimateCostOfCriteria(float childCost, PlanNode currentNode, Criteria crit, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        float cost = childCost;
        if (crit instanceof CompoundCriteria) {
            CompoundCriteria compCrit = (CompoundCriteria)crit;
            if (compCrit.getOperator() == 1) {
                cost = 0.0f;
            }
            HashSet<ElementSymbol> elements = new HashSet<ElementSymbol>();
            NewCalculateCostUtil.collectElementsOfValidCriteria(compCrit, elements);
            if (NewCalculateCostUtil.usesKey(elements, metadata)) {
                return 1.0f;
            }
            for (Criteria critPart : compCrit.getCriteria()) {
                float nextCost = NewCalculateCostUtil.recursiveEstimateCostOfCriteria(childCost, currentNode, critPart, metadata);
                if (compCrit.getOperator() == 0) {
                    if (nextCost == -1.0f) continue;
                    cost = childCost != -1.0f ? (cost *= nextCost / childCost) : (cost == -1.0f ? nextCost : Math.min(cost, nextCost));
                    if (!(cost <= 1.0f)) continue;
                    return 1.0f;
                }
                if (nextCost == -1.0f) {
                    return childCost;
                }
                cost += nextCost;
                if (childCost == -1.0f) continue;
                cost = Math.min(cost, childCost);
            }
            if (cost == -1.0f) {
                return childCost;
            }
        } else if (crit instanceof NotCriteria) {
            if (childCost == -1.0f) {
                return -1.0f;
            }
            float nextCost = NewCalculateCostUtil.recursiveEstimateCostOfCriteria(childCost, currentNode, ((NotCriteria)crit).getCriteria(), metadata);
            if (nextCost == -1.0f) {
                return childCost;
            }
            cost -= nextCost;
        } else {
            cost = NewCalculateCostUtil.estimatePredicateCost(childCost, currentNode, (PredicateCriteria)crit, metadata);
            if (cost == -1.0f) {
                return childCost;
            }
        }
        cost = Math.max(cost, 1.0f);
        return cost;
    }

    private static void collectElementsOfValidCriteria(Criteria criteria, Collection<ElementSymbol> elements) {
        IsNullCriteria isNullCriteria;
        if (criteria instanceof CompoundCriteria) {
            CompoundCriteria compCrit = (CompoundCriteria)criteria;
            Iterator<Criteria> iter = compCrit.getCriteria().iterator();
            boolean first = true;
            Collection<ElementSymbol> savedElements = elements;
            if (compCrit.getOperator() == 1) {
                elements = new HashSet<ElementSymbol>();
            }
            while (iter.hasNext()) {
                if (compCrit.getOperator() == 0 || first) {
                    NewCalculateCostUtil.collectElementsOfValidCriteria(iter.next(), elements);
                    first = false;
                    continue;
                }
                HashSet<ElementSymbol> other = new HashSet<ElementSymbol>();
                NewCalculateCostUtil.collectElementsOfValidCriteria(iter.next(), other);
                elements.retainAll(other);
            }
            if (compCrit.getOperator() == 1) {
                savedElements.addAll(elements);
            }
        } else if (criteria instanceof CompareCriteria) {
            CompareCriteria compCrit = (CompareCriteria)criteria;
            if (compCrit.getOperator() == 1) {
                ElementCollectorVisitor.getElements((LanguageObject)compCrit, elements);
            }
        } else if (criteria instanceof MatchCriteria) {
            MatchCriteria matchCriteria = (MatchCriteria)criteria;
            if (!matchCriteria.isNegated()) {
                ElementCollectorVisitor.getElements((LanguageObject)matchCriteria, elements);
            }
        } else if (criteria instanceof AbstractSetCriteria) {
            AbstractSetCriteria setCriteria = (AbstractSetCriteria)criteria;
            if (!setCriteria.isNegated()) {
                ElementCollectorVisitor.getElements((LanguageObject)setCriteria.getExpression(), elements);
            }
        } else if (criteria instanceof IsNullCriteria && !(isNullCriteria = (IsNullCriteria)criteria).isNegated()) {
            ElementCollectorVisitor.getElements((LanguageObject)isNullCriteria.getExpression(), elements);
        }
    }

    private static float estimatePredicateCost(float childCost, PlanNode currentNode, PredicateCriteria predicateCriteria, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        Collection<ElementSymbol> elements = ElementCollectorVisitor.getElements((LanguageObject)predicateCriteria, true);
        Set<GroupSymbol> groups = GroupsUsedByElementsVisitor.getGroups(elements);
        boolean multiGroup = groups.size() > 1;
        float cost = childCost;
        float ndv = NewCalculateCostUtil.getNDV(elements, currentNode, childCost, metadata);
        boolean unknownChildCost = childCost == -1.0f;
        boolean usesKey = NewCalculateCostUtil.usesKey(elements, metadata);
        if (childCost == -1.0f) {
            childCost = 1.0f;
        }
        if (ndv == -1.0f) {
            ndv = 3.0f;
            if (multiGroup) {
                ndv = usesKey ? (float)Math.ceil(Math.sqrt(childCost)) : (float)Math.ceil(Math.sqrt(childCost) / 4.0);
                ndv = Math.max(ndv, 1.0f);
            } else if (usesKey) {
                ndv = childCost;
            }
        }
        boolean isNegatedPredicateCriteria = false;
        if (predicateCriteria instanceof CompareCriteria) {
            CompareCriteria compCrit = (CompareCriteria)predicateCriteria;
            if (compCrit.getOperator() == 1 || compCrit.getOperator() == 2) {
                if (unknownChildCost && (!usesKey || multiGroup)) {
                    return -1.0f;
                }
                cost = childCost / ndv;
                if (compCrit.getOperator() == 2) {
                    isNegatedPredicateCriteria = true;
                }
            } else {
                cost = NewCalculateCostUtil.getCostForComparison(childCost, metadata, compCrit, unknownChildCost);
            }
        } else if (predicateCriteria instanceof MatchCriteria) {
            MatchCriteria matchCriteria = (MatchCriteria)predicateCriteria;
            if (unknownChildCost) {
                return -1.0f;
            }
            cost = NewCalculateCostUtil.estimateMatchCost(childCost, ndv, matchCriteria);
            isNegatedPredicateCriteria = matchCriteria.isNegated();
        } else if (predicateCriteria instanceof SetCriteria) {
            SetCriteria setCriteria = (SetCriteria)predicateCriteria;
            if (unknownChildCost) {
                return -1.0f;
            }
            cost = childCost * (float)setCriteria.getNumberOfValues() / ndv;
            isNegatedPredicateCriteria = setCriteria.isNegated();
        } else if (predicateCriteria instanceof SubquerySetCriteria) {
            SubquerySetCriteria setCriteria = (SubquerySetCriteria)predicateCriteria;
            if (unknownChildCost) {
                return -1.0f;
            }
            cost = childCost / 3.0f;
            isNegatedPredicateCriteria = setCriteria.isNegated();
        } else if (predicateCriteria instanceof IsNullCriteria) {
            IsNullCriteria isNullCriteria = (IsNullCriteria)predicateCriteria;
            float nnv = NewCalculateCostUtil.getNNV(elements, currentNode, childCost, metadata);
            if (nnv == -1.0f) {
                if (unknownChildCost) {
                    return -1.0f;
                }
                cost = childCost / ndv;
            } else {
                cost = nnv;
            }
            isNegatedPredicateCriteria = isNullCriteria.isNegated();
        }
        if (cost == -1.0f) {
            return -1.0f;
        }
        if (cost > childCost) {
            cost = childCost;
        }
        if (isNegatedPredicateCriteria) {
            cost = cost != -1.0f ? Math.max(childCost - cost, 1.0f) : -1.0f;
        }
        return cost;
    }

    private static float estimateMatchCost(float childCost, float ndv, MatchCriteria criteria) {
        Expression matchExpression = criteria.getRightExpression();
        if (matchExpression instanceof Constant && ((Constant)matchExpression).getType().equals(DataTypeManager.DefaultDataClasses.STRING)) {
            String compareValue = (String)((Constant)matchExpression).getValue();
            if (compareValue != null && compareValue.indexOf(37) < 0) {
                return childCost / 2.0f * (0.33333334f + 1.0f / ndv);
            }
        } else if (EvaluatableVisitor.willBecomeConstant(criteria.getLeftExpression())) {
            return childCost / ndv;
        }
        return childCost / 3.0f;
    }

    private static float getCostForComparison(float childCost, QueryMetadataInterface metadata, CompareCriteria compCrit, boolean unknownChildCost) throws TeiidComponentException, QueryMetadataException {
        if (!(compCrit.getLeftExpression() instanceof ElementSymbol) || !(compCrit.getRightExpression() instanceof Constant)) {
            if (unknownChildCost) {
                return -1.0f;
            }
            return childCost / 3.0f;
        }
        ElementSymbol element = (ElementSymbol)compCrit.getLeftExpression();
        Class dataType = compCrit.getRightExpression().getType();
        String max = (String)metadata.getMaximumValue(element.getMetadataID());
        String min = (String)metadata.getMinimumValue(element.getMetadataID());
        if (max == null || min == null) {
            if (unknownChildCost) {
                return -1.0f;
            }
            return childCost / 3.0f;
        }
        float cost = childCost;
        try {
            float maxValue = 0.0f;
            float minValue = 0.0f;
            Constant value = (Constant)compCrit.getRightExpression();
            float compareValue = 0.0f;
            if (dataType.equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
                compareValue = ((Timestamp)value.getValue()).getTime();
                maxValue = Timestamp.valueOf(max).getTime();
                minValue = Timestamp.valueOf(min).getTime();
            } else if (dataType.equals(DataTypeManager.DefaultDataClasses.TIME)) {
                compareValue = ((Time)value.getValue()).getTime();
                maxValue = Time.valueOf(max).getTime();
                minValue = Time.valueOf(min).getTime();
            } else if (dataType.equals(DataTypeManager.DefaultDataClasses.DATE)) {
                compareValue = ((Date)value.getValue()).getTime();
                maxValue = Timestamp.valueOf(max).getTime();
                minValue = Timestamp.valueOf(min).getTime();
            } else {
                if (!Number.class.isAssignableFrom(dataType)) {
                    if (unknownChildCost) {
                        return -1.0f;
                    }
                    return childCost / 3.0f;
                }
                compareValue = ((Number)value.getValue()).floatValue();
                maxValue = Integer.parseInt(max);
                minValue = Integer.parseInt(min);
            }
            float range = Math.max(maxValue - minValue, 1.0f);
            float costMultiple = 1.0f;
            if (compCrit.getOperator() == 4 || compCrit.getOperator() == 6) {
                costMultiple = (maxValue - compareValue) / range;
                if (compareValue < 0.0f && maxValue < 0.0f) {
                    costMultiple = 1.0f - costMultiple;
                }
            } else if (compCrit.getOperator() == 3 || compCrit.getOperator() == 5) {
                costMultiple = (compareValue - minValue) / range;
                if (compareValue < 0.0f && minValue < 0.0f) {
                    costMultiple = 1.0f - costMultiple;
                }
            }
            if (costMultiple > 1.0f) {
                costMultiple = 1.0f;
            } else if (costMultiple < 0.0f) {
                costMultiple = 0.0f;
            }
            cost = childCost * costMultiple;
        }
        catch (IllegalArgumentException e) {
            LogManager.logWarning((String)"org.teiid.PLANNER", (Throwable)e, (String)QueryPlugin.Util.getString("NewCalculateCostUtil.badCost"));
            if (unknownChildCost) {
                return -1.0f;
            }
            cost = childCost / 3.0f;
        }
        return cost;
    }

    static boolean usesKey(PlanNode planNode, Collection<? extends SingleElementSymbol> allElements, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        return NodeEditor.findAllNodes(planNode, 128, 520).size() == 1 && NewCalculateCostUtil.usesKey(allElements, metadata);
    }

    private static boolean usesKey(Collection<? extends SingleElementSymbol> allElements, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        if (allElements == null || allElements.size() == 0) {
            return false;
        }
        HashMap<GroupSymbol, ArrayList<Object>> groupMap = new HashMap<GroupSymbol, ArrayList<Object>>();
        for (SingleElementSymbol singleElementSymbol : allElements) {
            if (!(singleElementSymbol instanceof ElementSymbol)) continue;
            ElementSymbol element = (ElementSymbol)singleElementSymbol;
            GroupSymbol group = element.getGroupSymbol();
            ArrayList<Object> elements = (ArrayList<Object>)groupMap.get(group);
            if (elements == null) {
                elements = new ArrayList<Object>();
                groupMap.put(group, elements);
            }
            elements.add(element.getMetadataID());
        }
        for (Map.Entry entry : groupMap.entrySet()) {
            GroupSymbol group = (GroupSymbol)entry.getKey();
            List elements = (List)entry.getValue();
            Collection keys = metadata.getUniqueKeysInGroup(group.getMetadataID());
            if (keys == null || keys.size() <= 0) continue;
            Iterator keyIter = keys.iterator();
            while (keyIter.hasNext()) {
                List keyElements = metadata.getElementIDsInKey(keyIter.next());
                if (!elements.containsAll(keyElements)) continue;
                return true;
            }
        }
        return false;
    }

    private static float getNDV(Collection<ElementSymbol> elements, PlanNode current, float cardinality, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        float result = 1.0f;
        for (ElementSymbol elementSymbol : elements) {
            int groupCardinality;
            Object elemID = elementSymbol.getMetadataID();
            float ndv = metadata.getDistinctValues(elemID);
            if (ndv == -1.0f) {
                SymbolMap symbolMap;
                PlanNode sourceNode;
                if (metadata.isVirtualGroup(elementSymbol.getGroupSymbol().getMetadataID()) && !metadata.isProcedure(elementSymbol.getGroupSymbol().getMetadataID()) && (sourceNode = FrameUtil.findOriginatingNode(current, new HashSet<GroupSymbol>(Arrays.asList(elementSymbol.getGroupSymbol())))) != null && (symbolMap = (SymbolMap)sourceNode.getProperty(NodeConstants.Info.SYMBOL_MAP)) != null) {
                    Expression expr = symbolMap.getMappedExpression(elementSymbol);
                    ndv = NewCalculateCostUtil.getNDV(ElementCollectorVisitor.getElements((LanguageObject)expr, true), sourceNode.getFirstChild(), cardinality, metadata);
                }
                if (ndv == -1.0f) {
                    return -1.0f;
                }
            } else if (cardinality != -1.0f && (float)(groupCardinality = metadata.getCardinality(elementSymbol.getGroupSymbol().getMetadataID())) != -1.0f) {
                ndv *= cardinality / (float)Math.max(1, groupCardinality);
            }
            result = Math.max(result, ndv);
        }
        return result;
    }

    private static float getNNV(Collection<ElementSymbol> elements, PlanNode current, float cardinality, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        float result = 0.0f;
        for (ElementSymbol elementSymbol : elements) {
            int groupCardinality;
            Object elemID = elementSymbol.getMetadataID();
            float nnv = metadata.getNullValues(elemID);
            if (nnv == -1.0f) {
                PlanNode sourceNode;
                if (!metadata.elementSupports(elemID, 4) && !metadata.elementSupports(elemID, 10)) {
                    nnv = 0.0f;
                } else if (metadata.isVirtualGroup(elementSymbol.getGroupSymbol().getMetadataID()) && !metadata.isProcedure(elementSymbol.getGroupSymbol().getMetadataID()) && (sourceNode = FrameUtil.findOriginatingNode(current, new HashSet<GroupSymbol>(Arrays.asList(elementSymbol.getGroupSymbol())))) != null) {
                    SymbolMap symbolMap = (SymbolMap)sourceNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
                    Expression expr = symbolMap.getMappedExpression(elementSymbol);
                    nnv = NewCalculateCostUtil.getNNV(ElementCollectorVisitor.getElements((LanguageObject)expr, true), sourceNode.getFirstChild(), cardinality, metadata);
                }
                if (nnv == -1.0f) {
                    return -1.0f;
                }
            } else if (cardinality != -1.0f && (float)(groupCardinality = metadata.getCardinality(elementSymbol.getGroupSymbol().getMetadataID())) != -1.0f) {
                nnv *= cardinality / (float)Math.max(1, groupCardinality);
            }
            result = Math.max(result, nnv);
        }
        return result;
    }

    public static float computeCostForJoin(PlanNode leftChildNode, PlanNode rightChildNode, JoinNode.JoinStrategyType joinStrategy, QueryMetadataInterface metadata, CommandContext context) throws TeiidComponentException, QueryMetadataException {
        float leftChildCardinality = NewCalculateCostUtil.computeCostForTree(leftChildNode, metadata);
        float rightChildCardinality = NewCalculateCostUtil.computeCostForTree(rightChildNode, metadata);
        boolean merge = JoinNode.JoinStrategyType.MERGE.equals((Object)joinStrategy);
        if (leftChildCardinality == -1.0f || rightChildCardinality == -1.0f) {
            return -1.0f;
        }
        float numberComparisons = merge ? leftChildCardinality + rightChildCardinality : leftChildCardinality * rightChildCardinality;
        float connectorBatchSize = 1024.0f;
        if (context != null) {
            connectorBatchSize = context.getConnectorBatchSize();
        }
        float totalReadTime = (leftChildCardinality + rightChildCardinality) * 0.001f;
        float totalCompareTime = numberComparisons * 0.05f;
        float totalProcMoreRequestLeftTime = (float)Math.floor(leftChildCardinality / connectorBatchSize) * 15.0f;
        float totalProcMoreRequestRightTime = (float)Math.floor(rightChildCardinality / connectorBatchSize) * 15.0f;
        float cost = totalReadTime + totalCompareTime + totalProcMoreRequestLeftTime + totalProcMoreRequestRightTime;
        if (merge) {
            cost += (leftChildCardinality * NewCalculateCostUtil.safeLog(leftChildCardinality) + rightChildCardinality * NewCalculateCostUtil.safeLog(rightChildCardinality)) * 0.001f;
        }
        if (NewCalculateCostUtil.isPhysicalSource(rightChildNode)) {
            cost += 100.0f;
        }
        if (NewCalculateCostUtil.isPhysicalSource(leftChildNode)) {
            cost += 100.0f;
        }
        return cost;
    }

    private static float safeLog(float x) {
        return (float)Math.max(1.0, Math.log(x));
    }

    public static float computeCostForDepJoin(PlanNode joinNode, boolean leftIndependent, JoinNode.JoinStrategyType joinStrategy, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, CommandContext context) throws TeiidComponentException, QueryMetadataException {
        PlanNode node;
        PlanNode independentNode = leftIndependent ? joinNode.getFirstChild() : joinNode.getLastChild();
        PlanNode dependentNode = leftIndependent ? joinNode.getLastChild() : joinNode.getFirstChild();
        List independentExpressions = (List)(leftIndependent ? joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS) : joinNode.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS));
        List dependentExpressions = (List)(leftIndependent ? joinNode.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS) : joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS));
        float independentCardinality = NewCalculateCostUtil.computeCostForTree(independentNode, metadata);
        float dependentCardinality = NewCalculateCostUtil.computeCostForTree(dependentNode, metadata);
        float indSymbolNDV = NewCalculateCostUtil.getNDV(independentNode, independentExpressions, metadata, independentCardinality, true);
        float depSymbolNDV = NewCalculateCostUtil.getNDV(dependentNode, dependentExpressions, metadata, dependentCardinality, false);
        if (indSymbolNDV == -1.0f || depSymbolNDV == -1.0f || independentCardinality == -1.0f || dependentCardinality == -1.0f) {
            return -1.0f;
        }
        float connectorBatchSize = 1024.0f;
        float processorBatchSize = 512.0f;
        if (context != null) {
            connectorBatchSize = context.getConnectorBatchSize();
            processorBatchSize = context.getProcessorBatchSize();
        }
        float setCriteriaBatchSize = indSymbolNDV;
        for (node = FrameUtil.findJoinSourceNode(dependentNode); node != null && node.getType() != 2; node = node.getFirstChild()) {
            if (node.getType() != 8 && node.getType() != 512) continue;
            node = null;
            break;
        }
        if (node != null) {
            setCriteriaBatchSize = CapabilitiesUtil.getMaxInCriteriaSize(RuleRaiseAccess.getModelIDFromAccess(node, metadata), metadata, capFinder);
            if (setCriteriaBatchSize < 1.0f) {
                setCriteriaBatchSize = indSymbolNDV;
            }
        } else if (indSymbolNDV > Math.min(processorBatchSize, setCriteriaBatchSize)) {
            return -1.0f;
        }
        independentNode.setProperty(NodeConstants.Info.EST_SET_SIZE, new Float(indSymbolNDV));
        float dependentAccessCardinality = Math.min(dependentCardinality, dependentCardinality * indSymbolNDV / depSymbolNDV);
        boolean merge = false;
        if (JoinNode.JoinStrategyType.MERGE.equals((Object)joinStrategy)) {
            merge = true;
        } else if (!JoinNode.JoinStrategyType.NESTED_LOOP.equals((Object)joinStrategy)) {
            return -1.0f;
        }
        dependentNode.setProperty(NodeConstants.Info.EST_DEP_CARDINALITY, new Float(dependentAccessCardinality));
        float numberComparisons = merge ? independentCardinality + dependentAccessCardinality : independentCardinality * dependentAccessCardinality;
        float totalLoadDataTime = independentCardinality * NewCalculateCostUtil.safeLog(independentCardinality) * 0.001f;
        if (merge) {
            totalLoadDataTime += dependentAccessCardinality * NewCalculateCostUtil.safeLog(dependentAccessCardinality) * 0.001f;
        }
        float totalReadTime = (2.0f * independentCardinality + dependentAccessCardinality) * 0.001f;
        float totalCompareTime = numberComparisons * 0.05f;
        float totalProcMoreRequestLeftTime = (float)Math.floor(independentCardinality / connectorBatchSize) * 15.0f;
        float newDependentQueries = (float)Math.ceil(indSymbolNDV / setCriteriaBatchSize);
        float totalProcMoreRequestRightTime = Math.max(dependentAccessCardinality / connectorBatchSize - newDependentQueries, 0.0f) * 15.0f;
        float cost = totalLoadDataTime + totalReadTime + totalCompareTime + totalProcMoreRequestLeftTime + totalProcMoreRequestRightTime;
        if (NewCalculateCostUtil.isPhysicalSource(independentNode)) {
            cost += 100.0f;
        }
        if (NewCalculateCostUtil.isPhysicalSource(dependentNode)) {
            cost += newDependentQueries * (100.0f * Math.max(NewCalculateCostUtil.safeLog(dependentCardinality) - 10.0f, 1.0f) * Math.max(NewCalculateCostUtil.safeLog(Math.min(dependentCardinality, Math.min(setCriteriaBatchSize, indSymbolNDV))) - 2.0f, 1.0f));
        }
        return cost;
    }

    private static boolean isPhysicalSource(PlanNode node) {
        if ((node = FrameUtil.findJoinSourceNode(node)) != null) {
            return node.getType() == 2;
        }
        return false;
    }

    private static float getNDV(PlanNode node, List expressions, QueryMetadataInterface metadata, float nodeCardinality, boolean independent) throws QueryMetadataException, TeiidComponentException {
        float result = -1.0f;
        for (Expression expr : expressions) {
            Collection<ElementSymbol> symbols = ElementCollectorVisitor.getElements((LanguageObject)expr, true);
            float currentSymbolNDV = NewCalculateCostUtil.getNDV(symbols, node, nodeCardinality, metadata);
            if (currentSymbolNDV == -1.0f) {
                if (NewCalculateCostUtil.usesKey(symbols, metadata)) {
                    return nodeCardinality;
                }
                currentSymbolNDV = independent ? nodeCardinality / 2.0f : nodeCardinality / 4.0f;
            }
            if (result != -1.0f && !(currentSymbolNDV > result)) continue;
            result = currentSymbolNDV;
        }
        return Math.max(1.0f, Math.min(nodeCardinality, result));
    }
}

