/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.execution.QueryExecPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.RulePushSelectCriteria;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.util.CommandContext;

public final class RuleAccessPatternValidation
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException {
        this.validateAccessPatterns(plan, metadata, capFinder);
        return plan;
    }

    void validateAccessPatterns(PlanNode node, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException {
        this.validateAccessPatterns(node);
        for (PlanNode child : node.getChildren()) {
            this.validateAccessPatterns(child, metadata, capFinder);
        }
    }

    private void validateAccessPatterns(PlanNode node) throws QueryPlannerException {
        if (!node.hasCollectionProperty(NodeConstants.Info.ACCESS_PATTERNS)) {
            return;
        }
        Criteria criteria = null;
        if (node.hasProperty(NodeConstants.Info.ATOMIC_REQUEST)) {
            Object req = node.getProperty(NodeConstants.Info.ATOMIC_REQUEST);
            if (req instanceof Insert) {
                return;
            }
            if (req instanceof Delete) {
                criteria = ((Delete)req).getCriteria();
            } else if (req instanceof Update) {
                criteria = ((Update)req).getCriteria();
            }
        }
        List accessPatterns = (List)node.getProperty(NodeConstants.Info.ACCESS_PATTERNS);
        if (criteria != null) {
            List<Criteria> crits = Criteria.separateCriteriaByAnd(criteria);
            for (Criteria crit : crits) {
                Collection<ElementSymbol> elements = ElementCollectorVisitor.getElements((LanguageObject)crit, true);
                if (!RulePushSelectCriteria.satisfyAccessPatterns(accessPatterns, elements)) continue;
                return;
            }
        }
        Set<GroupSymbol> groups = node.getGroups();
        throw new QueryPlannerException(QueryExecPlugin.Util.getString("ERR.015.004.0012", new Object[]{groups, accessPatterns}));
    }

    public String toString() {
        return "AccessPatternValidation";
    }
}

