/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.capabilities.SourceCapabilities;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;
import org.teiid.query.sql.visitor.GroupsUsedByElementsVisitor;
import org.teiid.query.util.CommandContext;

public final class RuleAssignOutputElements
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        PlanNode projectNode = NodeEditor.findNodePreOrder(plan, 16);
        if (projectNode == null) {
            return plan;
        }
        List projectCols = (List)projectNode.getProperty(NodeConstants.Info.PROJECT_COLS);
        this.assignOutputElements(plan, projectCols, metadata, capFinder, rules, analysisRecord, context);
        return plan;
    }

    private void assignOutputElements(PlanNode root, List<SingleElementSymbol> outputElements, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        PlanNode groupSource;
        ElementSymbol symbol;
        int nodeType = root.getType();
        if (outputElements.isEmpty() && (nodeType == 2 || nodeType == 128) && (symbol = this.selectOutputElement((groupSource = FrameUtil.findJoinSourceNode(root)).getGroups(), metadata)) != null) {
            outputElements.add(symbol);
        }
        root.setProperty(NodeConstants.Info.OUTPUT_COLS, outputElements);
        if (root.getChildCount() == 0) {
            return;
        }
        switch (nodeType) {
            case 2: {
                Command command = FrameUtil.getNonQueryCommand(root);
                if (command instanceof StoredProcedure) {
                    root.setProperty(NodeConstants.Info.OUTPUT_COLS, command.getProjectedSymbols());
                }
            }
            case 4: 
            case 64: 
            case 2048: {
                if (root.hasBooleanProperty(NodeConstants.Info.UNRELATED_SORT)) {
                    OrderBy elements = (OrderBy)root.getProperty(NodeConstants.Info.SORT_ORDER);
                    outputElements = new ArrayList<SingleElementSymbol>(outputElements);
                    for (OrderByItem item : elements.getOrderByItems()) {
                        if (outputElements.contains(item.getSymbol())) continue;
                        outputElements.add(item.getSymbol());
                    }
                }
                this.assignOutputElements(root.getLastChild(), outputElements, metadata, capFinder, rules, analysisRecord, context);
                break;
            }
            case 128: {
                PlanNode sortNode;
                outputElements = RuleAssignOutputElements.determineSourceOutput(root, outputElements, metadata, capFinder);
                root.setProperty(NodeConstants.Info.OUTPUT_COLS, outputElements);
                List<SingleElementSymbol> childElements = RuleAssignOutputElements.filterVirtualElements(root, outputElements, metadata);
                SymbolMap symbolMap = (SymbolMap)root.getProperty(NodeConstants.Info.SYMBOL_MAP);
                int size = symbolMap.asMap().size();
                symbolMap.asUpdatableMap().keySet().retainAll(outputElements);
                if (size > outputElements.size() && (sortNode = NodeEditor.findNodePreOrder(root, 64, 16)) != null && !sortNode.hasBooleanProperty(NodeConstants.Info.UNRELATED_SORT)) {
                    List<Expression> symbolOrder = symbolMap.getValues();
                    OrderBy elements = (OrderBy)sortNode.getProperty(NodeConstants.Info.SORT_ORDER);
                    for (OrderByItem item : elements.getOrderByItems()) {
                        int position = symbolOrder.indexOf(SymbolMap.getExpression(item.getSymbol()));
                        item.setExpressionPosition(position);
                        if (position != -1) continue;
                        sortNode.setProperty(NodeConstants.Info.UNRELATED_SORT, true);
                    }
                }
                this.assignOutputElements(root.getFirstChild(), childElements, metadata, capFinder, rules, analysisRecord, context);
                break;
            }
            case 512: {
                for (PlanNode childNode : root.getChildren()) {
                    PlanNode projectNode = NodeEditor.findNodePreOrder(childNode, 16);
                    List projectCols = (List)projectNode.getProperty(NodeConstants.Info.PROJECT_COLS);
                    this.assignOutputElements(childNode, projectCols, metadata, capFinder, rules, analysisRecord, context);
                }
                break;
            }
            default: {
                if (root.getType() == 16) {
                    GroupSymbol intoGroup = (GroupSymbol)root.getProperty(NodeConstants.Info.INTO_GROUP);
                    if (intoGroup != null) {
                        PlanNode intoRoot = NodeEditor.findNodePreOrder(root, 128);
                        this.execute(intoRoot.getFirstChild(), metadata, capFinder, rules, analysisRecord, context);
                        return;
                    }
                    root.setProperty(NodeConstants.Info.PROJECT_COLS, outputElements);
                }
                List<SingleElementSymbol> requiredInput = this.collectRequiredInputSymbols(root);
                if (root.getChildCount() == 1) {
                    this.assignOutputElements(root.getLastChild(), requiredInput, metadata, capFinder, rules, analysisRecord, context);
                    break;
                }
                for (PlanNode childNode : root.getChildren()) {
                    Set<GroupSymbol> filterGroups = FrameUtil.findJoinSourceNode(childNode).getGroups();
                    List<SingleElementSymbol> filteredElements = this.filterElements(requiredInput, filterGroups);
                    this.assignOutputElements(childNode, filteredElements, metadata, capFinder, rules, analysisRecord, context);
                }
            }
        }
    }

    private List<SingleElementSymbol> filterElements(Collection<? extends SingleElementSymbol> requiredInput, Set<GroupSymbol> filterGroups) {
        ArrayList<SingleElementSymbol> filteredElements = new ArrayList<SingleElementSymbol>();
        for (SingleElementSymbol singleElementSymbol : requiredInput) {
            if (!filterGroups.containsAll(GroupsUsedByElementsVisitor.getGroups(singleElementSymbol))) continue;
            filteredElements.add(singleElementSymbol);
        }
        return filteredElements;
    }

    static List<? extends SingleElementSymbol> determineSourceOutput(PlanNode root, List<SingleElementSymbol> outputElements, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryMetadataException, TeiidComponentException {
        PlanNode virtualRoot = root.getLastChild();
        if (RuleAssignOutputElements.hasDupRemoval(virtualRoot)) {
            SymbolMap symbolMap = (SymbolMap)root.getProperty(NodeConstants.Info.SYMBOL_MAP);
            return symbolMap.getKeys();
        }
        PlanNode limit = NodeEditor.findNodePreOrder(root, 2048, 16);
        if (limit == null) {
            return outputElements;
        }
        PlanNode sort = NodeEditor.findNodePreOrder(limit, 64, 16);
        if (sort == null) {
            return outputElements;
        }
        PlanNode access = NodeEditor.findParent(sort, 2);
        if (sort.hasBooleanProperty(NodeConstants.Info.UNRELATED_SORT) || access != null && capFinder != null && CapabilitiesUtil.supports(SourceCapabilities.Capability.QUERY_ORDERBY_UNRELATED, RuleRaiseAccess.getModelIDFromAccess(access, metadata), metadata, capFinder)) {
            return outputElements;
        }
        OrderBy sortOrder = (OrderBy)sort.getProperty(NodeConstants.Info.SORT_ORDER);
        List<SingleElementSymbol> topCols = FrameUtil.findTopCols(sort);
        SymbolMap symbolMap = (SymbolMap)root.getProperty(NodeConstants.Info.SYMBOL_MAP);
        List<ElementSymbol> symbolOrder = symbolMap.getKeys();
        for (OrderByItem item : sortOrder.getOrderByItems()) {
            ElementSymbol symbol;
            SingleElementSymbol expr = item.getSymbol();
            int index = topCols.indexOf(expr);
            if (index < 0 || outputElements.contains(symbol = symbolOrder.get(index))) continue;
            outputElements.add(symbol);
        }
        return outputElements;
    }

    private ElementSymbol selectOutputElement(Collection<GroupSymbol> groups, QueryMetadataInterface metadata) throws QueryMetadataException, TeiidComponentException {
        for (GroupSymbol group : groups) {
            List<ElementSymbol> elements = ResolverUtil.resolveElementsInGroup(group, metadata);
            for (ElementSymbol element : elements) {
                if (!metadata.elementSupports(element.getMetadataID(), 0)) continue;
                element = (ElementSymbol)element.clone();
                element.setGroupSymbol(group);
                return element;
            }
        }
        return null;
    }

    static List<SingleElementSymbol> filterVirtualElements(PlanNode sourceNode, List<SingleElementSymbol> outputColumns, QueryMetadataInterface metadata) {
        PlanNode virtualRoot = sourceNode.getLastChild();
        List<PlanNode> allProjects = NodeEditor.findAllNodes(virtualRoot, 16, 16);
        int[] filteredIndex = new int[outputColumns.size()];
        Arrays.fill(filteredIndex, -1);
        SymbolMap symbolMap = (SymbolMap)sourceNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
        List<ElementSymbol> originalOrder = symbolMap.getKeys();
        for (int i = 0; i < outputColumns.size(); ++i) {
            Expression expr = outputColumns.get(i);
            filteredIndex[i] = originalOrder.indexOf(expr);
        }
        ArrayList newCols = null;
        for (int i = allProjects.size() - 1; i >= 0; --i) {
            PlanNode projectNode = allProjects.get(i);
            List projectCols = (List)projectNode.getProperty(NodeConstants.Info.PROJECT_COLS);
            newCols = new ArrayList();
            for (int j = 0; j < filteredIndex.length; ++j) {
                newCols.add(projectCols.get(filteredIndex[j]));
            }
            projectNode.setProperty(NodeConstants.Info.PROJECT_COLS, newCols);
        }
        return newCols;
    }

    static boolean hasDupRemoval(PlanNode node) {
        List<PlanNode> nodes = NodeEditor.findAllNodes(node, 516, 20);
        for (PlanNode planNode : nodes) {
            if (planNode.getType() != 4 && (planNode.getType() != 512 || !Boolean.FALSE.equals(planNode.getProperty(NodeConstants.Info.USE_ALL)))) continue;
            return true;
        }
        return false;
    }

    private List<SingleElementSymbol> collectRequiredInputSymbols(PlanNode node) {
        LinkedHashSet<SingleElementSymbol> requiredSymbols = new LinkedHashSet<SingleElementSymbol>();
        HashSet<SingleElementSymbol> createdSymbols = new HashSet<SingleElementSymbol>();
        List outputCols = (List)node.getProperty(NodeConstants.Info.OUTPUT_COLS);
        switch (node.getType()) {
            case 16: {
                List projectCols = (List)node.getProperty(NodeConstants.Info.PROJECT_COLS);
                for (SingleElementSymbol ss : projectCols) {
                    ExpressionSymbol exprSymbol;
                    if (ss instanceof AliasSymbol) {
                        createdSymbols.add(ss);
                        ss = ((AliasSymbol)ss).getSymbol();
                    }
                    if (ss instanceof ExpressionSymbol && !(ss instanceof AggregateSymbol) && !(exprSymbol = (ExpressionSymbol)ss).isDerivedExpression()) {
                        createdSymbols.add(ss);
                    }
                    AggregateSymbolCollectorVisitor.getAggregates(ss, requiredSymbols, requiredSymbols);
                }
                break;
            }
            case 32: {
                Criteria selectCriteria = (Criteria)node.getProperty(NodeConstants.Info.SELECT_CRITERIA);
                AggregateSymbolCollectorVisitor.getAggregates(selectCriteria, requiredSymbols, requiredSymbols);
                break;
            }
            case 8: {
                List crits = (List)node.getProperty(NodeConstants.Info.JOIN_CRITERIA);
                if (crits == null) break;
                for (Criteria joinCriteria : crits) {
                    AggregateSymbolCollectorVisitor.getAggregates(joinCriteria, requiredSymbols, requiredSymbols);
                }
                break;
            }
            case 256: {
                List groupCols = (List)node.getProperty(NodeConstants.Info.GROUP_COLS);
                if (groupCols != null) {
                    for (SingleElementSymbol expression : groupCols) {
                        if (expression instanceof ElementSymbol || expression instanceof AggregateSymbol) {
                            requiredSymbols.add(expression);
                            continue;
                        }
                        ExpressionSymbol exprSymbol = (ExpressionSymbol)expression;
                        Expression expr = exprSymbol.getExpression();
                        AggregateSymbolCollectorVisitor.getAggregates(expr, requiredSymbols, requiredSymbols);
                        createdSymbols.add(exprSymbol);
                    }
                }
                for (SingleElementSymbol outputSymbol : outputCols) {
                    if (!(outputSymbol instanceof AggregateSymbol)) continue;
                    AggregateSymbol agg = (AggregateSymbol)outputSymbol;
                    createdSymbols.add(outputSymbol);
                    Expression aggExpr = agg.getExpression();
                    if (aggExpr == null) continue;
                    AggregateSymbolCollectorVisitor.getAggregates(aggExpr, requiredSymbols, requiredSymbols);
                }
                break;
            }
        }
        for (SymbolMap refs : node.getAllReferences()) {
            for (Expression expr : refs.asMap().values()) {
                AggregateSymbolCollectorVisitor.getAggregates(expr, requiredSymbols, requiredSymbols);
            }
        }
        for (SingleElementSymbol currentOutputSymbol : outputCols) {
            if (createdSymbols.contains(currentOutputSymbol)) continue;
            requiredSymbols.add(currentOutputSymbol);
        }
        if (node.getType() == 16) {
            HashSet<Expression> expressions = new HashSet<Expression>();
            Iterator iterator = requiredSymbols.iterator();
            while (iterator.hasNext()) {
                SingleElementSymbol ses = (SingleElementSymbol)iterator.next();
                if (expressions.add(SymbolMap.getExpression(ses))) continue;
                iterator.remove();
            }
        }
        return new ArrayList<SingleElementSymbol>(requiredSymbols);
    }

    public String toString() {
        return "AssignOutputElements";
    }
}

