/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.RuleConstants;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.visitor.EvaluatableVisitor;
import org.teiid.query.util.CommandContext;

public final class RuleCleanCriteria
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, TeiidComponentException {
        boolean pushRaiseNull = false;
        for (PlanNode critNode : NodeEditor.findAllNodes(plan, 32)) {
            Criteria crit;
            if (critNode.hasBooleanProperty(NodeConstants.Info.IS_PHANTOM)) {
                NodeEditor.removeChildNode(critNode.getParent(), critNode);
                continue;
            }
            if (critNode.hasBooleanProperty(NodeConstants.Info.IS_HAVING) || critNode.getGroups().size() != 0 || !EvaluatableVisitor.isFullyEvaluatable(crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA), true)) continue;
            try {
                boolean eval = Evaluator.evaluate(crit);
                if (eval) {
                    NodeEditor.removeChildNode(critNode.getParent(), critNode);
                    continue;
                }
                FrameUtil.replaceWithNullNode(critNode);
                pushRaiseNull = true;
            }
            catch (BlockedException e) {
                throw new TeiidComponentException((Throwable)((Object)e));
            }
            catch (ExpressionEvaluationException e) {
                throw new TeiidComponentException((Throwable)((Object)e));
            }
        }
        if (pushRaiseNull) {
            rules.push(RuleConstants.RAISE_NULL);
        }
        return plan;
    }

    public String toString() {
        return "CleanCriteria";
    }
}

