/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.relational.rules;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.util.Assertion;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.execution.QueryExecPlugin;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.OptimizerRule;
import org.teiid.query.optimizer.relational.RuleStack;
import org.teiid.query.optimizer.relational.plantree.NodeConstants;
import org.teiid.query.optimizer.relational.plantree.NodeEditor;
import org.teiid.query.optimizer.relational.plantree.NodeFactory;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.optimizer.relational.rules.CapabilitiesUtil;
import org.teiid.query.optimizer.relational.rules.CriteriaCapabilityValidatorVisitor;
import org.teiid.query.optimizer.relational.rules.FrameUtil;
import org.teiid.query.optimizer.relational.rules.JoinUtil;
import org.teiid.query.optimizer.relational.rules.RuleMergeCriteria;
import org.teiid.query.optimizer.relational.rules.RuleRaiseAccess;
import org.teiid.query.resolver.util.AccessPattern;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.AggregateSymbolCollectorVisitor;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import org.teiid.query.util.CommandContext;

public final class RulePushSelectCriteria
implements OptimizerRule {
    @Override
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        boolean movedAnyNode = true;
        HashSet<PlanNode> deadNodes = new HashSet<PlanNode>();
        while (movedAnyNode) {
            movedAnyNode = false;
            List<PlanNode> critNodes = NodeEditor.findAllNodes(plan, 32);
            Collections.reverse(critNodes);
            for (PlanNode critNode : critNodes) {
                boolean isPhantom = critNode.hasBooleanProperty(NodeConstants.Info.IS_PHANTOM);
                boolean isCopied = critNode.hasBooleanProperty(NodeConstants.Info.IS_COPIED);
                boolean isPushed = critNode.hasBooleanProperty(NodeConstants.Info.IS_PUSHED);
                if (isPhantom || isCopied || isPushed || deadNodes.contains(critNode)) continue;
                PlanNode sourceNode = this.findOriginatingNode(metadata, capFinder, critNode);
                if (sourceNode == null) {
                    deadNodes.add(critNode);
                    continue;
                }
                this.pushTowardOriginatingNode(sourceNode, critNode, metadata, capFinder);
                boolean moved = false;
                if (critNode.getGroups().isEmpty() && critNode.getSubqueryContainers().isEmpty() || !this.atBoundary(critNode, sourceNode)) {
                    deadNodes.add(critNode);
                    continue;
                }
                switch (sourceNode.getType()) {
                    case 128: {
                        moved = this.pushAcrossFrame(sourceNode, critNode, metadata);
                        break;
                    }
                    case 8: {
                        if (NodeEditor.findParent(critNode, 2) != null) break;
                        moved = this.handleJoinCriteria(sourceNode, critNode, metadata);
                    }
                }
                if (!moved) {
                    deadNodes.add(critNode);
                    continue;
                }
                movedAnyNode = true;
            }
        }
        return plan;
    }

    private PlanNode findOriginatingNode(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode critNode) throws TeiidComponentException, QueryMetadataException {
        if (critNode.getGroups().isEmpty()) {
            PlanNode groupNode = NodeEditor.findNodePreOrder(critNode, 256, 128);
            if (groupNode != null && !groupNode.hasCollectionProperty(NodeConstants.Info.GROUP_COLS)) {
                return groupNode;
            }
            Object modelId = this.getSubqueryModelId(metadata, capFinder, critNode);
            if (modelId != null) {
                for (PlanNode node : NodeEditor.findAllNodes(critNode, 128)) {
                    GroupSymbol group = node.getGroups().iterator().next();
                    Object srcModelID = metadata.getModelID(group.getMetadataID());
                    if (!CapabilitiesUtil.isSameConnector(srcModelID, modelId, metadata, capFinder)) continue;
                    return node;
                }
            }
        }
        return FrameUtil.findOriginatingNode(critNode, critNode.getGroups());
    }

    private Object getSubqueryModelId(QueryMetadataInterface metadata, CapabilitiesFinder capFinder, PlanNode critNode) throws TeiidComponentException, QueryMetadataException {
        Object modelId = null;
        for (SubqueryContainer subqueryContainer : critNode.getSubqueryContainers()) {
            Object validId = CriteriaCapabilityValidatorVisitor.validateSubqueryPushdown(subqueryContainer, null, metadata, capFinder);
            if (validId == null) {
                return null;
            }
            if (modelId == null) {
                modelId = validId;
                continue;
            }
            if (CapabilitiesUtil.isSameConnector(modelId, validId, metadata, capFinder)) continue;
            return null;
        }
        return modelId;
    }

    private boolean handleJoinCriteria(PlanNode joinNode, PlanNode critNode, QueryMetadataInterface metadata) {
        JoinType jt = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (jt == JoinType.JOIN_CROSS || jt == JoinType.JOIN_INNER) {
            if (jt == JoinType.JOIN_CROSS) {
                joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, JoinType.JOIN_INNER);
            }
            this.moveCriteriaIntoOnClause(critNode, joinNode);
        } else {
            JoinType optimized = JoinUtil.optimizeJoinType(critNode, joinNode, metadata);
            if (optimized == JoinType.JOIN_INNER) {
                this.moveCriteriaIntoOnClause(critNode, joinNode);
                return true;
            }
        }
        return false;
    }

    private void moveCriteriaIntoOnClause(PlanNode critNode, PlanNode joinNode) {
        LinkedList<Criteria> joinCriteria = (LinkedList<Criteria>)joinNode.getProperty(NodeConstants.Info.JOIN_CRITERIA);
        Criteria criteria = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        if (joinCriteria == null || joinCriteria.size() == 0) {
            joinCriteria = new LinkedList<Criteria>();
            joinNode.setProperty(NodeConstants.Info.JOIN_CRITERIA, joinCriteria);
        }
        if (!joinCriteria.contains(criteria)) {
            joinCriteria.add(criteria);
            if (critNode.hasBooleanProperty(NodeConstants.Info.IS_DEPENDENT_SET)) {
                joinNode.setProperty(NodeConstants.Info.IS_DEPENDENT_SET, Boolean.TRUE);
            }
        }
        NodeEditor.removeChildNode(critNode.getParent(), critNode);
    }

    void pushTowardOriginatingNode(PlanNode sourceNode, PlanNode critNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, QueryMetadataException, TeiidComponentException {
        boolean groupSelects;
        boolean bl = groupSelects = sourceNode.getParent().getType() == 32 && sourceNode.getChildCount() == 0;
        while (sourceNode.getParent().getType() == 32) {
            if ((sourceNode = sourceNode.getParent()) != critNode) continue;
            return;
        }
        PlanNode destination = this.examinePath(critNode, sourceNode, metadata, capFinder);
        NodeEditor.removeChildNode(critNode.getParent(), critNode);
        destination.addAsParent(critNode);
        if (groupSelects && destination == sourceNode) {
            RuleMergeCriteria.mergeChain(critNode, metadata);
        }
    }

    PlanNode examinePath(PlanNode critNode, PlanNode sourceNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder) throws QueryPlannerException, TeiidComponentException {
        PlanNode currentNode;
        Stack<PlanNode> path = new Stack<PlanNode>();
        for (currentNode = sourceNode.getParent(); currentNode != critNode; currentNode = currentNode.getParent()) {
            path.push(currentNode);
        }
        while (!path.empty()) {
            currentNode = (PlanNode)path.pop();
            if (currentNode.getType() == 2) {
                try {
                    if (!RuleRaiseAccess.canRaiseOverSelect(currentNode, metadata, capFinder, critNode)) {
                        return currentNode;
                    }
                    RulePushSelectCriteria.satisfyAccessPatterns(critNode, currentNode);
                    if (!critNode.hasBooleanProperty(NodeConstants.Info.IS_DEPENDENT_SET) || CapabilitiesUtil.getMaxInCriteriaSize(RuleRaiseAccess.getModelIDFromAccess(currentNode, metadata), metadata, capFinder) <= 0) continue;
                    critNode.setProperty(NodeConstants.Info.IS_PUSHED, Boolean.TRUE);
                    currentNode.setProperty(NodeConstants.Info.IS_DEPENDENT_SET, Boolean.TRUE);
                    return currentNode.getFirstChild();
                }
                catch (QueryMetadataException e) {
                    throw new QueryPlannerException((Throwable)((Object)e), QueryExecPlugin.Util.getString("ERR.015.004.0020", new Object[]{currentNode.getGroups()}));
                }
            }
            if (currentNode.getType() == 8) {
                JoinType optimized;
                if (NodeEditor.findParent(currentNode, 2) != null) {
                    return currentNode;
                }
                JoinType jt = JoinUtil.getJoinTypePreventingCriteriaOptimization(currentNode, critNode);
                if (jt != null && ((optimized = JoinUtil.optimizeJoinType(critNode, currentNode, metadata)) == null || optimized.isOuter())) {
                    return currentNode;
                }
                RulePushSelectCriteria.satisfyAccessPatterns(critNode, currentNode);
                continue;
            }
            if (FrameUtil.isOrderedLimit(currentNode)) {
                return currentNode;
            }
            if (currentNode.getType() != 256 || !critNode.hasBooleanProperty(NodeConstants.Info.IS_HAVING)) continue;
            return currentNode;
        }
        return sourceNode;
    }

    boolean pushAcrossFrame(PlanNode sourceNode, PlanNode critNode, QueryMetadataInterface metadata) throws QueryPlannerException {
        if (sourceNode.getChildCount() == 1 && FrameUtil.isOrderedLimit(sourceNode.getFirstChild())) {
            return false;
        }
        if (sourceNode.getChildCount() > 0) {
            PlanNode child = sourceNode.getFirstChild();
            if ((child = FrameUtil.findOriginatingNode(child, child.getGroups())) != null && child.getType() == 512) {
                if (child == sourceNode.getFirstChild() && critNode.getSubqueryContainers().isEmpty()) {
                    return this.pushAcrossSetOp(critNode, child, metadata);
                }
                return false;
            }
        }
        return this.moveNodeAcrossFrame(critNode, sourceNode, metadata);
    }

    boolean atBoundary(PlanNode critNode, PlanNode sourceNode) {
        for (PlanNode currentNode = sourceNode.getParent(); currentNode != critNode; currentNode = currentNode.getParent()) {
            if (currentNode.getType() == 32) continue;
            return false;
        }
        return true;
    }

    boolean moveNodeAcrossFrame(PlanNode critNode, PlanNode sourceNode, QueryMetadataInterface metadata) throws QueryPlannerException {
        Assertion.isNotNull((Object)critNode.getParent());
        if (sourceNode.getChildCount() == 0) {
            return false;
        }
        PlanNode projectNode = NodeEditor.findNodePreOrder(sourceNode.getFirstChild(), 16, 128);
        if (FrameUtil.isProcedure(projectNode)) {
            return false;
        }
        SymbolMap symbolMap = (SymbolMap)sourceNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
        if (!this.createConvertedSelectNode(critNode, sourceNode.getGroups().iterator().next(), projectNode, symbolMap, metadata)) {
            return false;
        }
        RulePushSelectCriteria.satisfyAccessPatterns(critNode, sourceNode);
        critNode.setProperty(NodeConstants.Info.IS_PHANTOM, Boolean.TRUE);
        return true;
    }

    static void satisfyAccessPatterns(PlanNode critNode, PlanNode sourceNode) {
        List aps = (List)sourceNode.getProperty(NodeConstants.Info.ACCESS_PATTERNS);
        if (aps == null) {
            return;
        }
        Criteria crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        Collection<ElementSymbol> elements = RulePushSelectCriteria.getElementsIncriteria(crit);
        boolean removeAps = RulePushSelectCriteria.satisfyAccessPatterns(aps, elements);
        if (removeAps) {
            sourceNode.removeProperty((Object)NodeConstants.Info.ACCESS_PATTERNS);
            return;
        }
        Collections.sort(aps);
    }

    static Collection<ElementSymbol> getElementsIncriteria(Criteria crit) {
        HashSet<ElementSymbol> elements = new HashSet<ElementSymbol>();
        boolean first = true;
        if (crit instanceof CompoundCriteria) {
            CompoundCriteria compCrit = (CompoundCriteria)crit;
            for (Criteria subCrit : compCrit.getCriteria()) {
                if (compCrit.getOperator() == 0 || first) {
                    first = false;
                    elements.addAll(RulePushSelectCriteria.getElementsIncriteria(subCrit));
                    continue;
                }
                elements.retainAll(RulePushSelectCriteria.getElementsIncriteria(subCrit));
            }
        } else {
            elements.addAll(ElementCollectorVisitor.getElements((LanguageObject)crit, true));
        }
        return elements;
    }

    static boolean satisfyAccessPatterns(List<AccessPattern> aps, Collection<ElementSymbol> elements) {
        for (AccessPattern ap : aps) {
            ap.getUnsatisfied().removeAll(elements);
            if (!ap.getUnsatisfied().isEmpty()) continue;
            return true;
        }
        return false;
    }

    PlanNode copyNode(PlanNode critNode) {
        PlanNode copyNode = NodeFactory.getNewNode(32);
        Criteria crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        Criteria copyCrit = (Criteria)crit.clone();
        copyNode.setProperty(NodeConstants.Info.SELECT_CRITERIA, copyCrit);
        copyNode.addGroups(critNode.getGroups());
        if (critNode.hasBooleanProperty(NodeConstants.Info.IS_DEPENDENT_SET)) {
            copyNode.setProperty(NodeConstants.Info.IS_DEPENDENT_SET, Boolean.TRUE);
        }
        return copyNode;
    }

    boolean pushAcrossSetOp(PlanNode critNode, PlanNode setOp, QueryMetadataInterface metadata) throws QueryPlannerException {
        SymbolMap symbolMap;
        PlanNode sourceNode = NodeEditor.findParent(setOp, 128);
        GroupSymbol virtualGroup = sourceNode.getGroups().iterator().next();
        RulePushSelectCriteria.satisfyAccessPatterns(critNode, sourceNode);
        SymbolMap childMap = symbolMap = (SymbolMap)sourceNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
        LinkedList<PlanNode> unionChildren = new LinkedList<PlanNode>();
        this.collectUnionChildren(setOp, unionChildren);
        int movedCount = 0;
        for (PlanNode planNode : unionChildren) {
            PlanNode projectNode = NodeEditor.findNodePreOrder(planNode, 16);
            if (childMap == null) {
                childMap = SymbolMap.createSymbolMap(symbolMap.getKeys(), (List)projectNode.getProperty(NodeConstants.Info.PROJECT_COLS));
            }
            if (this.createConvertedSelectNode(critNode, virtualGroup, projectNode, childMap, metadata)) {
                ++movedCount;
            }
            childMap = null;
        }
        if (movedCount == unionChildren.size()) {
            critNode.setProperty(NodeConstants.Info.IS_PHANTOM, Boolean.TRUE);
            return true;
        }
        critNode.setProperty(NodeConstants.Info.IS_PUSHED, Boolean.TRUE);
        return false;
    }

    void collectUnionChildren(PlanNode unionNode, LinkedList<PlanNode> unionChildren) {
        for (PlanNode child : unionNode.getChildren()) {
            if (child.getType() == 512) {
                this.collectUnionChildren(child, unionChildren);
                continue;
            }
            unionChildren.add(child);
        }
    }

    private boolean createConvertedSelectNode(PlanNode critNode, GroupSymbol sourceGroup, PlanNode projectNode, SymbolMap symbolMap, QueryMetadataInterface metadata) throws QueryPlannerException {
        if (projectNode.getChildCount() == 0) {
            return false;
        }
        Criteria crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA);
        Boolean conversionResult = this.checkConversion(symbolMap, ElementCollectorVisitor.getElements((LanguageObject)crit, true));
        if (conversionResult == Boolean.FALSE) {
            return false;
        }
        if (!critNode.getSubqueryContainers().isEmpty() && this.checkConversion(symbolMap, critNode.getCorrelatedReferenceElements()) != null) {
            return false;
        }
        PlanNode copyNode = this.copyNode(critNode);
        if (conversionResult == Boolean.TRUE) {
            copyNode.setProperty(NodeConstants.Info.IS_HAVING, Boolean.TRUE);
        }
        FrameUtil.convertNode(copyNode, sourceGroup, null, symbolMap.asMap(), metadata, true);
        PlanNode intermediateParent = NodeEditor.findParent(projectNode, 2, 640);
        if (intermediateParent != null) {
            intermediateParent.addAsParent(copyNode);
        } else {
            projectNode.getFirstChild().addAsParent(copyNode);
        }
        return true;
    }

    private Boolean checkConversion(SymbolMap symbolMap, Collection<ElementSymbol> elements) {
        Boolean result = null;
        for (ElementSymbol element : elements) {
            Expression converted = symbolMap.getMappedExpression(element);
            if (converted == null) {
                return false;
            }
            List<SubqueryContainer> scalarSubqueries = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(converted);
            if (!scalarSubqueries.isEmpty()) {
                return false;
            }
            if (AggregateSymbolCollectorVisitor.getAggregates(converted, false).isEmpty()) continue;
            result = Boolean.TRUE;
        }
        return result;
    }

    public String toString() {
        return "PushSelectCriteria";
    }
}

