/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.List;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.query.execution.QueryExecPlugin;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.AbstractSymbolMappingVisitor;

public class XMLNodeMappingVisitor
extends AbstractSymbolMappingVisitor {
    private MappingNode rootNode;
    private QueryMetadataInterface metadata;

    public XMLNodeMappingVisitor(MappingDocument rootNode, QueryMetadataInterface metadata) {
        this.rootNode = rootNode;
        this.metadata = metadata;
    }

    @Override
    protected Symbol getMappedSymbol(Symbol symbol) {
        if (!(symbol instanceof ElementSymbol)) {
            return null;
        }
        ElementSymbol element = (ElementSymbol)symbol;
        try {
            String path = this.metadata.getFullName(element.getMetadataID()).toUpperCase();
            MappingNode elementNode = MappingNode.findNode(this.rootNode, path);
            if (elementNode == null) {
                return null;
            }
            String symbolName = elementNode.getNameInSource();
            if (symbolName == null) {
                return null;
            }
            return elementNode.getSourceNode().getMappedSymbol(new ElementSymbol(symbolName));
        }
        catch (TeiidComponentException err) {
            throw new TeiidRuntimeException((Throwable)err);
        }
    }

    public static Criteria convertCriteria(Criteria simpleCrit, MappingDocument rootNode, QueryMetadataInterface metadata) throws QueryPlannerException, TeiidComponentException {
        return (Criteria)XMLNodeMappingVisitor.convertObject(simpleCrit, rootNode, metadata);
    }

    public static LanguageObject convertObject(LanguageObject object, MappingDocument rootNode, QueryMetadataInterface metadata) throws QueryPlannerException, TeiidComponentException {
        LanguageObject copy = (LanguageObject)object.clone();
        XMLNodeMappingVisitor mappingVisitor = new XMLNodeMappingVisitor(rootNode, metadata);
        try {
            PreOrderNavigator.doVisit(copy, mappingVisitor);
        }
        catch (TeiidRuntimeException e) {
            Throwable child = e.getChild();
            if (child instanceof TeiidComponentException) {
                throw (TeiidComponentException)child;
            }
            throw new TeiidComponentException(child);
        }
        List unmappedSymbols = mappingVisitor.getUnmappedSymbols();
        if (unmappedSymbols != null && unmappedSymbols.size() > 0) {
            throw new QueryPlannerException("ERR.015.004.0046", QueryExecPlugin.Util.getString("ERR.015.004.0046", new Object[]{unmappedSymbols, object}));
        }
        return copy;
    }
}

