/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.Assertion;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.DependentCriteriaProcessor;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Query;

public class DependentAccessNode
extends AccessNode {
    private int maxSetSize;
    private DependentCriteriaProcessor criteriaProcessor;
    private Criteria dependentCrit;
    private boolean sort = true;

    public DependentAccessNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void closeDirect() {
        super.closeDirect();
        if (this.criteriaProcessor != null) {
            this.criteriaProcessor.close();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.criteriaProcessor = null;
        this.dependentCrit = null;
        this.sort = true;
    }

    @Override
    public Object clone() {
        DependentAccessNode clonedNode = new DependentAccessNode(super.getID());
        clonedNode.maxSetSize = this.maxSetSize;
        super.copy(this, clonedNode);
        return clonedNode;
    }

    public int getMaxSetSize() {
        return this.maxSetSize;
    }

    public void setMaxSetSize(int maxSize) {
        this.maxSetSize = maxSize;
    }

    @Override
    protected boolean prepareNextCommand(Command atomicCommand) throws TeiidComponentException, TeiidProcessingException {
        Assertion.assertTrue((boolean)(atomicCommand instanceof Query));
        Query query = (Query)atomicCommand;
        if (this.criteriaProcessor == null) {
            this.criteriaProcessor = new DependentCriteriaProcessor(this.maxSetSize, this, query.getCriteria());
        }
        if (this.dependentCrit == null) {
            this.dependentCrit = this.criteriaProcessor.prepareCriteria();
        }
        query.setCriteria(this.dependentCrit);
        if (this.sort && query.getOrderBy() != null && this.criteriaProcessor.hasNextCommand()) {
            JoinNode joinNode;
            RelationalNode parent;
            for (parent = this.getParent(); parent != null && !(parent instanceof JoinNode); parent = parent.getParent()) {
            }
            if (parent != null && (joinNode = (JoinNode)parent).getJoinStrategy() instanceof MergeJoinStrategy) {
                MergeJoinStrategy mjs = (MergeJoinStrategy)joinNode.getJoinStrategy();
                mjs.setProcessingSortRight(true);
            }
            this.sort = false;
        }
        if (!this.sort) {
            query.setOrderBy(null);
        }
        boolean result = super.prepareNextCommand(query);
        this.dependentCrit = null;
        this.criteriaProcessor.consumedCriteria();
        return result;
    }

    @Override
    protected boolean hasNextCommand() {
        return this.criteriaProcessor.hasNextCommand();
    }
}

