/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.Assertion;
import org.teiid.logging.LogManager;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.processor.BatchCollector;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.QueryProcessor;
import org.teiid.query.processor.relational.RelationalNodeStatistics;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.util.CommandContext;

public abstract class RelationalNode
implements Cloneable,
BatchCollector.BatchProducer {
    private CommandContext context;
    private BufferManager bufferManager;
    private ProcessorDataManager dataMgr;
    private int nodeID;
    private List elements;
    private int batchSize;
    private RelationalNodeStatistics nodeStatistics;
    private int beginBatch = 1;
    private List batchRows;
    private boolean lastBatch = false;
    private RelationalNode parent;
    private RelationalNode[] children = new RelationalNode[2];
    private Number estimateNodeCardinality;
    private Number setSizeEstimate;
    private Number depAccessEstimate;
    private Number estimateDepJoinCost;
    private Number estimateJoinCost;
    private boolean closed = false;
    private static final String TAB = "  ";

    public RelationalNode(int nodeID) {
        this.nodeID = nodeID;
    }

    public boolean isLastBatch() {
        return this.lastBatch;
    }

    public void setContext(CommandContext context) {
        this.context = context;
    }

    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        this.context = context;
        this.bufferManager = bufferManager;
        this.dataMgr = dataMgr;
        if (context.getCollectNodeStatistics()) {
            this.nodeStatistics = new RelationalNodeStatistics();
        }
        this.batchSize = bufferManager.getProcessorBatchSize();
    }

    public CommandContext getContext() {
        return this.context;
    }

    public int getID() {
        return this.nodeID;
    }

    public void setID(int nodeID) {
        this.nodeID = nodeID;
    }

    protected BufferManager getBufferManager() {
        return this.bufferManager;
    }

    protected ProcessorDataManager getDataManager() {
        return this.dataMgr;
    }

    protected String getConnectionID() {
        return this.context.getConnectionID();
    }

    protected int getBatchSize() {
        return this.batchSize;
    }

    public void reset() {
        for (int i = 0; i < this.children.length && this.children[i] != null; ++i) {
            this.children[i].reset();
        }
        this.beginBatch = 1;
        this.batchRows = null;
        this.lastBatch = false;
        this.closed = false;
    }

    public void setElements(List elements) {
        this.elements = elements;
    }

    @Override
    public List getOutputElements() {
        return this.getElements();
    }

    public List getElements() {
        return this.elements;
    }

    public RelationalNode getParent() {
        return this.parent;
    }

    public void setParent(RelationalNode parent) {
        this.parent = parent;
    }

    public RelationalNode[] getChildren() {
        return this.children;
    }

    public void addChild(RelationalNode child) {
        child.setParent(this);
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != null) continue;
            this.children[i] = child;
            return;
        }
        RelationalNode[] newChildren = new RelationalNode[this.children.length * 2];
        System.arraycopy(this.children, 0, newChildren, 0, this.children.length);
        newChildren[this.children.length] = child;
        this.children = newChildren;
    }

    protected void addBatchRow(List row) {
        if (this.batchRows == null) {
            this.batchRows = new ArrayList(this.batchSize / 4);
        }
        this.batchRows.add(row);
    }

    protected void terminateBatches() {
        this.lastBatch = true;
    }

    protected boolean isBatchFull() {
        return this.batchRows != null && this.batchRows.size() >= this.batchSize;
    }

    protected boolean hasPendingRows() {
        return this.batchRows != null;
    }

    protected TupleBatch pullBatch() {
        TupleBatch batch = null;
        if (this.batchRows != null) {
            batch = new TupleBatch(this.beginBatch, this.batchRows);
            this.beginBatch += this.batchRows.size();
        } else {
            batch = new TupleBatch(this.beginBatch, Collections.EMPTY_LIST);
        }
        batch.setTerminationFlag(this.lastBatch);
        this.batchRows = null;
        this.lastBatch = false;
        return batch;
    }

    public void open() throws TeiidComponentException, TeiidProcessingException {
        for (int i = 0; i < this.children.length && this.children[i] != null; ++i) {
            this.children[i].open();
        }
    }

    @Override
    public final TupleBatch nextBatch() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        boolean recordStats = this.context != null && this.context.getCollectNodeStatistics();
        try {
            TupleBatch batch;
            do {
                if (recordStats && this.context.getCollectNodeStatistics()) {
                    this.nodeStatistics.startBatchTimer();
                }
                batch = this.nextBatchDirect();
                if (!recordStats) continue;
                if (this.context.getCollectNodeStatistics()) {
                    this.nodeStatistics.stopBatchTimer();
                    this.nodeStatistics.collectCumulativeNodeStats(batch, 0);
                    if (batch.getTerminationFlag()) {
                        this.nodeStatistics.collectNodeStats(this.getChildren(), this.getClassName());
                    }
                }
                this.recordBatch(batch);
            } while (batch.getRowCount() == 0 && !batch.getTerminationFlag());
            if (batch.getTerminationFlag()) {
                this.close();
            }
            return batch;
        }
        catch (BlockedException e) {
            if (recordStats && this.context.getCollectNodeStatistics()) {
                this.nodeStatistics.stopBatchTimer();
                this.nodeStatistics.collectCumulativeNodeStats(null, 1);
            }
            throw e;
        }
        catch (QueryProcessor.ExpiredTimeSliceException e) {
            if (recordStats && this.context.getCollectNodeStatistics()) {
                this.nodeStatistics.stopBatchTimer();
            }
            throw e;
        }
        catch (TeiidComponentException e) {
            if (recordStats && this.context.getCollectNodeStatistics()) {
                this.nodeStatistics.stopBatchTimer();
            }
            throw e;
        }
    }

    protected abstract TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException;

    public final void close() throws TeiidComponentException {
        if (!this.closed) {
            this.closeDirect();
            for (int i = 0; i < this.children.length && this.children[i] != null; ++i) {
                this.children[i].close();
            }
            this.closed = true;
        }
    }

    public void closeDirect() {
    }

    public boolean isClosed() {
        return this.closed;
    }

    public static int[] getProjectionIndexes(Map<SingleElementSymbol, Integer> tupleElements, List<? extends Expression> projectElements) {
        int[] result = new int[projectElements.size()];
        int i = 0;
        for (Expression expression : projectElements) {
            Integer index = tupleElements.get(expression);
            Assertion.isNotNull((Object)index);
            result[i++] = index;
        }
        return result;
    }

    public static List<?> projectTuple(int[] indexes, List<?> tupleValues) {
        ArrayList projectedTuple = new ArrayList(indexes.length);
        for (int index : indexes) {
            projectedTuple.add(tupleValues.get(index));
        }
        return projectedTuple;
    }

    public static Map createLookupMap(List elements) {
        HashMap<Object, Integer> lookupMap = new HashMap<Object, Integer>();
        for (int i = 0; i < elements.size(); ++i) {
            Object element = elements.get(i);
            lookupMap.put(element, new Integer(i));
            if (!(element instanceof AliasSymbol)) continue;
            lookupMap.put(((AliasSymbol)element).getSymbol(), new Integer(i));
        }
        return lookupMap;
    }

    private void recordBatch(TupleBatch batch) {
        if (!LogManager.isMessageToBeRecorded((String)"org.teiid.PROCESSOR", (int)6)) {
            return;
        }
        StringBuffer str = new StringBuffer();
        str.append(this.getClassName());
        str.append("(");
        str.append(this.getID());
        str.append(") sending ");
        str.append(batch);
        str.append("\n");
        for (int row = batch.getBeginRow(); row <= batch.getEndRow(); ++row) {
            str.append("\t").append(row).append(": ").append(batch.getTuple(row)).append("\n");
        }
        LogManager.logDetail((String)"org.teiid.PROCESSOR", (Object[])new Object[]{str.toString()});
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        this.getRecursiveString(str, 0);
        return str.toString();
    }

    public String nodeToString() {
        StringBuffer str = new StringBuffer();
        this.getNodeString(str);
        return str.toString();
    }

    private void setTab(StringBuffer str, int tabStop) {
        for (int i = 0; i < tabStop; ++i) {
            str.append(TAB);
        }
    }

    private void getRecursiveString(StringBuffer str, int tabLevel) {
        this.setTab(str, tabLevel);
        this.getNodeString(str);
        str.append("\n");
        for (int i = 0; i < this.children.length && this.children[i] != null; ++i) {
            this.children[i].getRecursiveString(str, tabLevel + 1);
        }
    }

    protected void getNodeString(StringBuffer str) {
        str.append(this.getClassName());
        str.append("(");
        str.append(this.getID());
        str.append(") output=");
        str.append(this.getElements());
        str.append(" ");
    }

    protected String getClassName() {
        return this.getClass().getSimpleName();
    }

    public abstract Object clone();

    protected void copy(RelationalNode source, RelationalNode target) {
        if (source.elements != null) {
            target.elements = new ArrayList(source.elements);
        }
        target.children = new RelationalNode[source.children.length];
        for (int i = 0; i < source.children.length && source.children[i] != null; ++i) {
            target.children[i] = (RelationalNode)source.children[i].clone();
            target.children[i].setParent(target);
        }
    }

    public PlanNode getDescriptionProperties() {
        List<String> costEstimates;
        PlanNode result = new PlanNode(this.getClassName());
        result.addProperty("Output Columns", AnalysisRecord.getOutputColumnProperties(this.elements));
        if (this.context != null && this.context.getCollectNodeStatistics()) {
            result.addProperty("Statistics", this.nodeStatistics.getStatisticsList());
        }
        if ((costEstimates = this.getCostEstimates()) != null) {
            result.addProperty("Cost Estimates", costEstimates);
        }
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] == null) continue;
            result.addProperty("Child " + i, this.children[i].getDescriptionProperties());
        }
        return result;
    }

    public RelationalNodeStatistics getNodeStatistics() {
        return this.nodeStatistics;
    }

    public void setEstimateNodeCardinality(Number estimateNodeCardinality) {
        this.estimateNodeCardinality = estimateNodeCardinality;
    }

    public void setEstimateNodeSetSize(Number setSizeEstimate) {
        this.setSizeEstimate = setSizeEstimate;
    }

    public void setEstimateDepAccessCardinality(Number depAccessEstimate) {
        this.depAccessEstimate = depAccessEstimate;
    }

    public void setEstimateDepJoinCost(Number estimateDepJoinCost) {
        this.estimateDepJoinCost = estimateDepJoinCost;
    }

    public void setEstimateJoinCost(Number estimateJoinCost) {
        this.estimateJoinCost = estimateJoinCost;
    }

    private List<String> getCostEstimates() {
        ArrayList<String> costEstimates = new ArrayList<String>();
        if (this.estimateNodeCardinality != null) {
            costEstimates.add("Estimated Node Cardinality: " + this.estimateNodeCardinality);
        }
        if (this.setSizeEstimate != null) {
            costEstimates.add("Estimated Independent Node Produced Set Size: " + this.setSizeEstimate);
        }
        if (this.depAccessEstimate != null) {
            costEstimates.add("Estimated Dependent Access Cardinality: " + this.depAccessEstimate);
        }
        if (this.estimateDepJoinCost != null) {
            costEstimates.add("Estimated Dependent Join Cost: " + this.estimateDepJoinCost);
        }
        if (this.estimateJoinCost != null) {
            costEstimates.add("Estimated Join Cost: " + this.estimateJoinCost);
        }
        if (costEstimates.size() <= 0) {
            return null;
        }
        return costEstimates;
    }

    public Number getEstimateNodeCardinality() {
        return this.estimateNodeCardinality;
    }
}

