/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.teiid.client.plan.PlanNode;
import org.teiid.common.buffer.BlockedException;
import org.teiid.common.buffer.BufferManager;
import org.teiid.common.buffer.TupleBatch;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.processor.ProcessorDataManager;
import org.teiid.query.processor.relational.SubqueryAwareRelationalNode;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.util.CommandContext;

public class SelectNode
extends SubqueryAwareRelationalNode {
    private Criteria criteria;
    private Map elementMap;
    private int[] projectionIndexes;
    private TupleBatch currentBatch;
    private int currentRow = 1;

    public SelectNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void reset() {
        super.reset();
        this.currentBatch = null;
        this.currentRow = 1;
    }

    public void setCriteria(Criteria criteria) {
        this.criteria = criteria;
    }

    public Criteria getCriteria() {
        return this.criteria;
    }

    @Override
    public void initialize(CommandContext context, BufferManager bufferManager, ProcessorDataManager dataMgr) {
        super.initialize(context, bufferManager, dataMgr);
        if (this.elementMap == null) {
            this.elementMap = SelectNode.createLookupMap(this.getChildren()[0].getElements());
            this.projectionIndexes = SelectNode.getProjectionIndexes(this.elementMap, this.getElements());
        }
    }

    @Override
    public TupleBatch nextBatchDirect() throws BlockedException, TeiidComponentException, TeiidProcessingException {
        if (this.currentBatch == null) {
            this.currentBatch = this.getChildren()[0].nextBatch();
        }
        while (this.currentRow <= this.currentBatch.getEndRow() && !this.isBatchFull()) {
            List tuple = this.currentBatch.getTuple(this.currentRow);
            if (this.getEvaluator(this.elementMap).evaluate(this.criteria, tuple)) {
                this.addBatchRow(SelectNode.projectTuple(this.projectionIndexes, tuple));
            }
            ++this.currentRow;
        }
        if (this.currentRow > this.currentBatch.getEndRow()) {
            if (this.currentBatch.getTerminationFlag()) {
                this.terminateBatches();
            }
            this.currentBatch = null;
        }
        return this.pullBatch();
    }

    @Override
    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append(this.criteria);
    }

    @Override
    public Object clone() {
        SelectNode clonedNode = new SelectNode(super.getID());
        this.copy(this, clonedNode);
        return clonedNode;
    }

    protected void copy(SelectNode source, SelectNode target) {
        super.copy(source, target);
        target.criteria = this.criteria;
        target.elementMap = source.elementMap;
        target.projectionIndexes = source.projectionIndexes;
    }

    @Override
    public PlanNode getDescriptionProperties() {
        PlanNode props = super.getDescriptionProperties();
        AnalysisRecord.addLanaguageObjects(props, "Criteria", Arrays.asList(this.criteria));
        return props;
    }
}

