/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.Collections;
import java.util.Map;
import org.teiid.api.exception.query.ExpressionEvaluationException;
import org.teiid.common.buffer.BlockedException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.eval.Evaluator;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.SubqueryAwareEvaluator;
import org.teiid.query.sql.lang.TableFunctionReference;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;

public abstract class SubqueryAwareRelationalNode
extends RelationalNode {
    private SubqueryAwareEvaluator evaluator;

    public SubqueryAwareRelationalNode(int nodeID) {
        super(nodeID);
    }

    protected Evaluator getEvaluator(Map elementMap) {
        if (this.evaluator == null) {
            this.evaluator = new SubqueryAwareEvaluator(elementMap, this.getDataManager(), this.getContext(), this.getBufferManager());
        } else {
            this.evaluator.initialize(this.getContext(), this.getDataManager());
        }
        return this.evaluator;
    }

    @Override
    public void reset() {
        super.reset();
        if (this.evaluator != null) {
            this.evaluator.reset();
        }
    }

    @Override
    public void closeDirect() {
        if (this.evaluator != null) {
            this.evaluator.close();
        }
    }

    protected void setReferenceValues(TableFunctionReference ref) throws ExpressionEvaluationException, BlockedException, TeiidComponentException {
        if (ref.getCorrelatedReferences() == null) {
            return;
        }
        for (Map.Entry<ElementSymbol, Expression> entry : ref.getCorrelatedReferences().asMap().entrySet()) {
            this.getContext().getVariableContext().setValue(entry.getKey(), this.getEvaluator(Collections.emptyMap()).evaluate(entry.getValue(), null));
        }
    }
}

