/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryParserException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.api.exception.query.UnresolvedSymbolDescription;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.DataTypeManager;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.parser.QueryParser;
import org.teiid.query.resolver.CommandResolver;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.util.ResolveVirtualGroupCriteriaVisitor;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.GroupContext;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.DeclareStatement;
import org.teiid.query.sql.proc.ExpressionStatement;
import org.teiid.query.sql.proc.IfStatement;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.proc.WhileStatement;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.util.SymbolMap;
import org.teiid.query.sql.visitor.ValueIteratorProviderCollectorVisitor;

public class UpdateProcedureResolver
implements CommandResolver {
    public void resolveVirtualGroupElements(CreateUpdateProcedureCommand procCommand, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        GroupSymbol virtualGroup = procCommand.getVirtualGroup();
        if (virtualGroup == null) {
            for (GroupSymbol groupSymbol : procCommand.getAllExternalGroups()) {
                String groupName = groupSymbol.getName();
                if (groupName.equalsIgnoreCase("INPUT") || groupName.equalsIgnoreCase("INPUTS") || groupName.equalsIgnoreCase("CHANGING")) continue;
                ResolverUtil.resolveGroup(groupSymbol, metadata);
                procCommand.setVirtualGroup(groupSymbol);
                virtualGroup = groupSymbol;
                break;
            }
        }
        if (virtualGroup == null) {
            throw new QueryResolverException("ERR.015.008.0012", QueryPlugin.Util.getString("ERR.015.008.0012"));
        }
        ResolveVirtualGroupCriteriaVisitor.resolveCriteria(procCommand, virtualGroup, metadata);
        Command transformCmd = this.getQueryTransformCmd(virtualGroup, metadata);
        Map<ElementSymbol, Expression> symbolMap = SymbolMap.createSymbolMap(virtualGroup, transformCmd.getProjectedSymbols(), metadata).asMap();
        procCommand.setSymbolMap(symbolMap);
    }

    private Command getQueryTransformCmd(GroupSymbol virtualGroup, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        Command transformCmd = (Command)metadata.getFromMetadataCache(virtualGroup.getMetadataID(), "transformation/select");
        if (transformCmd != null) {
            return transformCmd;
        }
        QueryNode queryNode = metadata.getVirtualPlan(virtualGroup.getMetadataID());
        String transformQuery = queryNode.getQuery();
        try {
            transformCmd = QueryParser.getQueryParser().parseCommand(transformQuery);
        }
        catch (QueryParserException e) {
            throw new QueryResolverException((Throwable)((Object)e), "ERR.015.008.0013", QueryPlugin.Util.getString("ERR.015.008.0013", new Object[]{virtualGroup}));
        }
        QueryResolver.resolveCommand(transformCmd, metadata);
        return transformCmd;
    }

    @Override
    public void resolveCommand(Command command, TempMetadataAdapter metadata, AnalysisRecord analysis, boolean resolveNullLiterals) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        CreateUpdateProcedureCommand procCommand = (CreateUpdateProcedureCommand)command;
        GroupContext externalGroups = command.getExternalGroupContexts();
        LinkedList<ElementSymbol> symbols = new LinkedList<ElementSymbol>();
        if (procCommand.isUpdateProcedure()) {
            this.resolveVirtualGroupElements(procCommand, metadata);
            String countVar = "VARIABLES.ROWS_UPDATED";
            ElementSymbol updateCount = new ElementSymbol(countVar);
            updateCount.setType(DataTypeManager.DefaultDataClasses.INTEGER);
            symbols.add(updateCount);
            ProcedureContainerResolver.addScalarGroup("VARIABLES", metadata.getMetadataStore(), externalGroups, symbols);
        }
        this.resolveBlock(procCommand, procCommand.getBlock(), externalGroups, metadata, procCommand.isUpdateProcedure(), analysis);
    }

    private void resolveBlock(CreateUpdateProcedureCommand command, Block block, GroupContext externalGroups, TempMetadataAdapter metadata, boolean isUpdateProcedure, AnalysisRecord analysis) throws QueryResolverException, QueryMetadataException, TeiidComponentException {
        LogManager.logTrace((String)"org.teiid.PLANNER.RESOLVER", (Object[])new Object[]{"Resolving block", block});
        TempMetadataStore store = new TempMetadataStore(new HashMap<String, TempMetadataID>(metadata.getMetadataStore().getData()));
        metadata = new TempMetadataAdapter(metadata.getMetadata(), store);
        externalGroups = new GroupContext(externalGroups, null);
        GroupSymbol variables = ProcedureContainerResolver.addScalarGroup("VARIABLES", store, externalGroups, new LinkedList());
        Iterator<Statement> stmtIter = block.getStatements().iterator();
        while (stmtIter.hasNext()) {
            this.resolveStatement(command, stmtIter.next(), externalGroups, variables, metadata, isUpdateProcedure, analysis);
        }
    }

    private void resolveStatement(CreateUpdateProcedureCommand command, Statement statement, GroupContext externalGroups, GroupSymbol variables, TempMetadataAdapter metadata, boolean isUpdateProcedure, AnalysisRecord analysis) throws QueryResolverException, QueryMetadataException, TeiidComponentException {
        LogManager.logTrace((String)"org.teiid.PLANNER.RESOLVER", (Object[])new Object[]{"Resolving statement", statement});
        switch (statement.getType()) {
            case 1: {
                IfStatement ifStmt = (IfStatement)statement;
                Criteria ifCrit = ifStmt.getCondition();
                for (SubqueryContainer container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(ifCrit)) {
                    this.resolveEmbeddedCommand(metadata, externalGroups, container.getCommand(), analysis);
                }
                ResolverVisitor.resolveLanguageObject(ifCrit, null, externalGroups, metadata);
                this.resolveBlock(command, ifStmt.getIfBlock(), externalGroups, metadata, isUpdateProcedure, analysis);
                if (!ifStmt.hasElseBlock()) break;
                this.resolveBlock(command, ifStmt.getElseBlock(), externalGroups, metadata, isUpdateProcedure, analysis);
                break;
            }
            case 2: {
                DynamicCommand dynamicCommand;
                DynamicCommand dynCommand;
                CommandStatement cmdStmt = (CommandStatement)statement;
                Command subCommand = cmdStmt.getCommand();
                TempMetadataStore discoveredMetadata = this.resolveEmbeddedCommand(metadata, externalGroups, subCommand, analysis);
                if (discoveredMetadata != null) {
                    metadata.getMetadataStore().getData().putAll(discoveredMetadata.getData());
                }
                if (subCommand instanceof DynamicCommand && (dynCommand = (DynamicCommand)subCommand).getIntoGroup() == null && !command.isUpdateProcedure() && !dynCommand.isAsClauseSet() && !command.getProjectedSymbols().isEmpty()) {
                    dynCommand.setAsColumns(command.getProjectedSymbols());
                }
                if (command.isUpdateProcedure()) break;
                if (command.getResultsCommand() != null && command.getResultsCommand().getType() == 10 && !(dynamicCommand = (DynamicCommand)command.getResultsCommand()).isAsClauseSet()) {
                    dynamicCommand.setAsColumns(Collections.EMPTY_LIST);
                }
                command.setResultsCommand(subCommand);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                ExpressionStatement exprStmt = (ExpressionStatement)((Object)statement);
                if (exprStmt.getExpression() != null) {
                    Expression expr = exprStmt.getExpression();
                    for (SubqueryContainer container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(expr)) {
                        this.resolveEmbeddedCommand(metadata, externalGroups, container.getCommand(), analysis);
                    }
                    ResolverVisitor.resolveLanguageObject(expr, null, externalGroups, metadata);
                }
                if (statement.getType() == 3) {
                    this.collectDeclareVariable((DeclareStatement)statement, variables, metadata, externalGroups);
                } else if (statement.getType() == 5) {
                    AssignmentStatement assStmt = (AssignmentStatement)statement;
                    ResolverVisitor.resolveLanguageObject(assStmt.getVariable(), null, externalGroups, metadata);
                    if (statement.getType() == 5 && !assStmt.getVariable().getGroupSymbol().getCanonicalName().equals("VARIABLES")) {
                        throw new QueryResolverException(QueryPlugin.Util.getString("UpdateProcedureResolver.only_variables", new Object[]{assStmt.getVariable()}));
                    }
                    assStmt.getVariable().setIsExternalReference(false);
                }
                if (exprStmt.getExpression() == null) break;
                Class<?> varType = exprStmt.getExpectedType();
                Class exprType = exprStmt.getExpression().getType();
                if (exprType == null) {
                    throw new QueryResolverException(QueryPlugin.Util.getString("ResolveVariablesVisitor.datatype_for_the_expression_not_resolvable"));
                }
                String varTypeName = DataTypeManager.getDataTypeName(varType);
                exprStmt.setExpression(ResolverUtil.convertExpression(exprStmt.getExpression(), varTypeName, metadata));
                break;
            }
            case 7: {
                WhileStatement whileStmt = (WhileStatement)statement;
                Criteria whileCrit = whileStmt.getCondition();
                for (SubqueryContainer container : ValueIteratorProviderCollectorVisitor.getValueIteratorProviders(whileCrit)) {
                    this.resolveEmbeddedCommand(metadata, externalGroups, container.getCommand(), analysis);
                }
                ResolverVisitor.resolveLanguageObject(whileCrit, null, externalGroups, metadata);
                this.resolveBlock(command, whileStmt.getBlock(), externalGroups, metadata, isUpdateProcedure, analysis);
                break;
            }
            case 6: {
                LoopStatement loopStmt = (LoopStatement)statement;
                String groupName = loopStmt.getCursorName();
                if (metadata.getMetadataStore().getTempGroupID(groupName) != null) {
                    throw new QueryResolverException(QueryPlugin.Util.getString("ERR.015.012.0065"));
                }
                if (GroupSymbol.isTempGroupName(loopStmt.getCursorName())) {
                    String errorMsg = QueryPlugin.Util.getString("ResolveVariablesVisitor.reserved_word_for_temporary_used", new Object[]{loopStmt.getCursorName()});
                    throw new QueryResolverException(errorMsg);
                }
                Command cmd = loopStmt.getCommand();
                this.resolveEmbeddedCommand(metadata, externalGroups, cmd, analysis);
                List<SingleElementSymbol> symbols = cmd.getProjectedSymbols();
                TempMetadataStore store = new TempMetadataStore(new HashMap<String, TempMetadataID>(metadata.getMetadataStore().getData()));
                metadata = new TempMetadataAdapter(metadata.getMetadata(), store);
                externalGroups = new GroupContext(externalGroups, null);
                ProcedureContainerResolver.addScalarGroup(groupName, store, externalGroups, symbols);
                this.resolveBlock(command, loopStmt.getBlock(), externalGroups, metadata, isUpdateProcedure, analysis);
                break;
            }
            case 8: 
            case 9: {
                break;
            }
            default: {
                throw new QueryResolverException("ERR.015.008.0015", QueryPlugin.Util.getString("ERR.015.008.0015", new Object[]{statement.getType()}));
            }
        }
    }

    private TempMetadataStore resolveEmbeddedCommand(TempMetadataAdapter metadata, GroupContext groupContext, Command cmd, AnalysisRecord analysis) throws TeiidComponentException, QueryResolverException {
        QueryResolver.setChildMetadata(cmd, metadata.getMetadataStore().getData(), groupContext);
        return QueryResolver.resolveCommand(cmd, Collections.EMPTY_MAP, metadata.getMetadata(), analysis);
    }

    private void collectDeclareVariable(DeclareStatement obj, GroupSymbol variables, TempMetadataAdapter metadata, GroupContext externalGroups) throws QueryResolverException, TeiidComponentException {
        ElementSymbol variable = obj.getVariable();
        String typeName = obj.getVariableType();
        String varName = variable.getName();
        int sepIndex = varName.indexOf(".");
        if (sepIndex < 0) {
            String outputName = varName;
            varName = "VARIABLES." + varName;
            variable.setName(varName);
            variable.setOutputName(outputName);
        } else {
            sepIndex = varName.lastIndexOf(".");
            String groupName = varName.substring(0, sepIndex);
            if (!groupName.equals("VARIABLES")) {
                this.handleUnresolvableDeclaration(variable, QueryPlugin.Util.getString("ERR.015.010.0031", new Object[]{"VARIABLES", variable}));
            }
        }
        boolean exists = false;
        try {
            ResolverVisitor.resolveLanguageObject(variable, null, externalGroups, metadata);
            exists = true;
        }
        catch (QueryResolverException e) {
            // empty catch block
        }
        if (exists) {
            this.handleUnresolvableDeclaration(variable, QueryPlugin.Util.getString("ERR.015.010.0032", new Object[]{variable.getOutputName()}));
        }
        variable.setType(DataTypeManager.getDataTypeClass((String)typeName));
        variable.setGroupSymbol(variables);
        variable.setMetadataID(new TempMetadataID(variable.getName(), variable.getType()));
        metadata.getMetadataStore().addElementToTempGroup("VARIABLES", (ElementSymbol)variable.clone());
    }

    private void handleUnresolvableDeclaration(ElementSymbol variable, String description) throws QueryResolverException {
        UnresolvedSymbolDescription symbol = new UnresolvedSymbolDescription(variable.toString(), description);
        QueryResolverException e = new QueryResolverException(symbol.getDescription());
        e.setUnresolvedSymbols(Arrays.asList(symbol));
        throw e;
    }
}

