/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class DynamicCommand
extends Command {
    private Expression sql;
    private List asColumns;
    private GroupSymbol intoGroup;
    private int updatingModelCount;
    private SetClauseList using;
    private boolean asClauseSet;

    public DynamicCommand() {
    }

    public DynamicCommand(Expression sql, List columns, GroupSymbol intoGroup, SetClauseList using) {
        this.sql = sql;
        this.asColumns = columns;
        this.intoGroup = intoGroup;
        this.using = using;
    }

    @Override
    public Object clone() {
        DynamicCommand clone = new DynamicCommand();
        clone.setSql((Expression)this.getSql().clone());
        if (this.asColumns != null) {
            ArrayList<Object> cloneColumns = new ArrayList<Object>(this.asColumns.size());
            Iterator i = this.asColumns.iterator();
            while (i.hasNext()) {
                cloneColumns.add(((ElementSymbol)i.next()).clone());
            }
            clone.setAsColumns(cloneColumns);
        }
        if (this.intoGroup != null) {
            clone.setIntoGroup((GroupSymbol)this.intoGroup.clone());
        }
        if (this.using != null) {
            clone.setUsing((SetClauseList)this.using.clone());
        }
        clone.setUpdatingModelCount(this.getUpdatingModelCount());
        this.copyMetadataState(clone);
        clone.setAsClauseSet(this.isAsClauseSet());
        return clone;
    }

    @Override
    public int getType() {
        return 10;
    }

    public List getProjectedSymbols() {
        if (this.intoGroup != null) {
            return Command.getUpdateCommandSymbol();
        }
        if (this.asColumns != null) {
            return this.asColumns;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public boolean areResultsCachable() {
        return false;
    }

    public void setUpdatingModelCount(int count) {
        if (count < 0) {
            count = 0;
        } else if (count > 2) {
            count = 2;
        }
        this.updatingModelCount = count;
    }

    public int getUpdatingModelCount() {
        return this.updatingModelCount;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public List getAsColumns() {
        if (this.asColumns == null) {
            return Collections.EMPTY_LIST;
        }
        return this.asColumns;
    }

    public void setAsColumns(List columns) {
        this.asColumns = columns;
    }

    public GroupSymbol getIntoGroup() {
        return this.intoGroup;
    }

    public void setIntoGroup(GroupSymbol intoGroup) {
        this.intoGroup = intoGroup;
    }

    public Expression getSql() {
        return this.sql;
    }

    public void setSql(Expression sql) {
        this.sql = sql;
    }

    public SetClauseList getUsing() {
        return this.using;
    }

    public void setUsing(SetClauseList using) {
        this.using = using;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DynamicCommand)) {
            return false;
        }
        DynamicCommand other = (DynamicCommand)obj;
        return this.updatingModelCount == other.updatingModelCount && EquivalenceUtil.areEqual((Object)this.getAsColumns(), (Object)other.getAsColumns()) && EquivalenceUtil.areEqual((Object)this.getSql(), (Object)other.getSql()) && EquivalenceUtil.areEqual((Object)this.getIntoGroup(), (Object)other.getIntoGroup()) && EquivalenceUtil.areEqual((Object)this.getUsing(), (Object)other.getUsing());
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.sql});
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.asColumns});
        return myHash;
    }

    @Override
    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public boolean isAsClauseSet() {
        return this.asClauseSet;
    }

    public void setAsClauseSet(boolean asClauseSet) {
        this.asClauseSet = asClauseSet;
    }
}

