/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.concurrent.atomic.AtomicInteger;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.AbstractCompareCriteria;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.SubqueryContainer;
import org.teiid.query.sql.symbol.ContextReference;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ScalarSubquery;

public class SubqueryCompareCriteria
extends AbstractCompareCriteria
implements SubqueryContainer,
ContextReference {
    private static AtomicInteger ID = new AtomicInteger();
    public static final int SOME = 2;
    public static final int ANY = 3;
    public static final int ALL = 4;
    private int predicateQuantifier = 4;
    private Command command;
    private String id = "$scc/id" + ID.getAndIncrement();

    public SubqueryCompareCriteria() {
    }

    public SubqueryCompareCriteria(Expression leftExpression, Command subCommand, int operator, int predicateQuantifier) {
        this.setLeftExpression(leftExpression);
        this.setCommand(subCommand);
        this.setOperator(operator);
        this.setPredicateQuantifier(predicateQuantifier);
    }

    @Override
    public String getContextSymbol() {
        return this.id;
    }

    @Override
    public Expression getValueExpression() {
        return null;
    }

    public int getPredicateQuantifier() {
        return this.predicateQuantifier;
    }

    public void setPredicateQuantifier(int predicateQuantifier) {
        this.predicateQuantifier = predicateQuantifier;
    }

    @Override
    public Command getCommand() {
        return this.command;
    }

    @Override
    public void setCommand(Command command) {
        this.command = command;
    }

    public String getPredicateQuantifierAsString() {
        switch (this.predicateQuantifier) {
            case 3: {
                return "ANY ";
            }
            case 2: {
                return "SOME ";
            }
            case 4: {
                return "ALL ";
            }
        }
        return "??";
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int hc = 0;
        hc = HashCodeUtil.hashCode((int)hc, (Object[])new Object[]{this.getLeftExpression()});
        hc = HashCodeUtil.hashCode((int)hc, (int)this.getOperator());
        hc = HashCodeUtil.hashCode((int)hc, (int)this.getPredicateQuantifier());
        hc = HashCodeUtil.hashCode((int)hc, (Object[])new Object[]{this.getCommand()});
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SubqueryCompareCriteria)) {
            return false;
        }
        SubqueryCompareCriteria scc = (SubqueryCompareCriteria)obj;
        return this.getOperator() == scc.getOperator() && this.getPredicateQuantifier() == scc.getPredicateQuantifier() && EquivalenceUtil.areEqual((Object)this.getLeftExpression(), (Object)scc.getLeftExpression()) && EquivalenceUtil.areEqual((Object)this.getCommand(), (Object)scc.getCommand());
    }

    @Override
    public Object clone() {
        Expression leftCopy = null;
        if (this.getLeftExpression() != null) {
            leftCopy = (Expression)this.getLeftExpression().clone();
        }
        Command copyCommand = null;
        if (this.getCommand() != null) {
            copyCommand = (Command)this.getCommand().clone();
        }
        return new SubqueryCompareCriteria(leftCopy, copyCommand, this.getOperator(), this.getPredicateQuantifier());
    }

    @Override
    public Expression getRightExpression() {
        return new ScalarSubquery(this.getCommand());
    }
}

