/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.util.StringUtil;
import org.teiid.language.SQLConstants;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.AtomicCriteria;
import org.teiid.query.sql.lang.BetweenCriteria;
import org.teiid.query.sql.lang.CacheHint;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.CompoundCriteria;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.lang.DynamicCommand;
import org.teiid.query.sql.lang.ExistsCriteria;
import org.teiid.query.sql.lang.ExpressionCriteria;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.FromClause;
import org.teiid.query.sql.lang.GroupBy;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.JoinPredicate;
import org.teiid.query.sql.lang.JoinType;
import org.teiid.query.sql.lang.Limit;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.NotCriteria;
import org.teiid.query.sql.lang.Option;
import org.teiid.query.sql.lang.OrderBy;
import org.teiid.query.sql.lang.OrderByItem;
import org.teiid.query.sql.lang.PredicateCriteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.lang.SetClause;
import org.teiid.query.sql.lang.SetClauseList;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.lang.SetQuery;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.SubqueryCompareCriteria;
import org.teiid.query.sql.lang.SubqueryFromClause;
import org.teiid.query.sql.lang.SubquerySetCriteria;
import org.teiid.query.sql.lang.TextTable;
import org.teiid.query.sql.lang.UnaryFromClause;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.lang.XMLTable;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.Block;
import org.teiid.query.sql.proc.BreakStatement;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.ContinueStatement;
import org.teiid.query.sql.proc.CreateUpdateProcedureCommand;
import org.teiid.query.sql.proc.CriteriaSelector;
import org.teiid.query.sql.proc.DeclareStatement;
import org.teiid.query.sql.proc.HasCriteria;
import org.teiid.query.sql.proc.IfStatement;
import org.teiid.query.sql.proc.LoopStatement;
import org.teiid.query.sql.proc.RaiseErrorStatement;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.proc.TranslateCriteria;
import org.teiid.query.sql.proc.WhileStatement;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.AliasSymbol;
import org.teiid.query.sql.symbol.AllInGroupSymbol;
import org.teiid.query.sql.symbol.AllSymbol;
import org.teiid.query.sql.symbol.CaseExpression;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.DerivedColumn;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.QueryString;
import org.teiid.query.sql.symbol.Reference;
import org.teiid.query.sql.symbol.ScalarSubquery;
import org.teiid.query.sql.symbol.SearchedCaseExpression;
import org.teiid.query.sql.symbol.SelectSymbol;
import org.teiid.query.sql.symbol.SingleElementSymbol;
import org.teiid.query.sql.symbol.XMLAttributes;
import org.teiid.query.sql.symbol.XMLElement;
import org.teiid.query.sql.symbol.XMLForest;
import org.teiid.query.sql.symbol.XMLNamespaces;
import org.teiid.query.sql.symbol.XMLParse;
import org.teiid.query.sql.symbol.XMLQuery;
import org.teiid.query.sql.symbol.XMLSerialize;

public class SQLStringVisitor
extends LanguageVisitor {
    public static final String UNDEFINED = "<undefined>";
    private static final String SPACE = " ";
    private static final String BEGIN_HINT = "/*+";
    private static final String END_HINT = "*/";
    private static final char ID_ESCAPE_CHAR = '\"';
    private LinkedList<Object> parts = new LinkedList();

    public static final String getSQLString(LanguageObject obj) {
        if (obj == null) {
            return UNDEFINED;
        }
        SQLStringVisitor visitor = new SQLStringVisitor();
        obj.acceptVisitor(visitor);
        return visitor.getSQLString();
    }

    public String getSQLString() {
        StringBuilder output = new StringBuilder();
        SQLStringVisitor.getSQLString(this.parts, output);
        return output.toString();
    }

    public static void getSQLString(List<Object> parts, StringBuilder output) {
        for (Object object : parts) {
            if (object instanceof List) {
                SQLStringVisitor.getSQLString((List)object, output);
                continue;
            }
            output.append(object);
        }
    }

    public List<Object> registerNode(LanguageObject obj) {
        if (obj == null) {
            return Arrays.asList(UNDEFINED);
        }
        SQLStringVisitor visitor = new SQLStringVisitor();
        obj.acceptVisitor(visitor);
        return visitor.parts;
    }

    public void replaceStringParts(Object[] parts) {
        for (int i = 0; i < parts.length; ++i) {
            this.parts.add(parts[i]);
        }
    }

    @Override
    public void visit(BetweenCriteria obj) {
        this.parts.add(this.registerNode(obj.getExpression()));
        this.parts.add(SPACE);
        if (obj.isNegated()) {
            this.parts.add("NOT");
            this.parts.add(SPACE);
        }
        this.parts.add("BETWEEN");
        this.parts.add(SPACE);
        this.parts.add(this.registerNode(obj.getLowerExpression()));
        this.parts.add(SPACE);
        this.parts.add("AND");
        this.parts.add(SPACE);
        this.parts.add(this.registerNode(obj.getUpperExpression()));
    }

    @Override
    public void visit(CaseExpression obj) {
        this.parts.add("CASE");
        this.parts.add(SPACE);
        this.parts.add(this.registerNode(obj.getExpression()));
        this.parts.add(SPACE);
        for (int i = 0; i < obj.getWhenCount(); ++i) {
            this.parts.add("WHEN");
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getWhenExpression(i)));
            this.parts.add(SPACE);
            this.parts.add("THEN");
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getThenExpression(i)));
            this.parts.add(SPACE);
        }
        if (obj.getElseExpression() != null) {
            this.parts.add("ELSE");
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getElseExpression()));
            this.parts.add(SPACE);
        }
        this.parts.add("END");
    }

    @Override
    public void visit(CompareCriteria obj) {
        Expression leftExpression = obj.getLeftExpression();
        List<Object> leftPart = this.registerNode(leftExpression);
        String operator = obj.getOperatorAsString();
        Expression rightExpression = obj.getRightExpression();
        List<Object> rightPart = this.registerNode(rightExpression);
        this.replaceStringParts(new Object[]{leftPart, SPACE, operator, SPACE, rightPart});
    }

    @Override
    public void visit(CompoundCriteria obj) {
        int operator = obj.getOperator();
        String operatorStr = "";
        if (operator == 0) {
            operatorStr = "AND";
        } else if (operator == 1) {
            operatorStr = "OR";
        }
        List<Criteria> subCriteria = obj.getCriteria();
        if (subCriteria.size() == 1) {
            Criteria firstChild = subCriteria.get(0);
            this.replaceStringParts(new Object[]{this.registerNode(firstChild)});
        } else {
            Object[] parts = new Object[6 * subCriteria.size() - 3];
            Iterator<Criteria> iter = subCriteria.iterator();
            Criteria crit = iter.next();
            parts[0] = "(";
            parts[1] = this.registerNode(crit);
            parts[2] = ")";
            int i = 3;
            while (iter.hasNext()) {
                parts[i] = SPACE;
                parts[i + 1] = operatorStr;
                parts[i + 2] = SPACE;
                crit = iter.next();
                parts[i + 3] = "(";
                parts[i + 4] = this.registerNode(crit);
                parts[i + 5] = ")";
                i += 6;
            }
            this.replaceStringParts(parts);
        }
    }

    @Override
    public void visit(Delete obj) {
        this.parts.add("DELETE");
        this.parts.add(SPACE);
        this.parts.add("FROM");
        this.parts.add(SPACE);
        this.parts.add(this.registerNode(obj.getGroup()));
        if (obj.getCriteria() != null) {
            this.parts.add(SPACE);
            this.parts.add("WHERE");
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getCriteria()));
        }
        if (obj.getOption() != null) {
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getOption()));
        }
    }

    @Override
    public void visit(DependentSetCriteria obj) {
        this.parts.add(this.registerNode(obj.getExpression()));
        this.parts.add(SPACE);
        if (obj.isNegated()) {
            this.parts.add("NOT");
            this.parts.add(SPACE);
        }
        this.parts.add("IN");
        this.parts.add(" (<dependent values>)");
    }

    @Override
    public void visit(From obj) {
        Object[] parts = null;
        List clauses = obj.getClauses();
        if (clauses.size() == 1) {
            this.replaceStringParts(new Object[]{"FROM", SPACE, this.registerNode((FromClause)clauses.get(0))});
        } else if (clauses.size() > 1) {
            parts = new Object[2 + clauses.size() + (clauses.size() - 1)];
            parts[0] = "FROM";
            parts[1] = SPACE;
            Iterator clauseIter = clauses.iterator();
            parts[2] = this.registerNode((FromClause)clauseIter.next());
            int i = 3;
            while (clauseIter.hasNext()) {
                parts[i] = ", ";
                parts[i + 1] = this.registerNode((FromClause)clauseIter.next());
                i += 2;
            }
            this.replaceStringParts(parts);
        } else {
            this.replaceStringParts(new Object[]{"FROM"});
        }
    }

    @Override
    public void visit(GroupBy obj) {
        Object[] parts = null;
        List symbols = obj.getSymbols();
        if (symbols.size() == 1) {
            this.replaceStringParts(new Object[]{"GROUP", SPACE, "BY", SPACE, this.registerNode((Expression)symbols.get(0))});
        } else if (symbols.size() > 1) {
            parts = new Object[4 + symbols.size() + (symbols.size() - 1)];
            parts[0] = "GROUP";
            parts[1] = SPACE;
            parts[2] = "BY";
            parts[3] = SPACE;
            Iterator symbolIter = symbols.iterator();
            parts[4] = this.registerNode((Expression)symbolIter.next());
            int i = 5;
            while (symbolIter.hasNext()) {
                parts[i] = ", ";
                parts[i + 1] = this.registerNode((Expression)symbolIter.next());
                i += 2;
            }
            this.replaceStringParts(parts);
        } else {
            this.replaceStringParts(new Object[]{"GROUP", SPACE, "BY"});
        }
    }

    @Override
    public void visit(Insert obj) {
        this.formatBasicInsert(obj);
        if (obj.getQueryExpression() != null) {
            this.parts.add(this.registerNode(obj.getQueryExpression()));
        } else if (obj.getTupleSource() != null) {
            this.parts.add("VALUES");
            this.parts.add(" (...)");
        } else {
            this.parts.add("VALUES");
            this.parts.add(" (");
            Iterator valueIter = obj.getValues().iterator();
            while (valueIter.hasNext()) {
                Expression valObj = (Expression)valueIter.next();
                this.parts.add(this.registerNode(valObj));
                if (!valueIter.hasNext()) continue;
                this.parts.add(", ");
            }
            this.parts.add(")");
        }
        if (obj.getOption() != null) {
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getOption()));
        }
    }

    @Override
    public void visit(Create obj) {
        this.parts.add("CREATE");
        this.parts.add(SPACE);
        this.parts.add("LOCAL");
        this.parts.add(SPACE);
        this.parts.add("TEMPORARY");
        this.parts.add(SPACE);
        this.parts.add("TABLE");
        this.parts.add(SPACE);
        this.parts.add(this.registerNode(obj.getTable()));
        this.parts.add(SPACE);
        List<ElementSymbol> columns = obj.getColumns();
        this.parts.add("(");
        Iterator<ElementSymbol> iter = columns.iterator();
        while (iter.hasNext()) {
            ElementSymbol element = iter.next();
            this.outputShortName(element);
            this.parts.add(SPACE);
            this.parts.add(DataTypeManager.getDataTypeName((Class)element.getType()));
            if (!iter.hasNext()) continue;
            this.parts.add(", ");
        }
        if (!obj.getPrimaryKey().isEmpty()) {
            this.parts.add(", ");
            this.parts.add("PRIMARY");
            this.parts.add(SPACE);
            this.parts.add("KEY");
            this.parts.add("(");
            iter = obj.getPrimaryKey().iterator();
            while (iter.hasNext()) {
                this.outputShortName(iter.next());
                if (!iter.hasNext()) continue;
                this.parts.add(", ");
            }
            this.parts.add(")");
        }
        this.parts.add(")");
    }

    @Override
    public void visit(Drop obj) {
        this.parts.add("DROP");
        this.parts.add(SPACE);
        this.parts.add("TABLE");
        this.parts.add(SPACE);
        this.parts.add(this.registerNode(obj.getTable()));
    }

    private void formatBasicInsert(Insert obj) {
        List vars;
        this.parts.add("INSERT");
        this.parts.add(SPACE);
        this.parts.add("INTO");
        this.parts.add(SPACE);
        this.parts.add(this.registerNode(obj.getGroup()));
        this.parts.add(SPACE);
        if (!obj.getVariables().isEmpty() && (vars = obj.getVariables()) != null) {
            this.parts.add("(");
            Iterator iter = vars.iterator();
            while (iter.hasNext()) {
                ElementSymbol element = (ElementSymbol)iter.next();
                this.parts.add(this.registerNode(element));
                if (!iter.hasNext()) continue;
                this.parts.add(", ");
            }
            this.parts.add(") ");
        }
    }

    @Override
    public void visit(IsNullCriteria obj) {
        Expression expr = obj.getExpression();
        List<Object> exprPart = this.registerNode(expr);
        this.parts.add(exprPart);
        this.parts.add(SPACE);
        this.parts.add("IS");
        this.parts.add(SPACE);
        if (obj.isNegated()) {
            this.parts.add("NOT");
            this.parts.add(SPACE);
        }
        this.parts.add("NULL");
    }

    @Override
    public void visit(JoinPredicate obj) {
        FromClause leftClause;
        this.addOptionComment(obj);
        if (obj.hasHint()) {
            this.parts.add("(");
        }
        if ((leftClause = obj.getLeftClause()) instanceof JoinPredicate && !((JoinPredicate)leftClause).hasHint()) {
            this.parts.add("(");
            this.parts.add(this.registerNode(leftClause));
            this.parts.add(")");
        } else {
            this.parts.add(this.registerNode(leftClause));
        }
        this.parts.add(SPACE);
        this.parts.add(this.registerNode(obj.getJoinType()));
        this.parts.add(SPACE);
        FromClause rightClause = obj.getRightClause();
        if (rightClause instanceof JoinPredicate && !((JoinPredicate)rightClause).hasHint()) {
            this.parts.add("(");
            this.parts.add(this.registerNode(rightClause));
            this.parts.add(")");
        } else {
            this.parts.add(this.registerNode(rightClause));
        }
        List joinCriteria = obj.getJoinCriteria();
        if (joinCriteria != null && joinCriteria.size() > 0) {
            this.parts.add(SPACE);
            this.parts.add("ON");
            this.parts.add(SPACE);
            Iterator critIter = joinCriteria.iterator();
            while (critIter.hasNext()) {
                Criteria crit = (Criteria)critIter.next();
                if (crit instanceof PredicateCriteria || crit instanceof AtomicCriteria) {
                    this.parts.add(this.registerNode(crit));
                } else {
                    this.parts.add("(");
                    this.parts.add(this.registerNode(crit));
                    this.parts.add(")");
                }
                if (!critIter.hasNext()) continue;
                this.parts.add(SPACE);
                this.parts.add("AND");
                this.parts.add(SPACE);
            }
        }
        if (obj.hasHint()) {
            this.parts.add(")");
        }
        this.addFromClasueDepOptions(obj);
    }

    private void addFromClasueDepOptions(FromClause obj) {
        if (obj.isMakeDep()) {
            this.parts.add(SPACE);
            this.parts.add("MAKEDEP");
        }
        if (obj.isMakeNotDep()) {
            this.parts.add(SPACE);
            this.parts.add("MAKENOTDEP");
        }
    }

    private void addOptionComment(FromClause obj) {
        if (obj.isOptional()) {
            this.parts.add(BEGIN_HINT);
            this.parts.add(SPACE);
            this.parts.add("optional");
            this.parts.add(SPACE);
            this.parts.add(END_HINT);
            this.parts.add(SPACE);
        }
    }

    @Override
    public void visit(JoinType obj) {
        Object[] parts = null;
        if (obj.equals(JoinType.JOIN_INNER)) {
            parts = new Object[]{"INNER", SPACE, "JOIN"};
        } else if (obj.equals(JoinType.JOIN_CROSS)) {
            parts = new Object[]{"CROSS", SPACE, "JOIN"};
        } else if (obj.equals(JoinType.JOIN_LEFT_OUTER)) {
            parts = new Object[]{"LEFT", SPACE, "OUTER", SPACE, "JOIN"};
        } else if (obj.equals(JoinType.JOIN_RIGHT_OUTER)) {
            parts = new Object[]{"RIGHT", SPACE, "OUTER", SPACE, "JOIN"};
        } else if (obj.equals(JoinType.JOIN_FULL_OUTER)) {
            parts = new Object[]{"FULL", SPACE, "OUTER", SPACE, "JOIN"};
        } else if (obj.equals(JoinType.JOIN_UNION)) {
            parts = new Object[]{"UNION", SPACE, "JOIN"};
        } else if (obj.equals(JoinType.JOIN_SEMI)) {
            parts = new Object[]{"SEMI", SPACE, "JOIN"};
        } else if (obj.equals(JoinType.JOIN_ANTI_SEMI)) {
            parts = new Object[]{"ANTI SEMI", SPACE, "JOIN"};
        }
        this.replaceStringParts(parts);
    }

    @Override
    public void visit(MatchCriteria obj) {
        this.parts.add(this.registerNode(obj.getLeftExpression()));
        this.parts.add(SPACE);
        if (obj.isNegated()) {
            this.parts.add("NOT");
            this.parts.add(SPACE);
        }
        this.parts.add("LIKE");
        this.parts.add(SPACE);
        this.parts.add(this.registerNode(obj.getRightExpression()));
        if (obj.getEscapeChar() != '\u0000') {
            this.parts.add(SPACE);
            this.parts.add("ESCAPE");
            this.parts.add(" '");
            this.parts.add("" + obj.getEscapeChar());
            this.parts.add("'");
        }
    }

    @Override
    public void visit(NotCriteria obj) {
        this.parts.add("NOT");
        this.parts.add(" (");
        this.parts.add(this.registerNode(obj.getCriteria()));
        this.parts.add(")");
    }

    @Override
    public void visit(Option obj) {
        Iterator iter;
        this.parts.add("OPTION");
        List<String> groups = obj.getDependentGroups();
        if (groups != null && groups.size() > 0) {
            this.parts.add(SPACE);
            this.parts.add("MAKEDEP");
            this.parts.add(SPACE);
            iter = groups.iterator();
            while (iter.hasNext()) {
                this.outputDisplayName((String)iter.next());
                if (!iter.hasNext()) continue;
                this.parts.add(", ");
            }
        }
        if ((groups = obj.getNotDependentGroups()) != null && groups.size() > 0) {
            this.parts.add(SPACE);
            this.parts.add("MAKENOTDEP");
            this.parts.add(SPACE);
            iter = groups.iterator();
            while (iter.hasNext()) {
                this.outputDisplayName((String)iter.next());
                if (!iter.hasNext()) continue;
                this.parts.add(", ");
            }
        }
        if ((groups = obj.getNoCacheGroups()) != null && groups.size() > 0) {
            this.parts.add(SPACE);
            this.parts.add("NOCACHE");
            this.parts.add(SPACE);
            iter = groups.iterator();
            while (iter.hasNext()) {
                this.outputDisplayName((String)iter.next());
                if (!iter.hasNext()) continue;
                this.parts.add(", ");
            }
        } else if (obj.isNoCache()) {
            this.parts.add(SPACE);
            this.parts.add("NOCACHE");
        }
    }

    @Override
    public void visit(OrderBy obj) {
        this.parts.add("ORDER");
        this.parts.add(SPACE);
        this.parts.add("BY");
        this.parts.add(SPACE);
        Iterator<OrderByItem> iterator = obj.getOrderByItems().iterator();
        while (iterator.hasNext()) {
            OrderByItem item = iterator.next();
            this.parts.add(this.registerNode(item));
            if (!iterator.hasNext()) continue;
            this.parts.add(", ");
        }
    }

    @Override
    public void visit(OrderByItem obj) {
        SingleElementSymbol ses = obj.getSymbol();
        if (ses instanceof AliasSymbol) {
            AliasSymbol as = (AliasSymbol)ses;
            this.outputDisplayName(as.getOutputName());
        } else {
            this.parts.add(this.registerNode(ses));
        }
        if (!obj.isAscending()) {
            this.parts.add(SPACE);
            this.parts.add("DESC");
        }
        if (obj.getNullOrdering() != null) {
            this.parts.add(SPACE);
            this.parts.add("NULLS");
            this.parts.add(SPACE);
            this.parts.add(obj.getNullOrdering().name());
        }
    }

    @Override
    public void visit(DynamicCommand obj) {
        this.parts.add("EXECUTE");
        this.parts.add(SPACE);
        this.parts.add("STRING");
        this.parts.add(SPACE);
        this.parts.add(this.registerNode(obj.getSql()));
        if (obj.isAsClauseSet()) {
            this.parts.add(SPACE);
            this.parts.add("AS");
            this.parts.add(SPACE);
            for (int i = 0; i < obj.getAsColumns().size(); ++i) {
                ElementSymbol symbol = (ElementSymbol)obj.getAsColumns().get(i);
                this.outputShortName(symbol);
                this.parts.add(SPACE);
                this.parts.add(DataTypeManager.getDataTypeName((Class)symbol.getType()));
                if (i >= obj.getAsColumns().size() - 1) continue;
                this.parts.add(", ");
            }
        }
        if (obj.getIntoGroup() != null) {
            this.parts.add(SPACE);
            this.parts.add("INTO");
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getIntoGroup()));
        }
        if (obj.getUsing() != null && !obj.getUsing().isEmpty()) {
            this.parts.add(SPACE);
            this.parts.add("USING");
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getUsing()));
        }
        if (obj.getUpdatingModelCount() > 0) {
            this.parts.add(SPACE);
            this.parts.add("UPDATE");
            this.parts.add(SPACE);
            if (obj.getUpdatingModelCount() > 1) {
                this.parts.add("*");
            } else {
                this.parts.add("1");
            }
        }
    }

    @Override
    public void visit(SetClauseList obj) {
        Iterator<SetClause> iterator = obj.getClauses().iterator();
        while (iterator.hasNext()) {
            SetClause clause = iterator.next();
            this.parts.add(this.registerNode(clause));
            if (!iterator.hasNext()) continue;
            this.parts.add(", ");
        }
    }

    @Override
    public void visit(SetClause obj) {
        ElementSymbol symbol = obj.getSymbol();
        this.outputShortName(symbol);
        this.parts.add(" = ");
        this.parts.add(this.registerNode(obj.getValue()));
    }

    @Override
    public void visit(Query obj) {
        this.addCacheHint(obj.getCacheHint());
        this.parts.add(this.registerNode(obj.getSelect()));
        if (obj.getInto() != null) {
            this.parts.add(SPACE);
            this.parts.add("INTO");
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getInto()));
        }
        if (obj.getFrom() != null) {
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getFrom()));
        }
        if (obj.getCriteria() != null) {
            this.parts.add(SPACE);
            this.parts.add("WHERE");
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getCriteria()));
        }
        if (obj.getGroupBy() != null) {
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getGroupBy()));
        }
        if (obj.getHaving() != null) {
            this.parts.add(SPACE);
            this.parts.add("HAVING");
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getHaving()));
        }
        if (obj.getOrderBy() != null) {
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getOrderBy()));
        }
        if (obj.getLimit() != null) {
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getLimit()));
        }
        if (obj.getOption() != null) {
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getOption()));
        }
    }

    @Override
    public void visit(SearchedCaseExpression obj) {
        this.parts.add("CASE");
        for (int i = 0; i < obj.getWhenCount(); ++i) {
            this.parts.add(SPACE);
            this.parts.add("WHEN");
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getWhenCriteria(i)));
            this.parts.add(SPACE);
            this.parts.add("THEN");
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getThenExpression(i)));
        }
        this.parts.add(SPACE);
        if (obj.getElseExpression() != null) {
            this.parts.add("ELSE");
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getElseExpression()));
            this.parts.add(SPACE);
        }
        this.parts.add("END");
    }

    @Override
    public void visit(Select obj) {
        this.parts.add("SELECT");
        this.parts.add(SPACE);
        if (obj.isDistinct()) {
            this.parts.add("DISTINCT");
            this.parts.add(SPACE);
        }
        Iterator iter = obj.getSymbols().iterator();
        while (iter.hasNext()) {
            SelectSymbol symbol = (SelectSymbol)iter.next();
            this.parts.add(this.registerNode(symbol));
            if (!iter.hasNext()) continue;
            this.parts.add(", ");
        }
    }

    @Override
    public void visit(SetCriteria obj) {
        this.parts.add(this.registerNode(obj.getExpression()));
        this.parts.add(SPACE);
        if (obj.isNegated()) {
            this.parts.add("NOT");
            this.parts.add(SPACE);
        }
        this.parts.add("IN");
        this.parts.add(" (");
        Collection vals = obj.getValues();
        int size = vals.size();
        if (size == 1) {
            Iterator iter = vals.iterator();
            Expression expr = (Expression)iter.next();
            this.parts.add(this.registerNode(expr));
        } else if (size > 1) {
            Iterator iter = vals.iterator();
            Expression expr = (Expression)iter.next();
            this.parts.add(this.registerNode(expr));
            while (iter.hasNext()) {
                expr = (Expression)iter.next();
                this.parts.add(", ");
                this.parts.add(this.registerNode(expr));
            }
        }
        this.parts.add(")");
    }

    @Override
    public void visit(SetQuery obj) {
        this.addCacheHint(obj.getCacheHint());
        QueryCommand query = obj.getLeftQuery();
        if (query instanceof Query) {
            this.parts.add(this.registerNode(query));
        } else {
            this.parts.add("(");
            this.parts.add(this.registerNode(query));
            this.parts.add(")");
        }
        this.parts.add(SPACE);
        this.parts.add((Object)obj.getOperation());
        this.parts.add(SPACE);
        if (obj.isAll()) {
            this.parts.add("ALL");
            this.parts.add(SPACE);
        }
        if ((query = obj.getRightQuery()) instanceof Query) {
            this.parts.add(this.registerNode(query));
        } else {
            this.parts.add("(");
            this.parts.add(this.registerNode(query));
            this.parts.add(")");
        }
        if (obj.getOrderBy() != null) {
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getOrderBy()));
        }
        if (obj.getLimit() != null) {
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getLimit()));
        }
        if (obj.getOption() != null) {
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getOption()));
        }
    }

    @Override
    public void visit(StoredProcedure obj) {
        this.addCacheHint(obj.getCacheHint());
        this.parts.add("EXEC");
        this.parts.add(SPACE);
        this.parts.add(obj.getProcedureName());
        this.parts.add("(");
        List<SPParameter> params = obj.getInputParameters();
        if (params != null) {
            Iterator<SPParameter> iter = params.iterator();
            while (iter.hasNext()) {
                SPParameter param = iter.next();
                if (obj.displayNamedParameters()) {
                    this.parts.add(SQLStringVisitor.escapeSinglePart(ElementSymbol.getShortName(param.getParameterSymbol().getOutputName())));
                    this.parts.add(" => ");
                }
                if (param.getExpression() == null) {
                    if (param.getName() != null) {
                        this.outputDisplayName(obj.getParamFullName(param));
                    } else {
                        this.parts.add("?");
                    }
                } else {
                    boolean addParens;
                    boolean bl = addParens = !obj.displayNamedParameters() && param.getExpression() instanceof CompareCriteria;
                    if (addParens) {
                        this.parts.add("(");
                    }
                    this.parts.add(this.registerNode(param.getExpression()));
                    if (addParens) {
                        this.parts.add(")");
                    }
                }
                if (!iter.hasNext()) continue;
                this.parts.add(", ");
            }
        }
        this.parts.add(")");
        if (obj.getOption() != null) {
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getOption()));
        } else {
            this.parts.add("");
        }
    }

    public void addCacheHint(CacheHint obj) {
        if (obj == null) {
            return;
        }
        this.parts.add(BEGIN_HINT);
        this.parts.add(SPACE);
        this.parts.add("cache");
        boolean addParens = false;
        if (obj.getPrefersMemory()) {
            this.parts.add("(");
            addParens = true;
            this.parts.add("pref_mem");
        }
        if (obj.getTtl() != null) {
            if (!addParens) {
                this.parts.add("(");
                addParens = true;
            } else {
                this.parts.add(SPACE);
            }
            this.parts.add("ttl:");
            this.parts.add(obj.getTtl());
        }
        if (obj.isUpdatable()) {
            if (!addParens) {
                this.parts.add("(");
                addParens = true;
            } else {
                this.parts.add(SPACE);
            }
            this.parts.add("updatable");
        }
        if (addParens) {
            this.parts.add(")");
        }
        this.parts.add(SPACE);
        this.parts.add(END_HINT);
        this.parts.add(SPACE);
    }

    @Override
    public void visit(SubqueryFromClause obj) {
        this.addOptionComment(obj);
        if (obj.isTable()) {
            this.parts.add("TABLE");
        }
        this.parts.add("(");
        this.parts.add(this.registerNode(obj.getCommand()));
        this.parts.add(")");
        this.parts.add(" AS ");
        this.parts.add(obj.getOutputName());
        this.addFromClasueDepOptions(obj);
    }

    @Override
    public void visit(SubquerySetCriteria obj) {
        this.parts.add(this.registerNode(obj.getExpression()));
        this.parts.add(SPACE);
        if (obj.isNegated()) {
            this.parts.add("NOT");
            this.parts.add(SPACE);
        }
        this.parts.add("IN");
        this.parts.add(" (");
        this.parts.add(this.registerNode(obj.getCommand()));
        this.parts.add(")");
    }

    @Override
    public void visit(UnaryFromClause obj) {
        this.addOptionComment(obj);
        this.parts.add(this.registerNode(obj.getGroup()));
        this.addFromClasueDepOptions(obj);
    }

    @Override
    public void visit(Update obj) {
        this.parts.add("UPDATE");
        this.parts.add(SPACE);
        this.parts.add(this.registerNode(obj.getGroup()));
        this.parts.add(SPACE);
        this.parts.add("SET");
        this.parts.add(SPACE);
        this.parts.add(this.registerNode(obj.getChangeList()));
        if (obj.getCriteria() != null) {
            this.parts.add(SPACE);
            this.parts.add("WHERE");
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getCriteria()));
        }
        if (obj.getOption() != null) {
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getOption()));
        }
    }

    @Override
    public void visit(Into obj) {
        this.parts.add(this.registerNode(obj.getGroup()));
    }

    @Override
    public void visit(AggregateSymbol obj) {
        this.parts.add(obj.getAggregateFunction().name());
        this.parts.add("(");
        if (obj.isDistinct()) {
            this.parts.add("DISTINCT");
            this.parts.add(SPACE);
        }
        if (obj.getExpression() == null) {
            this.parts.add("*");
        } else {
            this.parts.add(this.registerNode(obj.getExpression()));
        }
        if (obj.getOrderBy() != null) {
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getOrderBy()));
        }
        this.parts.add(")");
    }

    @Override
    public void visit(AliasSymbol obj) {
        this.parts.add(this.registerNode(obj.getSymbol()));
        this.parts.add(SPACE);
        this.parts.add("AS");
        this.parts.add(SPACE);
        this.parts.add(SQLStringVisitor.escapeSinglePart(obj.getOutputName()));
    }

    @Override
    public void visit(AllInGroupSymbol obj) {
        this.parts.add(obj.getName());
    }

    @Override
    public void visit(AllSymbol obj) {
        this.parts.add(obj.getName());
    }

    @Override
    public void visit(Constant obj) {
        Class<?> type = obj.getType();
        Object[] constantParts = null;
        if (obj.isMultiValued()) {
            constantParts = new Object[]{"?"};
        } else if (obj.isNull()) {
            constantParts = type.equals(DataTypeManager.DefaultDataClasses.BOOLEAN) ? new Object[]{"UNKNOWN"} : new Object[]{"null"};
        } else {
            if (Number.class.isAssignableFrom(type)) {
                constantParts = new Object[]{obj.getValue().toString()};
            } else if (type.equals(DataTypeManager.DefaultDataClasses.BOOLEAN)) {
                constantParts = new Object[]{obj.getValue().equals(Boolean.TRUE) ? "TRUE" : "FALSE"};
            } else if (type.equals(DataTypeManager.DefaultDataClasses.TIMESTAMP)) {
                constantParts = new Object[]{"{ts'", obj.getValue().toString(), "'}"};
            } else if (type.equals(DataTypeManager.DefaultDataClasses.TIME)) {
                constantParts = new Object[]{"{t'", obj.getValue().toString(), "'}"};
            } else if (type.equals(DataTypeManager.DefaultDataClasses.DATE)) {
                constantParts = new Object[]{"{d'", obj.getValue().toString(), "'}"};
            }
            if (constantParts == null) {
                String strValue = obj.getValue().toString();
                strValue = SQLStringVisitor.escapeStringValue(strValue, "'");
                constantParts = new Object[]{"'", strValue, "'"};
            }
        }
        this.replaceStringParts(constantParts);
    }

    static String escapeStringValue(String str, String tick) {
        return StringUtil.replaceAll((String)str, (String)tick, (String)(tick + tick));
    }

    @Override
    public void visit(ElementSymbol obj) {
        if (obj.getDisplayMode().equals((Object)ElementSymbol.DisplayMode.SHORT_OUTPUT_NAME)) {
            this.outputShortName(obj);
            return;
        }
        String name = obj.getOutputName();
        if (obj.getDisplayMode().equals((Object)ElementSymbol.DisplayMode.FULLY_QUALIFIED)) {
            name = obj.getName();
        }
        this.outputDisplayName(name);
    }

    private void outputShortName(ElementSymbol obj) {
        this.outputDisplayName(SingleElementSymbol.getShortName(obj.getOutputName()));
    }

    private void outputDisplayName(String name) {
        String[] pathParts = name.split("\\.");
        for (int i = 0; i < pathParts.length; ++i) {
            if (i > 0) {
                this.parts.add(".");
            }
            this.parts.add(SQLStringVisitor.escapeSinglePart(pathParts[i]));
        }
    }

    @Override
    public void visit(ExpressionSymbol obj) {
        this.parts.add(this.registerNode(obj.getExpression()));
    }

    @Override
    public void visit(Function obj) {
        String name = obj.getName();
        LanguageObject[] args = obj.getArgs();
        if (obj.isImplicit()) {
            this.parts.add(this.registerNode(args[0]));
        } else if (name.equalsIgnoreCase("CONVERT") || name.equalsIgnoreCase("CAST")) {
            this.parts.add(name);
            this.parts.add("(");
            if (args != null && args.length > 0) {
                this.parts.add(this.registerNode(args[0]));
                if (name.equalsIgnoreCase("CONVERT")) {
                    this.parts.add(", ");
                } else {
                    this.parts.add(SPACE);
                    this.parts.add("AS");
                    this.parts.add(SPACE);
                }
                if (args.length < 2 || args[1] == null || !(args[1] instanceof Constant)) {
                    this.parts.add(UNDEFINED);
                } else {
                    this.parts.add(((Constant)args[1]).getValue());
                }
            }
            this.parts.add(")");
        } else if (name.equals("+") || name.equals("-") || name.equals("*") || name.equals("/") || name.equals("||")) {
            this.parts.add("(");
            if (args != null) {
                for (int i = 0; i < args.length; ++i) {
                    this.parts.add(this.registerNode(args[i]));
                    if (i >= args.length - 1) continue;
                    this.parts.add(SPACE);
                    this.parts.add(name);
                    this.parts.add(SPACE);
                }
            }
            this.parts.add(")");
        } else if (name.equalsIgnoreCase("TIMESTAMPADD") || name.equalsIgnoreCase("TIMESTAMPDIFF")) {
            this.parts.add(name);
            this.parts.add("(");
            if (args != null && args.length > 0) {
                this.parts.add(((Constant)args[0]).getValue());
                this.registerNodes(args, 1);
            }
            this.parts.add(")");
        } else if (name.equalsIgnoreCase("xmlpi")) {
            this.parts.add(name);
            this.parts.add("(NAME ");
            this.outputDisplayName((String)((Constant)args[0]).getValue());
            this.registerNodes(args, 1);
            this.parts.add(")");
        } else {
            this.parts.add(name);
            this.parts.add("(");
            this.registerNodes(args, 0);
            this.parts.add(")");
        }
    }

    private void registerNodes(LanguageObject[] objects, int begin) {
        this.registerNodes(Arrays.asList(objects), begin);
    }

    private void registerNodes(List<? extends LanguageObject> objects, int begin) {
        for (int i = begin; i < objects.size(); ++i) {
            if (i > 0) {
                this.parts.add(", ");
            }
            this.parts.add(this.registerNode(objects.get(i)));
        }
    }

    @Override
    public void visit(GroupSymbol obj) {
        String alias = null;
        String fullGroup = obj.getOutputName();
        if (obj.getOutputDefinition() != null) {
            alias = obj.getOutputName();
            fullGroup = obj.getOutputDefinition();
        }
        this.outputDisplayName(fullGroup);
        if (alias != null) {
            this.parts.add(SPACE);
            this.parts.add("AS");
            this.parts.add(SPACE);
            this.parts.add(SQLStringVisitor.escapeSinglePart(alias));
        }
    }

    @Override
    public void visit(Reference obj) {
        if (!obj.isPositional() && obj.getExpression() != null) {
            this.replaceStringParts(new Object[]{obj.getExpression().toString()});
        } else {
            this.replaceStringParts(new Object[]{"?"});
        }
    }

    @Override
    public void visit(Block obj) {
        List<Statement> statements = obj.getStatements();
        if (statements.size() == 1) {
            this.replaceStringParts(new Object[]{"BEGIN", "\n", this.registerNode(obj.getStatements().get(0)), "\n", "END"});
        } else if (statements.size() > 1) {
            ArrayList<Object> parts = new ArrayList<Object>();
            parts.add("BEGIN");
            parts.add("\n");
            Iterator<Statement> stmtIter = statements.iterator();
            while (stmtIter.hasNext()) {
                parts.add(this.registerNode(stmtIter.next()));
                parts.add("\n");
            }
            parts.add("END");
            this.replaceStringParts(parts.toArray());
        } else {
            this.replaceStringParts(new Object[]{"BEGIN", "\n", "END"});
        }
    }

    @Override
    public void visit(CommandStatement obj) {
        this.parts.add(this.registerNode(obj.getCommand()));
        this.parts.add(";");
    }

    @Override
    public void visit(CreateUpdateProcedureCommand obj) {
        this.parts.add("CREATE");
        this.parts.add(SPACE);
        if (!obj.isUpdateProcedure()) {
            this.parts.add("VIRTUAL");
            this.parts.add(SPACE);
        }
        this.parts.add("PROCEDURE");
        this.parts.add("\n");
        this.parts.add(this.registerNode(obj.getBlock()));
    }

    @Override
    public void visit(DeclareStatement obj) {
        this.parts.add("DECLARE");
        this.parts.add(SPACE);
        this.parts.add(obj.getVariableType());
        this.parts.add(SPACE);
        this.createAssignment(obj);
    }

    private void createAssignment(AssignmentStatement obj) {
        this.parts.add(this.registerNode(obj.getVariable()));
        if (obj.getValue() != null) {
            this.parts.add(" = ");
            this.addStatementArgument(obj.getExpression());
        }
        this.parts.add(";");
    }

    private void addStatementArgument(Expression expr) {
        if (expr instanceof ScalarSubquery) {
            this.parts.add(this.registerNode(((ScalarSubquery)expr).getCommand()));
        } else {
            this.parts.add(this.registerNode(expr));
        }
    }

    @Override
    public void visit(IfStatement obj) {
        this.parts.add("IF");
        this.parts.add("(");
        this.parts.add(this.registerNode(obj.getCondition()));
        this.parts.add(")\n");
        this.parts.add(this.registerNode(obj.getIfBlock()));
        if (obj.hasElseBlock()) {
            this.parts.add("\n");
            this.parts.add("ELSE");
            this.parts.add("\n");
            this.parts.add(this.registerNode(obj.getElseBlock()));
        }
    }

    @Override
    public void visit(AssignmentStatement obj) {
        this.createAssignment(obj);
    }

    @Override
    public void visit(HasCriteria obj) {
        this.parts.add("HAS");
        this.parts.add(SPACE);
        this.parts.add(this.registerNode(obj.getSelector()));
    }

    @Override
    public void visit(TranslateCriteria obj) {
        this.parts.add("TRANSLATE");
        this.parts.add(SPACE);
        this.parts.add(this.registerNode(obj.getSelector()));
        if (obj.hasTranslations()) {
            this.parts.add(SPACE);
            this.parts.add("WITH");
            this.parts.add(SPACE);
            this.parts.add("(");
            Iterator critIter = obj.getTranslations().iterator();
            while (critIter.hasNext()) {
                this.parts.add(this.registerNode((Criteria)critIter.next()));
                if (critIter.hasNext()) {
                    this.parts.add(", ");
                }
                if (critIter.hasNext()) continue;
                this.parts.add(")");
            }
        }
    }

    @Override
    public void visit(CriteriaSelector obj) {
        int selectorType = obj.getSelectorType();
        switch (selectorType) {
            case 1: {
                this.parts.add("= ");
                break;
            }
            case 6: {
                this.parts.add(">= ");
                break;
            }
            case 4: {
                this.parts.add("> ");
                break;
            }
            case 5: {
                this.parts.add("<= ");
                break;
            }
            case 3: {
                this.parts.add("< ");
                break;
            }
            case 2: {
                this.parts.add("<> ");
                break;
            }
            case 8: {
                this.parts.add("IN");
                this.parts.add(SPACE);
                break;
            }
            case 9: {
                this.parts.add("IS");
                this.parts.add(SPACE);
                this.parts.add("NULL");
                this.parts.add(SPACE);
                break;
            }
            case 7: {
                this.parts.add("LIKE");
                this.parts.add(SPACE);
                break;
            }
            case 10: {
                this.parts.add("BETWEEN");
                this.parts.add(SPACE);
            }
        }
        this.parts.add("CRITERIA");
        if (obj.hasElements()) {
            this.parts.add(SPACE);
            this.parts.add("ON");
            this.parts.add(SPACE);
            this.parts.add("(");
            Iterator elmtIter = obj.getElements().iterator();
            while (elmtIter.hasNext()) {
                this.parts.add(this.registerNode((ElementSymbol)elmtIter.next()));
                if (!elmtIter.hasNext()) continue;
                this.parts.add(", ");
            }
            this.parts.add(")");
        }
    }

    @Override
    public void visit(RaiseErrorStatement obj) {
        this.parts.add("ERROR");
        this.parts.add(SPACE);
        this.addStatementArgument(obj.getExpression());
        this.parts.add(";");
    }

    @Override
    public void visit(BreakStatement obj) {
        this.parts.add("BREAK");
        this.parts.add(";");
    }

    @Override
    public void visit(ContinueStatement obj) {
        this.parts.add("CONTINUE");
        this.parts.add(";");
    }

    @Override
    public void visit(LoopStatement obj) {
        this.parts.add("LOOP");
        this.parts.add(SPACE);
        this.parts.add("ON");
        this.parts.add(" (");
        this.parts.add(this.registerNode(obj.getCommand()));
        this.parts.add(") ");
        this.parts.add("AS");
        this.parts.add(SPACE);
        this.parts.add(obj.getCursorName());
        this.parts.add("\n");
        this.parts.add(this.registerNode(obj.getBlock()));
    }

    @Override
    public void visit(WhileStatement obj) {
        this.parts.add("WHILE");
        this.parts.add("(");
        this.parts.add(this.registerNode(obj.getCondition()));
        this.parts.add(")\n");
        this.parts.add(this.registerNode(obj.getBlock()));
    }

    @Override
    public void visit(ExistsCriteria obj) {
        this.parts.add("EXISTS");
        this.parts.add(" (");
        this.parts.add(this.registerNode(obj.getCommand()));
        this.parts.add(")");
    }

    @Override
    public void visit(SubqueryCompareCriteria obj) {
        Expression leftExpression = obj.getLeftExpression();
        this.parts.add(this.registerNode(leftExpression));
        String operator = obj.getOperatorAsString();
        String quantifier = obj.getPredicateQuantifierAsString();
        this.parts.add(SPACE);
        this.parts.add(operator);
        this.parts.add(SPACE);
        this.parts.add(quantifier);
        this.parts.add("(");
        this.parts.add(this.registerNode(obj.getCommand()));
        this.parts.add(")");
    }

    @Override
    public void visit(ScalarSubquery obj) {
        this.parts.add("(");
        this.parts.add(this.registerNode(obj.getCommand()));
        this.parts.add(")");
    }

    @Override
    public void visit(XMLAttributes obj) {
        this.parts.add("XMLATTRIBUTES");
        this.parts.add("(");
        this.registerNodes(obj.getArgs(), 0);
        this.parts.add(")");
    }

    @Override
    public void visit(XMLElement obj) {
        this.parts.add("XMLELEMENT");
        this.parts.add("(NAME ");
        this.outputDisplayName(obj.getName());
        if (obj.getNamespaces() != null) {
            this.parts.add(", ");
            this.parts.add(this.registerNode(obj.getNamespaces()));
        }
        if (obj.getAttributes() != null) {
            this.parts.add(", ");
            this.parts.add(this.registerNode(obj.getAttributes()));
        }
        if (!obj.getContent().isEmpty()) {
            this.parts.add(", ");
        }
        this.registerNodes(obj.getContent(), 0);
        this.parts.add(")");
    }

    @Override
    public void visit(XMLForest obj) {
        this.parts.add("XMLFOREST");
        this.parts.add("(");
        if (obj.getNamespaces() != null) {
            this.parts.add(this.registerNode(obj.getNamespaces()));
            this.parts.add(", ");
        }
        this.registerNodes(obj.getArgs(), 0);
        this.parts.add(")");
    }

    @Override
    public void visit(XMLNamespaces obj) {
        this.parts.add("XMLNAMESPACES");
        this.parts.add("(");
        Iterator<XMLNamespaces.NamespaceItem> items = obj.getNamespaceItems().iterator();
        while (items.hasNext()) {
            XMLNamespaces.NamespaceItem item = items.next();
            if (item.getPrefix() == null) {
                if (item.getUri() == null) {
                    this.parts.add("NO DEFAULT");
                } else {
                    this.parts.add("DEFAULT ");
                    this.parts.add(this.registerNode(new Constant(item.getUri())));
                }
            } else {
                this.parts.add(this.registerNode(new Constant(item.getUri())));
                this.parts.add(" AS ");
                this.outputDisplayName(item.getPrefix());
            }
            if (!items.hasNext()) continue;
            this.parts.add(", ");
        }
        this.parts.add(")");
    }

    @Override
    public void visit(Limit obj) {
        this.parts.add("LIMIT");
        if (obj.getOffset() != null) {
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(obj.getOffset()));
            this.parts.add(",");
        }
        this.parts.add(SPACE);
        this.parts.add(this.registerNode(obj.getRowLimit()));
    }

    @Override
    public void visit(TextTable obj) {
        this.parts.add("TEXTTABLE(");
        this.parts.add(this.registerNode(obj.getFile()));
        this.parts.add(SPACE);
        this.parts.add("COLUMNS");
        Iterator<TextTable.TextColumn> cols = obj.getColumns().iterator();
        while (cols.hasNext()) {
            TextTable.TextColumn col = cols.next();
            this.parts.add(SPACE);
            this.outputDisplayName(col.getName());
            this.parts.add(SPACE);
            this.parts.add(col.getType());
            if (col.getWidth() != null) {
                this.parts.add(SPACE);
                this.parts.add("WIDTH");
                this.parts.add(SPACE);
                this.parts.add(col.getWidth());
            }
            if (!cols.hasNext()) continue;
            this.parts.add(",");
        }
        if (obj.getDelimiter() != null) {
            this.parts.add(SPACE);
            this.parts.add("DELIMITER");
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(new Constant(obj.getDelimiter())));
        }
        if (obj.getQuote() != null) {
            this.parts.add(SPACE);
            if (obj.isEscape()) {
                this.parts.add("ESCAPE");
            } else {
                this.parts.add("QUOTE");
            }
            this.parts.add(SPACE);
            this.parts.add(this.registerNode(new Constant(obj.getQuote())));
        }
        if (obj.getHeader() != null) {
            this.parts.add(SPACE);
            this.parts.add("HEADER");
            if (1 != obj.getHeader()) {
                this.parts.add(SPACE);
                this.parts.add(obj.getHeader());
            }
        }
        if (obj.getSkip() != null) {
            this.parts.add(SPACE);
            this.parts.add("SKIP");
            this.parts.add(SPACE);
            this.parts.add(obj.getSkip());
        }
        this.parts.add(")");
        this.parts.add(SPACE);
        this.parts.add("AS");
        this.parts.add(SPACE);
        this.outputDisplayName(obj.getName());
    }

    @Override
    public void visit(XMLTable obj) {
        this.parts.add("XMLTABLE(");
        if (obj.getNamespaces() != null) {
            this.parts.add(this.registerNode(obj.getNamespaces()));
            this.parts.add(",");
            this.parts.add(SPACE);
        }
        this.parts.add(new Constant(obj.getXquery()));
        if (!obj.getPassing().isEmpty()) {
            this.parts.add(SPACE);
            this.parts.add("PASSING");
            this.parts.add(SPACE);
            this.registerNodes(obj.getPassing(), 0);
        }
        if (!obj.getColumns().isEmpty()) {
            this.parts.add(SPACE);
            this.parts.add("COLUMNS");
            Iterator<XMLTable.XMLColumn> cols = obj.getColumns().iterator();
            while (cols.hasNext()) {
                XMLTable.XMLColumn col = cols.next();
                this.parts.add(SPACE);
                this.outputDisplayName(col.getName());
                this.parts.add(SPACE);
                if (col.isOrdinal()) {
                    this.parts.add("FOR");
                    this.parts.add(SPACE);
                    this.parts.add("ORDINALITY");
                } else {
                    this.parts.add(col.getType());
                    if (col.getDefaultExpression() != null) {
                        this.parts.add(SPACE);
                        this.parts.add("DEFAULT");
                        this.parts.add(SPACE);
                        this.parts.add(this.registerNode(col.getDefaultExpression()));
                    }
                    if (col.getPath() != null) {
                        this.parts.add(SPACE);
                        this.parts.add("PATH");
                        this.parts.add(SPACE);
                        this.parts.add(new Constant(col.getPath()));
                    }
                }
                if (!cols.hasNext()) continue;
                this.parts.add(",");
            }
        }
        this.parts.add(")");
        this.parts.add(SPACE);
        this.parts.add("AS");
        this.parts.add(SPACE);
        this.outputDisplayName(obj.getName());
    }

    @Override
    public void visit(XMLQuery obj) {
        this.parts.add("XMLQUERY(");
        if (obj.getNamespaces() != null) {
            this.parts.add(this.registerNode(obj.getNamespaces()));
            this.parts.add(",");
            this.parts.add(SPACE);
        }
        this.parts.add(new Constant(obj.getXquery()));
        if (!obj.getPassing().isEmpty()) {
            this.parts.add(SPACE);
            this.parts.add("PASSING");
            this.parts.add(SPACE);
            this.registerNodes(obj.getPassing(), 0);
        }
        if (obj.getEmptyOnEmpty() != null) {
            this.parts.add(SPACE);
            if (obj.getEmptyOnEmpty().booleanValue()) {
                this.parts.add("EMPTY");
            } else {
                this.parts.add("NULL");
            }
            this.parts.add(SPACE);
            this.parts.add("ON");
            this.parts.add(SPACE);
            this.parts.add("EMPTY");
        }
        this.parts.add(")");
    }

    @Override
    public void visit(DerivedColumn obj) {
        this.parts.add(this.registerNode(obj.getExpression()));
        if (obj.getAlias() != null) {
            this.parts.add(SPACE);
            this.parts.add("AS");
            this.parts.add(SPACE);
            this.outputDisplayName(obj.getAlias());
        }
    }

    @Override
    public void visit(XMLSerialize obj) {
        this.parts.add("XMLSERIALIZE");
        this.parts.add("(");
        if (obj.isDocument() != null) {
            if (obj.isDocument().booleanValue()) {
                this.parts.add("DOCUMENT");
            } else {
                this.parts.add("CONTENT");
            }
            this.parts.add(SPACE);
        }
        this.parts.add(this.registerNode(obj.getExpression()));
        if (obj.getTypeString() != null) {
            this.parts.add(SPACE);
            this.parts.add("AS");
            this.parts.add(SPACE);
            this.parts.add(obj.getTypeString());
        }
        this.parts.add(")");
    }

    @Override
    public void visit(QueryString obj) {
        this.parts.add("QUERYSTRING");
        this.parts.add("(");
        this.parts.add(this.registerNode(obj.getPath()));
        if (!obj.getArgs().isEmpty()) {
            this.parts.add(",");
            this.parts.add(SPACE);
            this.registerNodes(obj.getArgs(), 0);
        }
        this.parts.add(")");
    }

    @Override
    public void visit(XMLParse obj) {
        this.parts.add("XMLPARSE");
        this.parts.add("(");
        if (obj.isDocument()) {
            this.parts.add("DOCUMENT");
        } else {
            this.parts.add("CONTENT");
        }
        this.parts.add(SPACE);
        this.parts.add(this.registerNode(obj.getExpression()));
        if (obj.isWellFormed()) {
            this.parts.add(SPACE);
            this.parts.add("WELLFORMED");
        }
        this.parts.add(")");
    }

    @Override
    public void visit(ExpressionCriteria obj) {
        obj.getExpression().acceptVisitor(this);
    }

    public static String escapeSinglePart(String part) {
        if (SQLStringVisitor.isReservedWord(part)) {
            return '\"' + part + '\"';
        }
        boolean escape = true;
        char start = part.charAt(0);
        if (start == '#' || start == '@' || StringUtil.isLetter((char)start)) {
            escape = false;
            for (int i = 1; !escape && i < part.length(); ++i) {
                char c = part.charAt(i);
                escape = !StringUtil.isLetterOrDigit((char)c) && c != '_';
            }
        }
        if (escape) {
            return '\"' + SQLStringVisitor.escapeStringValue(part, "\"") + '\"';
        }
        return part;
    }

    static boolean isReservedWord(String string) {
        if (string == null) {
            return false;
        }
        return SQLConstants.isReservedWord((String)string);
    }
}

