/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.tempdata;

import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.teiid.query.sql.lang.CompareCriteria;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.IsNullCriteria;
import org.teiid.query.sql.lang.MatchCriteria;
import org.teiid.query.sql.lang.SetCriteria;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;

class IndexCondition {
    Constant lower = null;
    Constant upper = null;
    TreeSet<Constant> valueSet = new TreeSet();

    IndexCondition() {
    }

    static IndexCondition[] getIndexConditions(Criteria condition, List<ElementSymbol> keyColumns) {
        List<Criteria> crits = Criteria.separateCriteriaByAnd(condition);
        IndexCondition[] conditions = new IndexCondition[keyColumns.size()];
        for (int i = 0; i < conditions.length; ++i) {
            conditions[i] = new IndexCondition();
            ElementSymbol keyColumn = keyColumns.get(i);
            Iterator<Criteria> critIter = crits.iterator();
            while (critIter.hasNext()) {
                SetCriteria setCriteria;
                Criteria criteria = critIter.next();
                if (criteria instanceof CompareCriteria) {
                    CompareCriteria cc = (CompareCriteria)criteria;
                    if (cc.getOperator() == 2 || !(cc.getRightExpression() instanceof Constant)) {
                        critIter.remove();
                        continue;
                    }
                    if (!cc.getLeftExpression().equals(keyColumn)) continue;
                    conditions[i].addCondition((Constant)cc.getRightExpression(), cc.getOperator());
                    critIter.remove();
                    continue;
                }
                if (criteria instanceof IsNullCriteria) {
                    IsNullCriteria inc = (IsNullCriteria)criteria;
                    if (inc.isNegated() || !inc.getExpression().equals(keyColumn)) continue;
                    conditions[i].addCondition(new Constant(null), 1);
                    critIter.remove();
                    continue;
                }
                if (i > 0) {
                    critIter.remove();
                    continue;
                }
                if (criteria instanceof MatchCriteria) {
                    MatchCriteria matchCriteria = (MatchCriteria)criteria;
                    if (matchCriteria.isNegated() || !matchCriteria.getLeftExpression().equals(keyColumn) || !(matchCriteria.getRightExpression() instanceof Constant)) continue;
                    Constant value = (Constant)matchCriteria.getRightExpression();
                    String pattern = (String)value.getValue();
                    boolean escaped = false;
                    StringBuilder prefix = new StringBuilder();
                    int j = 0;
                    while (i < pattern.length()) {
                        char character = pattern.charAt(j);
                        if (character == matchCriteria.getEscapeChar() && character != '\u0000') {
                            if (escaped) {
                                prefix.append(character);
                                escaped = false;
                            } else {
                                escaped = true;
                            }
                        } else {
                            if (character == '%' || character == '_') break;
                            prefix.append(character);
                        }
                        ++j;
                    }
                    if (prefix.length() <= 0) continue;
                    conditions[i].addCondition(new Constant(prefix.toString()), 6);
                    continue;
                }
                if (!(criteria instanceof SetCriteria) || !(setCriteria = (SetCriteria)criteria).getExpression().equals(keyColumn) || !setCriteria.isAllConstants()) continue;
                TreeSet values = (TreeSet)setCriteria.getValues();
                conditions[i].addSet(values);
            }
        }
        return conditions;
    }

    void addCondition(Constant value, int comparisionMode) {
        switch (comparisionMode) {
            case 1: {
                this.valueSet.clear();
                this.valueSet.add(value);
                this.lower = null;
                this.upper = null;
                break;
            }
            case 4: 
            case 6: {
                if (!this.valueSet.isEmpty()) break;
                this.lower = value;
                break;
            }
            case 3: 
            case 5: {
                if (!this.valueSet.isEmpty()) break;
                this.upper = value;
            }
        }
    }

    void addSet(TreeSet<Constant> values) {
        if (!this.valueSet.isEmpty()) {
            return;
        }
        this.lower = null;
        this.upper = null;
        this.valueSet.addAll(values);
    }
}

