/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.validator;

import java.util.Map;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.metadata.TempMetadataStore;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.navigator.PreOrderNavigator;
import org.teiid.query.sql.visitor.CommandCollectorVisitor;
import org.teiid.query.validator.AbstractValidationVisitor;
import org.teiid.query.validator.ValidationVisitor;
import org.teiid.query.validator.ValidatorReport;

public class Validator {
    public static final ValidatorReport validate(LanguageObject object, QueryMetadataInterface metadata) throws TeiidComponentException {
        ValidatorReport report1 = Validator.validate(object, metadata, new ValidationVisitor());
        return report1;
    }

    public static final ValidatorReport validate(LanguageObject object, QueryMetadataInterface metadata, AbstractValidationVisitor visitor) throws TeiidComponentException {
        Validator.executeValidation(object, metadata, visitor);
        if (object instanceof Command) {
            for (Command subCommand : CommandCollectorVisitor.getCommands((Command)object)) {
                Validator.validate(subCommand, metadata, visitor);
            }
        }
        return visitor.getReport();
    }

    private static final void executeValidation(LanguageObject object, final QueryMetadataInterface metadata, final AbstractValidationVisitor visitor) throws TeiidComponentException {
        visitor.reset();
        visitor.setMetadata(metadata);
        Validator.setTempMetadata(metadata, visitor, object);
        PreOrderNavigator nav = new PreOrderNavigator(visitor){

            @Override
            protected void visitNode(LanguageObject obj) {
                QueryMetadataInterface previous = visitor.getMetadata();
                Validator.setTempMetadata(metadata, visitor, obj);
                super.visitNode(obj);
                visitor.setMetadata(previous);
            }
        };
        object.acceptVisitor(nav);
        TeiidComponentException e = visitor.getException();
        if (e != null) {
            throw e;
        }
    }

    private static void setTempMetadata(QueryMetadataInterface metadata, AbstractValidationVisitor visitor, LanguageObject obj) {
        if (obj instanceof Command) {
            Command command;
            visitor.currentCommand = command = (Command)obj;
            Map tempMetadata = command.getTemporaryMetadata();
            if (tempMetadata != null && !tempMetadata.isEmpty()) {
                visitor.setMetadata(new TempMetadataAdapter(metadata, new TempMetadataStore(tempMetadata)));
            }
        }
    }
}

