/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process.multisource;

import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.process.multisource.MultiSourceElement;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.From;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.Select;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.ExpressionMappingVisitor;

public class MultiSourceElementReplacementVisitor
extends ExpressionMappingVisitor {
    private String bindingName;

    public MultiSourceElementReplacementVisitor(String bindingName) {
        super(null);
        this.bindingName = bindingName;
    }

    @Override
    public Expression replaceExpression(Expression expr) {
        ElementSymbol elem;
        Object metadataID;
        if (expr instanceof ElementSymbol && (metadataID = (elem = (ElementSymbol)expr).getMetadataID()) instanceof MultiSourceElement) {
            Constant bindingConst = new Constant(this.bindingName, DataTypeManager.DefaultDataClasses.STRING);
            return bindingConst;
        }
        return expr;
    }

    @Override
    public void visit(Insert obj) {
        for (int i = 0; i < obj.getVariables().size(); ++i) {
            ElementSymbol elem;
            Object metadataID;
            Expression expr = (Expression)obj.getVariables().get(i);
            if (!(expr instanceof ElementSymbol) || !((metadataID = (elem = (ElementSymbol)expr).getMetadataID()) instanceof MultiSourceElement)) continue;
            Constant source = (Constant)obj.getValues().get(i);
            obj.getVariables().remove(i);
            obj.getValues().remove(i);
            if (source.getValue().equals(this.bindingName)) continue;
            Select select = new Select(obj.getVariables());
            From from = new From();
            from.addGroup(obj.getGroup());
            Query query = new Query();
            query.setSelect(select);
            query.setFrom(from);
            query.setCriteria(QueryRewriter.FALSE_CRITERIA);
            obj.setQueryExpression(query);
        }
    }
}

