/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process.multisource;

import java.util.ArrayList;
import java.util.Set;
import org.teiid.adminapi.impl.ModelMetaData;
import org.teiid.adminapi.impl.VDBMetaData;
import org.teiid.api.exception.query.QueryPlannerException;
import org.teiid.api.exception.query.QueryValidatorException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.id.IDGenerator;
import org.teiid.core.types.DataTypeManager;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.multisource.MultiSourceElementReplacementVisitor;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.optimizer.capabilities.CapabilitiesFinder;
import org.teiid.query.optimizer.relational.PlanToProcessConverter;
import org.teiid.query.optimizer.relational.plantree.PlanNode;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.GroupingNode;
import org.teiid.query.processor.relational.NullNode;
import org.teiid.query.processor.relational.ProjectIntoNode;
import org.teiid.query.processor.relational.ProjectNode;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalNodeUtil;
import org.teiid.query.processor.relational.RelationalPlan;
import org.teiid.query.processor.relational.UnionAllNode;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.rewriter.QueryRewriter;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.navigator.DeepPreOrderNavigator;
import org.teiid.query.sql.symbol.AggregateSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ExpressionSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.util.CommandContext;

public class MultiSourcePlanToProcessConverter
extends PlanToProcessConverter {
    private Set<String> multiSourceModels;
    private DQPWorkContext workContext;
    private boolean multiSource;
    private boolean update;

    public MultiSourcePlanToProcessConverter(QueryMetadataInterface metadata, IDGenerator idGenerator, AnalysisRecord analysisRecord, CapabilitiesFinder capFinder, Set<String> multiSourceModels, DQPWorkContext workContext, CommandContext context) {
        super(metadata, idGenerator, analysisRecord, capFinder);
        this.multiSourceModels = multiSourceModels;
        this.workContext = workContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized RelationalPlan convert(PlanNode planNode) throws QueryPlannerException, TeiidComponentException {
        RelationalPlan result = null;
        try {
            RelationalPlan relationalPlan = result = super.convert(planNode);
            return relationalPlan;
        }
        finally {
            if (result != null && this.update && this.multiSource) {
                result.setMultisourceUpdate(true);
            }
            this.update = false;
            this.multiSource = false;
        }
    }

    @Override
    protected RelationalNode convertNode(PlanNode planNode) throws QueryPlannerException, TeiidComponentException {
        RelationalNode node = super.convertNode(planNode);
        if (node instanceof AccessNode) {
            try {
                return this.multiSourceModify((AccessNode)node);
            }
            catch (TeiidProcessingException e) {
                throw new QueryPlannerException(e, e.getMessage());
            }
        }
        if (node instanceof ProjectIntoNode) {
            throw new AssertionError((Object)"Multisource insert with query expression not allowed not allowed, should have been caught in validation.");
        }
        return node;
    }

    private RelationalNode multiSourceModify(AccessNode accessNode) throws TeiidComponentException, TeiidProcessingException {
        String modelName = accessNode.getModelName();
        if (!this.multiSourceModels.contains(modelName)) {
            return accessNode;
        }
        VDBMetaData vdb = this.workContext.getVDB();
        ModelMetaData model = vdb.getModel(modelName);
        ArrayList<AccessNode> accessNodes = new ArrayList<AccessNode>();
        for (String sourceName : model.getSourceNames()) {
            AccessNode instanceNode = (AccessNode)accessNode.clone();
            instanceNode.setID(this.getID());
            instanceNode.setConnectorBindingId(sourceName);
            Command command = (Command)instanceNode.getCommand().clone();
            DeepPreOrderNavigator.doVisit(command, new MultiSourceElementReplacementVisitor(sourceName));
            if (!RelationalNodeUtil.shouldExecute(command, false)) continue;
            try {
                command = QueryRewriter.rewrite(command, this.metadata, null);
                instanceNode.setCommand(command);
            }
            catch (QueryValidatorException e) {
                // empty catch block
            }
            if (!RelationalNodeUtil.shouldExecute(command, false)) continue;
            accessNodes.add(instanceNode);
        }
        switch (accessNodes.size()) {
            case 0: {
                NullNode nullNode = new NullNode(this.getID());
                nullNode.setElements(accessNode.getElements());
                return nullNode;
            }
            case 1: {
                AccessNode newNode = (AccessNode)accessNodes.get(0);
                return newNode;
            }
        }
        this.multiSource = true;
        UnionAllNode unionNode = new UnionAllNode(this.getID());
        unionNode.setElements(accessNode.getElements());
        for (AccessNode newNode : accessNodes) {
            unionNode.addChild(newNode);
        }
        RelationalNode parent = unionNode;
        if (RelationalNodeUtil.isUpdate(accessNode.getCommand())) {
            this.update = true;
            GroupingNode groupNode = new GroupingNode(this.getID());
            AggregateSymbol sumCount = new AggregateSymbol("SumCount", "SUM", false, (Expression)accessNode.getElements().get(0));
            ArrayList<ExpressionSymbol> outputElements = new ArrayList<ExpressionSymbol>(1);
            outputElements.add(sumCount);
            groupNode.setElements(outputElements);
            groupNode.addChild(unionNode);
            ProjectNode projectNode = new ProjectNode(this.getID());
            Function intSum = ResolverUtil.getConversion(sumCount, DataTypeManager.getDataTypeName(sumCount.getType()), "integer", false, this.metadata.getFunctionLibrary());
            ExpressionSymbol rowCount = new ExpressionSymbol("RowCount", intSum);
            outputElements = new ArrayList(1);
            outputElements.add(rowCount);
            projectNode.setElements(outputElements);
            projectNode.setSelectSymbols(outputElements);
            projectNode.addChild(groupNode);
            parent = projectNode;
        }
        return parent;
    }
}

