/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.teiid.core.util.LRUCache;
import org.teiid.query.mapping.relational.QueryNode;
import org.teiid.query.sql.lang.CacheHint;

public class TempMetadataID
implements Serializable {
    private static final int LOCAL_CACHE_SIZE = 8;
    private static TableData DUMMY_DATA = new TableData();
    private String ID;
    private Type metadataType = Type.VIRTUAL;
    private Object originalMetadataID;
    private TableData data;
    private int position;
    private Class<?> type;

    public TempMetadataID(String ID, List<TempMetadataID> elements) {
        this(ID, elements, Type.VIRTUAL);
    }

    public TempMetadataID(String ID, List<TempMetadataID> elements, Type type) {
        this.data = new TableData();
        this.ID = ID;
        this.data.elements = elements;
        int pos = 1;
        for (TempMetadataID tempMetadataID : elements) {
            tempMetadataID.setPosition(pos++);
        }
        this.metadataType = type;
    }

    public TempMetadataID(String ID, Class<?> type) {
        this.ID = ID;
        this.type = type;
    }

    public TempMetadataID(String ID, Class<?> type, Object metadataID) {
        this.ID = ID;
        this.type = type;
        this.originalMetadataID = metadataID;
    }

    public String getID() {
        return this.ID;
    }

    public Class<?> getType() {
        return this.type;
    }

    public List<TempMetadataID> getElements() {
        return this.getTableData().elements;
    }

    protected void addElement(TempMetadataID elem) {
        if (this.getTableData().elements != null) {
            this.getTableData().elements.add(elem);
            elem.setPosition(this.getTableData().elements.size());
        }
        if (this.getTableData().localCache != null) {
            this.getTableData().localCache.clear();
        }
    }

    public boolean isVirtual() {
        return this.metadataType == Type.VIRTUAL;
    }

    public boolean isTempTable() {
        return this.metadataType == Type.TEMP;
    }

    public String toString() {
        return this.ID;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TempMetadataID)) {
            return false;
        }
        return this.getID().equals(((TempMetadataID)obj).getID());
    }

    public int hashCode() {
        return this.ID.hashCode();
    }

    public void setOriginalMetadataID(Object metadataId) {
        this.originalMetadataID = metadataId;
    }

    public Object getOriginalMetadataID() {
        return this.originalMetadataID;
    }

    public Collection<TempMetadataID> getAccessPatterns() {
        if (this.getTableData().accessPatterns == null) {
            return Collections.emptyList();
        }
        return this.getTableData().accessPatterns;
    }

    public void setAccessPatterns(Collection<TempMetadataID> accessPatterns) {
        this.getTableData().accessPatterns = accessPatterns;
    }

    public int getCardinality() {
        return this.getTableData().cardinality;
    }

    public void setCardinality(int cardinality) {
        this.getTableData().cardinality = cardinality;
    }

    public void setTempTable(boolean isTempTable) {
        this.metadataType = isTempTable ? Type.TEMP : Type.VIRTUAL;
    }

    Object getProperty(Object key) {
        if (this.getTableData().localCache != null) {
            return this.getTableData().localCache.get(key);
        }
        return null;
    }

    Object setProperty(Object key, Object value) {
        if (this.getTableData().localCache == null) {
            this.getTableData().localCache = new LRUCache(8);
        }
        return this.getTableData().localCache.put(key, value);
    }

    public boolean isScalarGroup() {
        return this.metadataType == Type.SCALAR;
    }

    public void setMetadataType(Type metadataType) {
        this.metadataType = metadataType;
    }

    public List<TempMetadataID> getPrimaryKey() {
        return this.getTableData().primaryKey;
    }

    public void setPrimaryKey(List<TempMetadataID> primaryKey) {
        this.getTableData().primaryKey = primaryKey;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public QueryNode getQueryNode() {
        return this.getTableData().queryNode;
    }

    public void setQueryNode(QueryNode queryNode) {
        this.getTableData().queryNode = queryNode;
    }

    public CacheHint getCacheHint() {
        return this.getTableData().cacheHint;
    }

    public void setCacheHint(CacheHint cacheHint) {
        this.getTableData().cacheHint = cacheHint;
    }

    public List<List<TempMetadataID>> getIndexes() {
        return this.getTableData().indexes;
    }

    public void addIndex(List<TempMetadataID> index) {
        if (this.getTableData().indexes == null) {
            this.getTableData().indexes = new LinkedList<List<TempMetadataID>>();
        }
        this.getTableData().indexes.add(index);
    }

    public List<List<TempMetadataID>> getUniqueKeys() {
        return this.getTableData().keys;
    }

    public void addUniqueKey(List<TempMetadataID> key) {
        if (this.getTableData().keys == null) {
            this.getTableData().keys = new LinkedList<List<TempMetadataID>>();
        }
        this.getTableData().keys.add(key);
    }

    private TableData getTableData() {
        if (this.data == null) {
            return DUMMY_DATA;
        }
        return this.data;
    }

    public static enum Type {
        VIRTUAL,
        TEMP,
        SCALAR;

    }

    static class TableData {
        Collection<TempMetadataID> accessPatterns;
        List<TempMetadataID> elements;
        int cardinality = 0;
        List<TempMetadataID> primaryKey;
        QueryNode queryNode;
        LRUCache<Object, Object> localCache;
        CacheHint cacheHint;
        List<List<TempMetadataID>> keys;
        List<List<TempMetadataID>> indexes;

        TableData() {
        }
    }
}

