/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.processor.xml.PlanExecutor;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.util.VariableContext;

class XMLContext {
    Map resultsMap = new HashMap();
    XMLContext parentContext;
    Map executorMap = new HashMap();
    VariableContext variableContext = new VariableContext();

    public XMLContext() {
        this.resultsMap = new HashMap();
    }

    public XMLContext(XMLContext parent) {
        this.resultsMap = new HashMap();
        this.parentContext = parent;
        this.variableContext.setParentContext(parent.variableContext);
    }

    public XMLContext getParentContext() {
        return this.parentContext;
    }

    public List getCurrentRow(String aliasResultName) throws TeiidComponentException, TeiidProcessingException {
        PlanExecutor executor = (PlanExecutor)this.resultsMap.get(aliasResultName);
        if (executor == null) {
            if (this.parentContext != null) {
                return this.parentContext.getCurrentRow(aliasResultName);
            }
            throw new TeiidComponentException(QueryPlugin.Util.getString("results_not_found", new Object[]{aliasResultName}));
        }
        return executor.currentRow();
    }

    public List getNextRow(String aliasResultName) throws TeiidComponentException, TeiidProcessingException {
        PlanExecutor executor = (PlanExecutor)this.resultsMap.get(aliasResultName);
        if (executor == null) {
            if (this.parentContext != null) {
                return this.parentContext.getNextRow(aliasResultName);
            }
            throw new TeiidComponentException(QueryPlugin.Util.getString("results_not_found", new Object[]{aliasResultName}));
        }
        return executor.nextRow();
    }

    public void setResultSet(String resultName, PlanExecutor executor) {
        this.resultsMap.put(resultName, executor);
    }

    public void removeResultSet(String resultName) throws TeiidComponentException {
        PlanExecutor executor = (PlanExecutor)this.resultsMap.remove(resultName);
        if (executor != null) {
            executor.close();
        }
    }

    public List getOutputElements(String resultName) throws TeiidComponentException {
        PlanExecutor executor = (PlanExecutor)this.resultsMap.get(resultName);
        if (executor == null) {
            if (this.parentContext != null) {
                return this.parentContext.getOutputElements(resultName);
            }
            throw new TeiidComponentException(QueryPlugin.Util.getString("results_not_found", new Object[]{resultName}));
        }
        return executor.getOutputElements();
    }

    public Map getReferenceValues() {
        HashMap map = new HashMap();
        this.variableContext.getFlattenedContextMap(map);
        return map;
    }

    public PlanExecutor getResultExecutor(String resultName) {
        return (PlanExecutor)this.executorMap.get(resultName);
    }

    public void setResultExecutor(String resultName, PlanExecutor executor) {
        this.executorMap.put(resultName, executor);
    }

    public void removeResultExecutor(String resultName) {
        this.executorMap.remove(resultName);
    }

    public VariableContext getVariableContext() {
        return this.variableContext;
    }

    void setVariableValues(String resultSetName, List row) throws TeiidComponentException {
        List elements = this.getOutputElements(resultSetName);
        for (int index = 0; index < elements.size(); ++index) {
            ElementSymbol symbol = (ElementSymbol)elements.get(index);
            this.variableContext.setValue(new ElementSymbol(resultSetName + "." + symbol.getShortName()), row.get(index));
        }
    }
}

