/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.report;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.teiid.query.QueryPlugin;
import org.teiid.query.report.ReportItem;

public class ActivityReport
implements Serializable {
    private String reportType;
    private Collection items = new ArrayList();
    private Collection types = new ArrayList();

    public ActivityReport(String reportType) {
        this.reportType = reportType;
    }

    public String getReportType() {
        return this.reportType;
    }

    public void addItem(ReportItem item) {
        if (item == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.007.0001"));
        }
        this.items.add(item);
        this.types.add(item.getType());
    }

    public void addItems(Collection items) {
        if (items == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.007.0001"));
        }
        Iterator iter = items.iterator();
        while (iter.hasNext()) {
            this.addItem((ReportItem)iter.next());
        }
    }

    public boolean hasItems() {
        return this.items.size() > 0;
    }

    public Collection getItems() {
        return this.items;
    }

    public Collection getItemsByType(String type) {
        ArrayList<ReportItem> typedItems = new ArrayList<ReportItem>();
        for (ReportItem item : this.items) {
            if (!item.getType().equals(type)) continue;
            typedItems.add(item);
        }
        return typedItems;
    }

    public Collection getItemTypes() {
        return this.types;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append(this.getReportType());
        str.append("\n");
        for (String type : this.getItemTypes()) {
            str.append(type);
            str.append(" items:\n");
            Collection typeItems = this.getItemsByType(type);
            for (ReportItem item : typeItems) {
                str.append("\t");
                str.append(item.toString());
                str.append("\n");
            }
        }
        return str.toString();
    }
}

