/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.resolver.command;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.api.exception.query.QueryResolverException;
import org.teiid.core.TeiidComponentException;
import org.teiid.query.analysis.AnalysisRecord;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.metadata.TempMetadataAdapter;
import org.teiid.query.resolver.ProcedureContainerResolver;
import org.teiid.query.resolver.QueryResolver;
import org.teiid.query.resolver.VariableResolver;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.resolver.util.ResolverVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.Constant;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;

public class UpdateResolver
extends ProcedureContainerResolver
implements VariableResolver {
    @Override
    public void resolveProceduralCommand(Command command, TempMetadataAdapter metadata, AnalysisRecord analysis) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        Update update = (Update)command;
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        groups.add(update.getGroup());
        ResolverVisitor.resolveLanguageObject(update, groups, update.getExternalGroupContexts(), metadata);
        QueryResolver.resolveSubqueries(command, metadata, analysis);
    }

    @Override
    protected String getPlan(QueryMetadataInterface metadata, GroupSymbol group) throws TeiidComponentException, QueryMetadataException {
        return metadata.getUpdatePlan(group.getMetadataID());
    }

    @Override
    public Map getVariableValues(Command command, QueryMetadataInterface metadata) throws QueryMetadataException, QueryResolverException, TeiidComponentException {
        String changingKey;
        String varName;
        HashMap<String, Expression> result = new HashMap<String, Expression>();
        Update update = (Update)command;
        LinkedList<ElementSymbol> updateVars = new LinkedList<ElementSymbol>();
        for (Map.Entry<ElementSymbol, Expression> entry : update.getChangeList().getClauseMap().entrySet()) {
            ElementSymbol leftSymbol = entry.getKey();
            varName = leftSymbol.getShortCanonicalName();
            changingKey = "CHANGING." + varName;
            String inputsKey = "INPUTS." + varName;
            result.put(changingKey, new Constant(Boolean.TRUE));
            result.put(inputsKey, entry.getValue());
            updateVars.add(leftSymbol);
        }
        List<ElementSymbol> insertElmnts = ResolverUtil.resolveElementsInGroup(update.getGroup(), metadata);
        insertElmnts.removeAll(updateVars);
        for (ElementSymbol varSymbol : insertElmnts) {
            varName = varSymbol.getShortCanonicalName();
            changingKey = "CHANGING." + varName;
            result.put(changingKey, new Constant(Boolean.FALSE));
        }
        return result;
    }
}

