/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.ProcedureContainer;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.SPParameter;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class StoredProcedure
extends ProcedureContainer {
    private Map<Integer, SPParameter> mapOfParameters = new TreeMap<Integer, SPParameter>();
    private Integer resultSetParameterKey;
    private String procedureName;
    private Object procedureID;
    private Object modelID;
    private String callableName;
    private boolean returnsScalarValue;
    private GroupSymbol group;
    private boolean displayNamedParameters;
    private boolean calledWithReturn;
    private boolean isCallableStatement;
    private boolean isProcedureRelational;

    @Override
    public int getType() {
        return 6;
    }

    private SPParameter getResultSetParameter() {
        if (this.resultSetParameterKey != null) {
            return this.mapOfParameters.get(this.resultSetParameterKey);
        }
        return null;
    }

    public void setProcedureName(String procedureName) {
        this.procedureName = procedureName;
    }

    public String getProcedureName() {
        return this.procedureName;
    }

    public String getProcedureCallableName() {
        return this.callableName;
    }

    public void setProcedureCallableName(String callableName) {
        this.callableName = callableName;
    }

    public Object getModelID() {
        return this.modelID;
    }

    public void setModelID(Object modelID) {
        this.modelID = modelID;
    }

    public void setProcedureID(Object procedureID) {
        this.procedureID = procedureID;
    }

    public Object getProcedureID() {
        return this.procedureID;
    }

    public void setParameter(SPParameter parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0011"));
        }
        Integer key = new Integer(parameter.getIndex());
        if (parameter.getParameterType() == 5) {
            this.resultSetParameterKey = key;
        }
        this.mapOfParameters.put(key, parameter);
    }

    public List<SPParameter> getParameters() {
        ArrayList<SPParameter> listOfParameters = new ArrayList<SPParameter>(this.mapOfParameters.values());
        return listOfParameters;
    }

    public SPParameter getParameter(int index) {
        return this.mapOfParameters.get(new Integer(index));
    }

    public int getNumberOfColumns() {
        SPParameter resultSetParameter = this.getResultSetParameter();
        if (resultSetParameter != null) {
            return resultSetParameter.getResultSetColumns().size();
        }
        return 0;
    }

    public ElementSymbol getResultSetColumn(int index) {
        SPParameter resultSetParameter = this.getResultSetParameter();
        if (resultSetParameter != null) {
            return resultSetParameter.getResultSetColumn(index);
        }
        return null;
    }

    public List getResultSetColumns() {
        SPParameter resultSetParameter = this.getResultSetParameter();
        if (resultSetParameter != null) {
            LinkedList<ElementSymbol> result = new LinkedList<ElementSymbol>();
            Iterator i = resultSetParameter.getResultSetColumns().iterator();
            while (i.hasNext()) {
                ElementSymbol symbol = (ElementSymbol)((ElementSymbol)i.next()).clone();
                symbol.setGroupSymbol(this.getGroup());
                result.add(symbol);
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        StoredProcedure copy = new StoredProcedure();
        copy.setModelID(this.getModelID());
        copy.setProcedureName(this.getProcedureName());
        copy.setProcedureCallableName(this.getProcedureCallableName());
        copy.setProcedureID(this.getProcedureID());
        copy.setGroup(this.getGroup().clone());
        if (this.getTemporaryMetadata() != null) {
            copy.setTemporaryMetadata(new HashMap(this.getTemporaryMetadata()));
        }
        copy.callableName = this.callableName;
        copy.calledWithReturn = this.calledWithReturn;
        List<SPParameter> params = this.getParameters();
        for (int i = 0; i < params.size(); ++i) {
            copy.setParameter((SPParameter)params.get(i).clone());
        }
        copy.resultSetParameterKey = this.resultSetParameterKey;
        this.copyMetadataState(copy);
        copy.displayNamedParameters = this.displayNamedParameters;
        copy.isCallableStatement = this.isCallableStatement;
        copy.isProcedureRelational = this.isProcedureRelational;
        return copy;
    }

    @Override
    public boolean returnsResultSet() {
        return !this.getResultSetColumns().isEmpty();
    }

    public boolean returnsScalarValue() {
        for (SPParameter param : this.mapOfParameters.values()) {
            if (param.getParameterType() != 4) continue;
            return true;
        }
        return false;
    }

    public boolean returnParameters() {
        return this.isCallableStatement || !this.returnsResultSet();
    }

    public List getProjectedSymbols() {
        ArrayList<ElementSymbol> result = new ArrayList<ElementSymbol>();
        List rsColumns = this.getResultSetColumns();
        result.addAll(rsColumns);
        if (!this.returnParameters()) {
            return result;
        }
        for (SPParameter parameter : this.mapOfParameters.values()) {
            ElementSymbol symbol;
            if (parameter.getParameterType() == 4) {
                symbol = parameter.getParameterSymbol();
                symbol.setGroupSymbol(this.getGroup());
                result.add(0, symbol);
                continue;
            }
            if (parameter.getParameterType() != 3 && parameter.getParameterType() != 2) continue;
            symbol = parameter.getParameterSymbol();
            symbol.setGroupSymbol(this.getGroup());
            result.add(symbol);
        }
        return result;
    }

    @Override
    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public int hashCode() {
        return this.getGroup().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StoredProcedure)) {
            return false;
        }
        StoredProcedure other = (StoredProcedure)obj;
        return this.sameOptionAndHint(other) && this.getGroup().equals(other.getGroup()) && ((Object)this.mapOfParameters).equals(other.mapOfParameters);
    }

    public void clearParameters() {
        this.mapOfParameters.clear();
    }

    public void setGroup(GroupSymbol group) {
        this.group = group;
    }

    @Override
    public GroupSymbol getGroup() {
        if (this.group == null) {
            return new GroupSymbol(this.getProcedureName());
        }
        return this.group;
    }

    @Override
    public boolean areResultsCachable() {
        return Query.areResultsCachable(this.getProjectedSymbols());
    }

    public boolean displayNamedParameters() {
        return this.displayNamedParameters;
    }

    public void setDisplayNamedParameters(boolean displayNamedParameters) {
        this.displayNamedParameters = displayNamedParameters;
    }

    public String getParamFullName(SPParameter param) {
        String paramName = param.getName();
        if (paramName.lastIndexOf(".") < 0) {
            paramName = this.getProcedureName() + "." + paramName;
        }
        return paramName;
    }

    public List<SPParameter> getInputParameters() {
        List<SPParameter> parameters = this.getParameters();
        Iterator<SPParameter> params = parameters.iterator();
        while (params.hasNext()) {
            SPParameter param = params.next();
            if (param.getParameterType() == 1 || param.getParameterType() == 3) continue;
            params.remove();
        }
        return parameters;
    }

    public boolean isProcedureRelational() {
        return this.isProcedureRelational;
    }

    public void setProcedureRelational(boolean isProcedureRelational) {
        this.isProcedureRelational = isProcedureRelational;
    }

    public boolean isCallableStatement() {
        return this.isCallableStatement;
    }

    public void setCallableStatement(boolean isCallableStatement) {
        this.isCallableStatement = isCallableStatement;
    }

    @Override
    public LinkedHashMap<ElementSymbol, Expression> getProcedureParameters() {
        LinkedHashMap<ElementSymbol, Expression> map = new LinkedHashMap<ElementSymbol, Expression>();
        for (SPParameter element : this.getInputParameters()) {
            map.put(element.getParameterSymbol(), element.getExpression());
        }
        return map;
    }

    public void setCalledWithReturn(boolean calledWithReturn) {
        this.calledWithReturn = calledWithReturn;
    }

    public boolean isCalledWithReturn() {
        return this.calledWithReturn;
    }
}

