/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.proc;

import java.util.ArrayList;
import java.util.List;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.proc.AssignmentStatement;
import org.teiid.query.sql.proc.CommandStatement;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class Block
implements LanguageObject {
    private List<Statement> statements = new ArrayList<Statement>();

    public Block() {
    }

    public Block(Statement statement) {
        this();
        this.statements.add(statement);
    }

    public List<Statement> getStatements() {
        return this.statements;
    }

    public void setStatements(List<Statement> statements) {
        this.statements = statements;
    }

    public void addStatement(Statement statement) {
        AssignmentStatement stmt;
        Command cmd;
        if (statement instanceof AssignmentStatement && (cmd = (stmt = (AssignmentStatement)statement).getCommand()) != null) {
            this.statements.add(new CommandStatement(cmd));
            stmt.setCommand(null);
            stmt.setExpression(null);
            String fullName = "VARIABLES.ROWCOUNT";
            if (stmt.getVariable().getCanonicalName().equals("ROWCOUNT") || stmt.getVariable().getCanonicalName().equals(fullName)) {
                return;
            }
            stmt.setExpression(new ElementSymbol(fullName));
        }
        this.statements.add(statement);
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        Block copy = new Block();
        for (Statement statement : this.statements) {
            copy.addStatement((Statement)statement.clone());
        }
        return copy;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Block)) {
            return false;
        }
        return EquivalenceUtil.areEqual(this.getStatements(), ((Block)obj).getStatements());
    }

    public int hashCode() {
        return ((Object)this.statements).hashCode();
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }
}

