/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import org.teiid.core.util.StringUtil;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public abstract class Symbol
implements LanguageObject {
    private String name;
    private String canonicalName;
    private String outputName;

    protected Symbol(String name, String canonicalName) {
        this.name = name;
        this.canonicalName = canonicalName;
    }

    public Symbol(String name) {
        this.setName(name);
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0017"));
        }
        this.name = name;
        this.outputName = null;
        this.canonicalName = null;
    }

    public String getName() {
        return this.name;
    }

    public String getCanonicalName() {
        this.computeCanonicalNameAndHash();
        return this.canonicalName;
    }

    public abstract boolean isResolved();

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    public int hashCode() {
        this.computeCanonicalNameAndHash();
        return this.canonicalName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Symbol)) {
            return false;
        }
        return ((Symbol)obj).getCanonicalName().equals(this.getCanonicalName());
    }

    @Override
    public abstract Object clone();

    protected String getCanonical() {
        return this.canonicalName;
    }

    private void computeCanonicalNameAndHash() {
        if (this.canonicalName == null) {
            this.canonicalName = StringUtil.toUpperCase((String)this.name);
        }
    }

    public String getOutputName() {
        return this.outputName == null ? this.getName() : this.outputName;
    }

    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }
}

