/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.cache;

import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;

@ManagementObject(componentType=@ManagementComponent(type="teiid", subtype="dqp"), properties=ManagementProperties.EXPLICIT)
public class CacheConfiguration {
    private Policy policy;
    private int maxage;
    private int maxEntries;
    private boolean enabled = true;
    private String name;
    private String location;

    public CacheConfiguration() {
    }

    public CacheConfiguration(Policy policy, int maxAgeInSeconds, int maxNodes, String location) {
        this.policy = policy;
        this.maxage = maxAgeInSeconds;
        this.maxEntries = maxNodes;
        this.location = location;
    }

    public Policy getPolicy() {
        return this.policy;
    }

    @ManagementProperty(description="The maximum age of a result set cache entry in seconds. -1 indicates no max. (default 7200)")
    public int getMaxAgeInSeconds() {
        return this.maxage;
    }

    public void setMaxAgeInSeconds(int maxage) {
        this.maxage = maxage;
    }

    @ManagementProperty(description="The maximum number of result set cache entries. -1 indicates no limit. (default 1024)")
    public int getMaxEntries() {
        return this.maxEntries;
    }

    public void setMaxEntries(int entries) {
        this.maxEntries = entries;
    }

    public void setType(String type) {
        this.policy = Policy.valueOf(type);
    }

    @ManagementProperty(description="Name of the configuration", readOnly=true)
    @ManagementObjectID(type="cache")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ManagementProperty(description="location prefix in cache", readOnly=true)
    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.maxage;
        result = 31 * result + this.maxEntries;
        result = 31 * result + (this.policy == null ? 0 : this.policy.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CacheConfiguration other = (CacheConfiguration)obj;
        if (this.maxage != other.maxage) {
            return false;
        }
        if (this.maxEntries != other.maxEntries) {
            return false;
        }
        return !(this.policy == null ? other.policy != null : !this.policy.equals((Object)other.policy));
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public static enum Policy {
        LRU,
        EXPIRATION;

    }
}

