/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.teiid.common.buffer.FileStore;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.types.BaseLob;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.core.types.SQLXMLImpl;
import org.teiid.core.types.Streamable;
import org.teiid.core.types.XMLType;
import org.teiid.core.util.ObjectConverterUtil;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.symbol.Expression;

public class LobManager {
    private Map<String, Streamable<?>> lobReferences = new ConcurrentHashMap();

    public void updateReferences(int[] lobIndexes, List<?> tuple) throws TeiidComponentException {
        for (int i = 0; i < lobIndexes.length; ++i) {
            Object anObj = tuple.get(lobIndexes[i]);
            if (!(anObj instanceof Streamable)) continue;
            Streamable lob = (Streamable)anObj;
            if (lob.getReference() == null) {
                lob.setReference(this.getLobReference(lob.getReferenceStreamId()).getReference());
                continue;
            }
            String id = lob.getReferenceStreamId();
            this.lobReferences.put(id, lob);
        }
    }

    public Streamable<?> getLobReference(String id) throws TeiidComponentException {
        Streamable<?> lob = this.lobReferences.get(id);
        if (lob == null) {
            throw new TeiidComponentException(QueryPlugin.Util.getString("ProcessWorker.wrongdata"));
        }
        return lob;
    }

    public static int[] getLobIndexes(List expressions) {
        if (expressions == null) {
            return null;
        }
        int[] result = new int[expressions.size()];
        int resultIndex = 0;
        for (int i = 0; i < expressions.size(); ++i) {
            Expression expr = (Expression)expressions.get(i);
            if (!DataTypeManager.isLOB((Class)expr.getType()) && expr.getType() != DataTypeManager.DefaultDataClasses.OBJECT) continue;
            result[resultIndex++] = i;
        }
        if (resultIndex == 0) {
            return null;
        }
        return Arrays.copyOf(result, resultIndex);
    }

    public void persist(FileStore lobStore) throws TeiidComponentException {
        byte[] bytes = new byte[102400];
        for (Map.Entry<String, Streamable<?>> entry : this.lobReferences.entrySet()) {
            entry.setValue(this.persistLob(entry.getValue(), lobStore, bytes));
        }
    }

    private Streamable<?> persistLob(final Streamable<?> lob, final FileStore store, byte[] bytes) throws TeiidComponentException {
        BlobType persistedLob;
        if (lob.getReference() instanceof BaseLob) {
            try {
                BaseLob baseLob = (BaseLob)lob.getReference();
                InputStreamFactory isf = baseLob.getStreamFactory();
                if (isf.isPersistent()) {
                    return lob;
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
        }
        long offset = store.getLength();
        int length = 0;
        try {
            InputStreamFactory isf = new InputStreamFactory(){

                public InputStream getInputStream() throws IOException {
                    if (lob instanceof BlobType) {
                        return new InputStreamFactory.BlobInputStreamFactory((Blob)lob).getInputStream();
                    }
                    if (lob instanceof ClobType) {
                        return new InputStreamFactory.ClobInputStreamFactory((Clob)lob).getInputStream();
                    }
                    return new InputStreamFactory.SQLXMLInputStreamFactory((SQLXML)lob).getInputStream();
                }
            };
            InputStream is = isf.getInputStream();
            OutputStream fsos = store.createOutputStream();
            length = ObjectConverterUtil.write((OutputStream)fsos, (InputStream)is, (byte[])bytes, (int)-1);
        }
        catch (IOException e) {
            throw new TeiidComponentException((Throwable)e);
        }
        final long lobOffset = offset;
        final int lobLength = length;
        InputStreamFactory isf = new InputStreamFactory(){

            public InputStream getInputStream() throws IOException {
                return store.createInputStream(lobOffset, lobLength);
            }

            public boolean isPersistent() {
                return true;
            }
        };
        try {
            if (lob instanceof BlobType) {
                persistedLob = new BlobType((Blob)new BlobImpl(isf));
            } else if (lob instanceof ClobType) {
                persistedLob = new ClobType((Clob)new ClobImpl(isf, ((ClobType)lob).length()));
            } else {
                persistedLob = new XMLType((SQLXML)new SQLXMLImpl(isf));
                ((XMLType)persistedLob).setEncoding(((XMLType)lob).getEncoding());
                ((XMLType)persistedLob).setType(((XMLType)lob).getType());
            }
        }
        catch (SQLException e) {
            throw new TeiidComponentException((Throwable)e);
        }
        return persistedLob;
    }
}

