/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.api.exception.query.QueryMetadataException;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.dqp.internal.process.multisource.MultiSourceElement;
import org.teiid.logging.AuditMessage;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.metadata.TempMetadataID;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.lang.Create;
import org.teiid.query.sql.lang.Delete;
import org.teiid.query.sql.lang.Drop;
import org.teiid.query.sql.lang.Insert;
import org.teiid.query.sql.lang.Into;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.StoredProcedure;
import org.teiid.query.sql.lang.Update;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Function;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Symbol;
import org.teiid.query.sql.visitor.ElementCollectorVisitor;
import org.teiid.query.sql.visitor.GroupCollectorVisitor;
import org.teiid.query.validator.AbstractValidationVisitor;

public class AuthorizationValidationVisitor
extends AbstractValidationVisitor {
    private HashMap<String, DataPolicy> allowedPolicies;
    private String userName;
    private boolean allowCreateTemporaryTablesDefault = true;

    public AuthorizationValidationVisitor(HashMap<String, DataPolicy> policies, String user) {
        this.allowedPolicies = policies;
        this.userName = user;
    }

    public void setAllowCreateTemporaryTablesDefault(boolean allowCreateTemporaryTablesDefault) {
        this.allowCreateTemporaryTablesDefault = allowCreateTemporaryTablesDefault;
    }

    @Override
    public void visit(Create obj) {
        Set<String> resources = Collections.singleton(obj.getTable().getName());
        List<GroupSymbol> symbols = Arrays.asList(obj.getTable());
        this.validateTemp(resources, symbols, Context.CREATE);
    }

    private void validateTemp(Set<String> resources, Collection<GroupSymbol> symbols, Context context) {
        this.logRequest(resources, context);
        boolean allowed = false;
        for (DataPolicy p : this.allowedPolicies.values()) {
            DataPolicyMetadata policy = (DataPolicyMetadata)p;
            if (policy.isAllowCreateTemporaryTables() == null) {
                if (!this.allowCreateTemporaryTablesDefault) continue;
                allowed = true;
                break;
            }
            if (!policy.isAllowCreateTemporaryTables().booleanValue()) continue;
            allowed = true;
            break;
        }
        this.logResult(resources, context, allowed);
        if (!allowed) {
            this.handleValidationError(QueryPlugin.Util.getString("ERR.018.005.0095", new Object[]{this.userName, "CREATE_TEMPORARY_TABLES"}), symbols);
        }
    }

    private void logRequest(Set<String> resources, Context context) {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.AUDIT_LOG", (int)5)) {
            AuditMessage msg = new AuditMessage(context.name(), "getInaccessibleResources-request", this.userName, resources.toArray(new String[resources.size()]));
            LogManager.logDetail((String)"org.teiid.AUDIT_LOG", (Object[])new Object[]{msg});
        }
    }

    @Override
    public void visit(Drop obj) {
        Set<String> resources = Collections.singleton(obj.getTable().getName());
        List<GroupSymbol> symbols = Arrays.asList(obj.getTable());
        this.validateTemp(resources, symbols, Context.CREATE);
    }

    @Override
    public void visit(Delete obj) {
        this.validateEntitlements(obj);
    }

    @Override
    public void visit(Insert obj) {
        this.validateEntitlements(obj);
    }

    @Override
    public void visit(Query obj) {
        this.validateEntitlements(obj);
    }

    @Override
    public void visit(Update obj) {
        this.validateEntitlements(obj);
    }

    @Override
    public void visit(StoredProcedure obj) {
        this.validateEntitlements(obj);
    }

    @Override
    public void visit(Function obj) {
        if ("lookup".equalsIgnoreCase(obj.getName())) {
            try {
                ResolverUtil.ResolvedLookup lookup = ResolverUtil.resolveLookup(obj, this.getMetadata());
                LinkedList<Symbol> symbols = new LinkedList<Symbol>();
                symbols.add(lookup.getGroup());
                symbols.add(lookup.getKeyElement());
                symbols.add(lookup.getReturnElement());
                this.validateEntitlements(symbols, DataPolicy.PermissionType.READ, Context.QUERY);
            }
            catch (TeiidComponentException e) {
                this.handleException((TeiidException)((Object)e), obj);
            }
            catch (TeiidProcessingException e) {
                this.handleException((TeiidException)((Object)e), obj);
            }
        }
    }

    protected void validateEntitlements(Insert obj) {
        this.validateEntitlements(obj.getVariables(), DataPolicy.PermissionType.CREATE, Context.INSERT);
    }

    protected void validateEntitlements(Update obj) {
        if (obj.getCriteria() != null) {
            this.validateEntitlements(ElementCollectorVisitor.getElements((LanguageObject)obj.getCriteria(), true), DataPolicy.PermissionType.READ, Context.UPDATE);
        }
        this.validateEntitlements(obj.getChangeList().getClauseMap().keySet(), DataPolicy.PermissionType.UPDATE, Context.UPDATE);
    }

    protected void validateEntitlements(Delete obj) {
        if (obj.getCriteria() != null) {
            this.validateEntitlements(ElementCollectorVisitor.getElements((LanguageObject)obj.getCriteria(), true), DataPolicy.PermissionType.READ, Context.DELETE);
        }
        this.validateEntitlements(Arrays.asList(obj.getGroup()), DataPolicy.PermissionType.DELETE, Context.DELETE);
    }

    protected void validateEntitlements(Query obj) {
        Into intoObj = obj.getInto();
        if (intoObj != null) {
            GroupSymbol intoGroup = intoObj.getGroup();
            List<ElementSymbol> intoElements = null;
            try {
                intoElements = ResolverUtil.resolveElementsInGroup(intoGroup, this.getMetadata());
            }
            catch (QueryMetadataException err) {
                this.handleException((TeiidException)((Object)err), intoGroup);
            }
            catch (TeiidComponentException err) {
                this.handleException((TeiidException)((Object)err), intoGroup);
            }
            this.validateEntitlements(intoElements, DataPolicy.PermissionType.CREATE, Context.INSERT);
        }
        Collection<GroupSymbol> entitledObjects = GroupCollectorVisitor.getGroups((LanguageObject)obj, true);
        if (!this.isXMLCommand(obj)) {
            entitledObjects.addAll(ElementCollectorVisitor.getElements((LanguageObject)obj, true));
        }
        if (entitledObjects.size() == 0) {
            return;
        }
        this.validateEntitlements(entitledObjects, DataPolicy.PermissionType.READ, Context.QUERY);
    }

    protected void validateEntitlements(StoredProcedure obj) {
        this.validateEntitlements(Arrays.asList(obj.getGroup()), DataPolicy.PermissionType.READ, Context.STORED_PROCEDURE);
    }

    protected void validateEntitlements(Collection<? extends Symbol> symbols, DataPolicy.PermissionType actionCode, Context auditContext) {
        Set<String> inaccessibleResources;
        HashMap<String, Symbol> nameToSymbolMap = new HashMap<String, Symbol>();
        for (Symbol symbol : symbols) {
            try {
                GroupSymbol group;
                String fullName = null;
                Object metadataID = null;
                if (symbol instanceof ElementSymbol ? (metadataID = ((ElementSymbol)symbol).getMetadataID()) instanceof MultiSourceElement || metadataID instanceof TempMetadataID : symbol instanceof GroupSymbol && (metadataID = (group = (GroupSymbol)symbol).getMetadataID()) instanceof TempMetadataID && !group.isProcedure()) continue;
                fullName = this.getMetadata().getFullName(metadataID);
                Object modelId = this.getMetadata().getModelID(metadataID);
                String modelName = this.getMetadata().getFullName(modelId);
                if ("SYS".equals(modelName) || "pg_catalog".equals(modelName)) continue;
                nameToSymbolMap.put(fullName, symbol);
            }
            catch (QueryMetadataException e) {
                this.handleException((TeiidException)((Object)e));
            }
            catch (TeiidComponentException e) {
                this.handleException((TeiidException)((Object)e));
            }
        }
        if (!nameToSymbolMap.isEmpty() && (inaccessibleResources = this.getInaccessibleResources(actionCode, nameToSymbolMap.keySet(), auditContext)).size() > 0) {
            ArrayList arrayList = new ArrayList(inaccessibleResources.size());
            for (String name : inaccessibleResources) {
                arrayList.add(nameToSymbolMap.get(name));
            }
            this.handleValidationError(QueryPlugin.Util.getString("ERR.018.005.0095", new Object[]{this.userName, actionCode}), arrayList);
        }
    }

    public Set<String> getInaccessibleResources(DataPolicy.PermissionType action, Set<String> resources, Context context) {
        this.logRequest(resources, context);
        HashSet<String> results = new HashSet<String>(resources);
        for (DataPolicy p : this.allowedPolicies.values()) {
            DataPolicyMetadata policy = (DataPolicyMetadata)p;
            if (results.isEmpty()) break;
            Iterator<String> i = results.iterator();
            while (i.hasNext()) {
                if (!policy.allows(i.next(), action)) continue;
                i.remove();
            }
        }
        this.logResult(resources, context, results.isEmpty());
        return results;
    }

    private void logResult(Set<String> resources, Context context, boolean granted) {
        if (LogManager.isMessageToBeRecorded((String)"org.teiid.AUDIT_LOG", (int)5)) {
            if (granted) {
                AuditMessage msg = new AuditMessage(context.name(), "getInaccessibleResources-granted all", this.userName, resources.toArray(new String[resources.size()]));
                LogManager.logDetail((String)"org.teiid.AUDIT_LOG", (Object[])new Object[]{msg});
            } else {
                AuditMessage msg = new AuditMessage(context.name(), "getInaccessibleResources-denied", this.userName, resources.toArray(new String[resources.size()]));
                LogManager.logDetail((String)"org.teiid.AUDIT_LOG", (Object[])new Object[]{msg});
            }
        }
    }

    public static enum Context {
        CREATE,
        DROP,
        QUERY,
        INSERT,
        UPDATE,
        DELETE,
        STORED_PROCEDURE;

    }
}

